/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.HostPolicyBackend;
import com.sun.apoc.daemon.apocd.PolicyBackend;
import com.sun.apoc.daemon.apocd.UserPolicyBackend;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.misc.Name;
import com.sun.apoc.spi.AssignmentProvider;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.PolicyMgrFactory;
import com.sun.apoc.spi.PolicyMgrFactoryImpl;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.DomainTreeProvider;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.OrganizationTreeProvider;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;

public class PolicyBackendFactory {
    public static int sTypeHost = 0;
    public static int sTypeUser = 1;
    public static final String sLocalHostName = "localHost";
    public static final String sLocalUserName = "localUsers";
    public static final Properties sLocalProperties = new Properties();
    private HashMap mPolicyBackends = new HashMap();
    private HashMap mPolicyMgrs = new HashMap();
    private static PolicyBackendFactory sInstance;
    private static PolicyMgrFactory sPolicyMgrFactory;
    private static final String sLocalPolicyDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePolicyBackend(PolicyBackend policyBackend) {
        HashMap hashMap = this.mPolicyBackends;
        synchronized (hashMap) {
            if (policyBackend.release() == 0) {
                policyBackend.close();
                this.mPolicyBackends.remove(this.createPolicyBackendKey(policyBackend.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePolicyMgr(PolicyMgr policyMgr) {
        HashMap hashMap = this.mPolicyMgrs;
        synchronized (hashMap) {
            RefCountedPolicyMgr refCountedPolicyMgr = (RefCountedPolicyMgr)policyMgr;
            if (refCountedPolicyMgr.release() == 0) {
                try {
                    refCountedPolicyMgr.close();
                }
                catch (SPIException sPIException) {
                    // empty catch block
                }
                this.mPolicyMgrs.remove(this.createPolicyMgrKey(refCountedPolicyMgr.mName));
            }
        }
    }

    public static PolicyBackendFactory getInstance() {
        if (sInstance == null) {
            sInstance = new PolicyBackendFactory();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyBackend openPolicyBackend(Name name, CallbackHandler callbackHandler) throws APOCException {
        String string = this.createPolicyBackendKey(name);
        PolicyBackend policyBackend = null;
        HashMap hashMap = this.mPolicyBackends;
        synchronized (hashMap) {
            policyBackend = (PolicyBackend)this.mPolicyBackends.get(string);
            if (policyBackend == null) {
                Properties properties;
                Properties properties2 = properties = name.isLocal() ? sLocalProperties : (Properties)DaemonConfig.getLocalConfig().clone();
                if (callbackHandler != null) {
                    properties.put("AuthCallbackHandler", callbackHandler);
                }
                policyBackend = name.isHost() ? new HostPolicyBackend(name, properties) : new UserPolicyBackend(name, properties);
                this.mPolicyBackends.put(string, policyBackend);
            }
            if (policyBackend != null) {
                policyBackend.acquire();
            }
        }
        return policyBackend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyMgr openPolicyMgr(Properties properties, Name name) throws APOCException {
        String string = this.createPolicyMgrKey(name);
        RefCountedPolicyMgr refCountedPolicyMgr = null;
        HashMap hashMap = this.mPolicyMgrs;
        synchronized (hashMap) {
            try {
                refCountedPolicyMgr = (RefCountedPolicyMgr)this.mPolicyMgrs.get(string);
                if (refCountedPolicyMgr == null) {
                    refCountedPolicyMgr = new RefCountedPolicyMgr(name, sPolicyMgrFactory.createPolicyMgr((Hashtable)properties));
                    this.mPolicyMgrs.put(string, refCountedPolicyMgr);
                }
                if (refCountedPolicyMgr != null) {
                    refCountedPolicyMgr.acquire();
                }
            }
            catch (Exception exception) {
                throw new APOCException(exception);
            }
        }
        return refCountedPolicyMgr;
    }

    private PolicyBackendFactory() {
    }

    private String createPolicyBackendKey(Name name) {
        return name.toString();
    }

    private String createPolicyMgrKey(Name name) {
        return name.getUserName() + "/" + name.getLocation();
    }

    static {
        sPolicyMgrFactory = new PolicyMgrFactoryImpl();
        sLocalPolicyDir = "file://" + DaemonConfig.getStringProperty("DataDir") + "/" + "Policies/";
        sLocalProperties.setProperty("PROVIDER_URL", sLocalPolicyDir);
        try {
            new File(new URI(sLocalPolicyDir + "/assignments")).mkdirs();
            new File(new URI(sLocalPolicyDir + "/profiles")).mkdirs();
            new File(new URI(sLocalPolicyDir + "/entities.txt")).createNewFile();
        }
        catch (Exception exception) {
            APOCLogger.throwing("PolicyBackendFactory", "init", exception);
        }
    }

    class RefCountedPolicyMgr
    implements PolicyMgr {
        private int mRefCount = 0;
        private Name mName;
        private PolicyMgr mPolicyMgr;

        RefCountedPolicyMgr(Name name, PolicyMgr policyMgr) {
            this.mName = name;
            this.mPolicyMgr = policyMgr;
        }

        int acquire() {
            return ++this.mRefCount;
        }

        int release() {
            return --this.mRefCount;
        }

        public Domain getRootDomain() throws SPIException {
            return this.mPolicyMgr.getRootDomain();
        }

        public Organization getRootOrganization() throws SPIException {
            return this.mPolicyMgr.getRootOrganization();
        }

        public void close() throws SPIException {
            this.mPolicyMgr.close();
        }

        public Hashtable getEnvironment() throws SPIException {
            return this.mPolicyMgr.getEnvironment();
        }

        public Entity getEntity(String string) throws SPIException {
            return this.mPolicyMgr.getEntity(string);
        }

        public Profile getProfile(String string) throws SPIException {
            return this.mPolicyMgr.getProfile(string);
        }

        public ProfileRepository getDefaultProfileRepository() throws SPIException {
            return this.mPolicyMgr.getDefaultProfileRepository();
        }

        public ProfileRepository getProfileRepository(String string) throws SPIException {
            return this.mPolicyMgr.getProfileRepository(string);
        }

        public OrganizationTreeProvider getOrganizationTreeProvider() {
            return this.mPolicyMgr.getOrganizationTreeProvider();
        }

        public DomainTreeProvider getDomainTreeProvider() {
            return this.mPolicyMgr.getDomainTreeProvider();
        }

        public ProfileProvider getProfileProvider() {
            return this.mPolicyMgr.getProfileProvider();
        }

        public AssignmentProvider getAssignmentProvider() {
            return this.mPolicyMgr.getAssignmentProvider();
        }
    }
}

