/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.PolicyBackendFactory;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.Name;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.User;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.policies.PolicyInfo;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class PolicyBackend {
    protected static final PolicyInfo[] sPolicyInfoModel = new PolicyInfo[0];
    protected static final Policy[] sPolicyModel = new Policy[0];
    protected static final Profile[] sProfileModel = new Profile[0];
    protected Name mName;
    protected PolicyMgr mPolicyMgr;
    protected Entity mEntity;
    protected Profile[] mProfiles;
    private int mRefCount = 0;
    private Object mLock = new Object();
    private boolean mProfilesInitialised = false;

    public synchronized int acquire() {
        return ++this.mRefCount;
    }

    public synchronized int release() {
        return --this.mRefCount;
    }

    public PolicyBackend(Name name, Properties properties) throws APOCException {
        this.mName = name;
        try {
            this.mPolicyMgr = PolicyBackendFactory.getInstance().openPolicyMgr(properties, this.mName);
        }
        catch (Exception exception) {
            throw new APOCException(exception);
        }
    }

    public void close() {
        PolicyBackendFactory.getInstance().closePolicyMgr(this.mPolicyMgr);
    }

    public synchronized HashSet getComponentList() throws APOCException {
        try {
            this.initProfiles();
            HashSet<String> hashSet = null;
            if (this.mProfiles != null && this.mProfiles.length > 0) {
                hashSet = new HashSet<String>();
                for (int i = 0; i < this.mProfiles.length; ++i) {
                    Iterator iterator = this.mProfiles[i].getPolicies();
                    if (iterator == null) continue;
                    while (iterator.hasNext()) {
                        hashSet.add(((Policy)iterator.next()).getId());
                    }
                }
            }
            return hashSet;
        }
        catch (SPIException sPIException) {
            throw new APOCException(sPIException);
        }
    }

    public synchronized PolicyInfo[][] getLayeredPolicies(Set set, boolean bl) throws APOCException {
        try {
            int n;
            this.initProfiles();
            PolicyInfo[][] policyInfoArray = null;
            if (set != null && this.mProfiles != null && this.mProfiles.length > 0 && (n = set.size()) > 0) {
                Object object;
                int n2;
                Hashtable hashtable = new Hashtable(n);
                ArrayList arrayList = new ArrayList(set);
                for (n2 = 0; n2 < n; ++n2) {
                    hashtable.put(arrayList.get(n2), new ArrayList());
                }
                for (n2 = 0; n2 < this.mProfiles.length; ++n2) {
                    Object object2 = object = bl ? this.mProfiles[n2].getPolicyInfos(set.iterator()) : this.mProfiles[n2].getPolicies(set.iterator());
                    while (object.hasNext()) {
                        PolicyInfo policyInfo = (PolicyInfo)object.next();
                        ((ArrayList)hashtable.get(policyInfo.getId())).add(policyInfo);
                    }
                }
                policyInfoArray = bl ? new PolicyInfo[n][] : new Policy[n][];
                for (n2 = 0; n2 < n; ++n2) {
                    object = (ArrayList)hashtable.get(arrayList.get(n2));
                    ((ArrayList)object).trimToSize();
                    policyInfoArray[n2] = ((ArrayList)object).size() > 0 ? (bl ? ((ArrayList)object).toArray(sPolicyInfoModel) : ((ArrayList)object).toArray(sPolicyModel)) : null;
                }
            }
            return policyInfoArray;
        }
        catch (SPIException sPIException) {
            throw new APOCException(sPIException);
        }
    }

    public synchronized Policy[] getLayeredPolicies(String string, boolean bl) throws APOCException {
        try {
            Policy[] policyArray = null;
            if (string != null && this.mProfiles != null && this.mProfiles.length > 0) {
                ArrayList<Policy> arrayList = new ArrayList<Policy>();
                for (int i = 0; i < this.mProfiles.length; ++i) {
                    Policy policy = this.mProfiles[i].getPolicy(string);
                    if (policy == null) continue;
                    arrayList.add(policy);
                }
                arrayList.trimToSize();
                if (arrayList.size() > 0) {
                    policyArray = arrayList.toArray(sPolicyModel);
                }
            }
            return policyArray;
        }
        catch (SPIException sPIException) {
            throw new APOCException(sPIException);
        }
    }

    public Name getName() {
        return this.mName;
    }

    public synchronized void refreshProfiles() throws SPIException {
        if (this.mName.isLocal()) {
            this.refreshLocalProfiles();
        } else {
            this.refreshGlobalProfiles();
        }
    }

    protected abstract Entity findEntity();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProfiles() throws SPIException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mProfilesInitialised) {
                this.refreshProfiles();
                this.mProfilesInitialised = true;
            }
        }
    }

    private void refreshGlobalProfiles() throws SPIException {
        Iterator iterator;
        this.mProfiles = null;
        if (this.mEntity == null) {
            this.mEntity = this.findEntity();
        }
        if (this.mEntity != null && (iterator = this.mEntity.getLayeredProfiles()) != null) {
            Profile profile;
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            if (this.mEntity instanceof User && (profile = ((User)this.mEntity).getUserProfile()) != null) {
                arrayList.add(profile);
            }
            if (arrayList.size() > 0) {
                this.mProfiles = arrayList.toArray(sProfileModel);
            }
        }
    }

    private void refreshLocalProfiles() throws SPIException {
        this.mProfiles = null;
        ProfileProvider profileProvider = this.mPolicyMgr.getProfileProvider();
        Iterator iterator = profileProvider.getAllProfiles();
        if (iterator != null) {
            ArrayList<Profile> arrayList = new ArrayList<Profile>();
            while (iterator.hasNext()) {
                Profile profile = (Profile)iterator.next();
                Applicability applicability = profile.getApplicability();
                if (applicability.equals((Object)Applicability.ALL) || this.mName.isHost() && applicability.equals((Object)Applicability.HOST) || this.mName.isUser() && applicability.equals((Object)Applicability.USER)) {
                    arrayList.add(profile);
                }
                if (arrayList.size() <= 0) continue;
                this.mProfiles = arrayList.toArray(sProfileModel);
            }
        }
    }
}

