/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.EventQueue;
import com.sun.apoc.daemon.apocd.EventWorkerThread;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.DaemonTimerTask;
import java.util.ArrayList;

class EventWorkerThreadPool {
    private final EventQueue mQueue;
    private final ArrayList mPool = new ArrayList();
    private int mMaxPoolSize;
    private int mPoolSize = 0;
    private final DaemonTimerTask mIdleDetector = new DaemonTimerTask(new IdleDetector());
    private static long sIdleDetectorPeriod = (long)DaemonConfig.getIntProperty("IdleThreadDetectionInterval") * 60000L;

    public EventWorkerThreadPool(EventQueue eventQueue, int n) throws APOCException {
        this.mQueue = eventQueue;
        this.mMaxPoolSize = n;
        this.mIdleDetector.setPeriod(sIdleDetectorPeriod);
    }

    public synchronized void ensureThread() throws APOCException {
        if (this.mPoolSize < this.mMaxPoolSize && !this.haveIdleThread()) {
            EventWorkerThread eventWorkerThread = new EventWorkerThread(this.mQueue);
            this.mPool.add(eventWorkerThread);
            ++this.mPoolSize;
            eventWorkerThread.start();
        }
    }

    public synchronized void resizePool(int n) {
        int n2 = n = n > 0 ? n : 1;
        if (n != this.mMaxPoolSize) {
            if (n > this.mMaxPoolSize) {
                this.mMaxPoolSize = n;
            } else if (n < this.mMaxPoolSize) {
                this.shrinkPool(n);
            }
        }
    }

    public synchronized void terminate() {
        this.terminateThreads();
        this.waitForLiveThreads();
    }

    private boolean haveIdleThread() {
        boolean bl = false;
        for (int i = 0; i < this.mPoolSize; ++i) {
            if (!((EventWorkerThread)this.mPool.get(i)).isAvailable()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean haveLiveThread() {
        boolean bl = false;
        for (int i = 0; i < this.mPoolSize; ++i) {
            if (!((EventWorkerThread)this.mPool.get(i)).isAlive()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void shrinkPool(int n) {
        for (int i = this.mPoolSize; i > n; --i) {
            ((EventWorkerThread)this.mPool.remove(0)).terminate(false);
        }
        this.mPool.trimToSize();
        this.mMaxPoolSize = n;
    }

    private void terminateThreads() {
        this.terminateThreads(false);
    }

    private synchronized void terminateThreads(boolean bl) {
        int n = 0;
        for (int i = this.mPoolSize - 1; i >= 0; --i) {
            EventWorkerThread eventWorkerThread = (EventWorkerThread)this.mPool.get(i);
            if (!eventWorkerThread.terminate(bl)) continue;
            this.mPool.remove(i);
            ++n;
        }
        if (n > 0) {
            this.mQueue.releaseWaitingThreads();
            this.mPoolSize -= n;
        }
    }

    private void waitForLiveThreads() {
        for (int i = 0; i < 5 && this.haveLiveThread(); ++i) {
            try {
                this.wait(1000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class IdleDetector
    implements Runnable {
        IdleDetector() {
        }

        public void run() {
            EventWorkerThreadPool.this.terminateThreads(true);
        }
    }
}

