/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.EventHandler;
import com.sun.apoc.daemon.apocd.EventQueue;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.messaging.Messenger;
import com.sun.apoc.daemon.misc.APOCException;

class EventWorkerThread
extends Thread {
    private final EventQueue mQueue;
    private final Messenger mMessenger = new Messenger();
    private final Object mStateLock = new Object();
    private long mTimestamp = System.currentTimeMillis();
    private int mState = sStateIdle;
    private static int sStateIdle = 0;
    private static int sStateBusy = 1;
    private static int sStateTerminating = 2;
    private static long sIdleTimeout = (long)DaemonConfig.getIntProperty("ThreadTimeToLive") * 60000L;

    public EventWorkerThread(EventQueue eventQueue) throws APOCException {
        this.setName("EventWorker");
        this.setDaemon(true);
        this.mQueue = eventQueue;
    }

    public boolean isAvailable() {
        return this.getState() == sStateIdle;
    }

    public void run() {
        while (this.getState() != sStateTerminating) {
            EventHandler eventHandler = this.mQueue.get();
            if (eventHandler == null) continue;
            this.setState(sStateBusy);
            eventHandler.handleEvent(this.mMessenger);
            this.setState(sStateIdle);
        }
    }

    public boolean terminate(boolean bl) {
        boolean bl2 = true;
        if (!bl) {
            this.setState(sStateTerminating);
        } else {
            long l;
            long l2 = l = this.getState() == sStateIdle ? System.currentTimeMillis() - this.mTimestamp : 0L;
            if (l > sIdleTimeout) {
                this.setState(sStateTerminating);
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    private synchronized int getState() {
        return this.mState;
    }

    private synchronized void setState(int n) {
        if (this.mState != sStateTerminating) {
            this.mTimestamp = n == sStateTerminating ? 0L : System.currentTimeMillis();
            this.mState = n;
        }
    }
}

