/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.admin.AdminManager;
import com.sun.apoc.daemon.admin.AdminOpHandler;
import com.sun.apoc.daemon.apocd.ClientManager;
import com.sun.apoc.daemon.config.ConfigEventListener;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.localdatabase.LocalDatabaseFactory;
import com.sun.apoc.daemon.misc.APOCAuthenticator;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.misc.DaemonTimerTask;
import com.sun.apoc.daemon.misc.FileAccess;
import com.sun.apoc.daemon.transport.ChannelManager;
import java.io.IOException;

public class Daemon
implements ConfigEventListener,
AdminOpHandler {
    private ChannelManager mChannelManager;
    private ClientManager mClientManager;
    private AdminManager mAdminManager;
    private final DaemonTimerTask mGarbageCollector = new DaemonTimerTask(new GarbageCollector());

    public static void main(String[] stringArray) {
        try {
            new Daemon(stringArray).run();
        }
        catch (Exception exception) {
            APOCLogger.throwing("Daemon", "main", exception);
        }
    }

    public Daemon(String[] stringArray) throws APOCException, IOException, InterruptedException {
        if (stringArray.length != 2) {
            this.usage();
            System.exit(1);
        }
        this.init(stringArray);
    }

    public void onConfigEvent() {
        this.startGarbageCollectionTimer();
        DaemonConfig.log();
    }

    public int onStop() {
        this.mChannelManager.terminate();
        return 0;
    }

    public int onStatus() {
        return 0;
    }

    public int onReload() {
        int n;
        try {
            DaemonConfig.reload();
            DaemonConfig.log();
            n = 0;
        }
        catch (Exception exception) {
            APOCLogger.throwing("Daemon", "onReload", exception);
            n = 1;
        }
        return n;
    }

    public int onChangeDetect() {
        this.mClientManager.changeDetect();
        return 0;
    }

    public void run() throws APOCException, InterruptedException {
        APOCLogger.info("Dmon001");
        this.startGarbageCollectionTimer();
        this.mChannelManager = new ChannelManager();
        this.mClientManager = new ClientManager(this.mChannelManager);
        this.verifyConfig();
        this.mChannelManager.start();
        DaemonConfig.addConfigEventListener(this);
        this.mAdminManager = new AdminManager(this);
        this.mAdminManager.start();
        this.mChannelManager.join();
        this.mClientManager.terminate();
        this.mChannelManager.closeChannels();
        APOCLogger.info("Dmon002");
    }

    private void usage() {
        System.err.println("Usage: apocd <daemon installation directory>");
    }

    private void init(String[] stringArray) throws IOException, APOCException {
        System.loadLibrary("FileAccess");
        this.initConfig(stringArray);
        this.initAuthDir();
    }

    private void initAuthDir() throws APOCException {
        if (!APOCAuthenticator.sAuthDir.exists() ? !APOCAuthenticator.sAuthDir.mkdirs() : !APOCAuthenticator.sAuthDir.isDirectory()) {
            throw new APOCException();
        }
        FileAccess.chmod(APOCAuthenticator.sAuthDir.getAbsolutePath(), 493);
        FileAccess.chmod(APOCAuthenticator.sAuthDir.getParent(), 493);
    }

    private void initConfig(String[] stringArray) throws IOException, APOCException {
        DaemonConfig.init(stringArray);
        DaemonConfig.log();
    }

    private void startGarbageCollectionTimer() {
        long l = DaemonConfig.getIntProperty("GarbageCollectionInterval");
        if (this.mGarbageCollector.setPeriod(60000L * l)) {
            if (this.mGarbageCollector.getPeriod() > 0L) {
                APOCLogger.fine("Dmon003", String.valueOf(l));
            } else {
                APOCLogger.fine("Dmon004");
            }
        }
    }

    private void verifyConfig() throws APOCException {
        LocalDatabaseFactory.getInstance();
    }

    class GarbageCollector
    implements Runnable {
        GarbageCollector() {
        }

        public void run() {
            Daemon.this.mClientManager.onGarbageCollect();
        }
    }
}

