/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.Cache;
import com.sun.apoc.daemon.apocd.CacheFactory;
import com.sun.apoc.daemon.apocd.ChangeDetectEventHandler;
import com.sun.apoc.daemon.apocd.Client;
import com.sun.apoc.daemon.apocd.ClientEventHandler;
import com.sun.apoc.daemon.apocd.EventHandler;
import com.sun.apoc.daemon.apocd.EventQueue;
import com.sun.apoc.daemon.apocd.EventWorkerThreadPool;
import com.sun.apoc.daemon.apocd.GarbageCollectEventHandler;
import com.sun.apoc.daemon.apocd.Session;
import com.sun.apoc.daemon.apocd.SessionListener;
import com.sun.apoc.daemon.config.ConfigEventListener;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.localdatabase.Database;
import com.sun.apoc.daemon.localdatabase.LocalDatabaseFactory;
import com.sun.apoc.daemon.localdatabase.Timestamp;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.misc.DaemonTimerTask;
import com.sun.apoc.daemon.transport.ChannelManager;
import com.sun.apoc.daemon.transport.ClientChannel;
import com.sun.apoc.daemon.transport.ClientChannelEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ClientManager
implements ClientChannelEventListener,
ConfigEventListener,
SessionListener {
    private final HashMap mClients = new HashMap(DaemonConfig.getIntProperty("MaxClientConnections"));
    private final EventQueue mPendingEvents = new EventQueue();
    private final EventWorkerThreadPool mThreadPool = new EventWorkerThreadPool(this.mPendingEvents, DaemonConfig.getIntProperty("MaxClientThreads"));
    private final DaemonTimerTask mChangeDetector = new DaemonTimerTask(new ChangeDetector(this));
    private int mSessionCount = 0;

    public ClientManager(ChannelManager channelManager) throws APOCException {
        channelManager.addClientChannelEventListener(this);
        DaemonConfig.addConfigEventListener(this);
        APOCLogger.fine("Clmr001");
    }

    public void changeDetect() {
        new ChangeDetector(this).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(Cache cache) {
        Object[] objectArray;
        HashSet<Session> hashSet = new HashSet<Session>();
        HashMap hashMap = this.mClients;
        synchronized (hashMap) {
            objectArray = this.mClients.values().toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = ((Client)objectArray[i]).getSessions();
            for (int j = 0; j < objectArray2.length; ++j) {
                if (((Session)objectArray2[j]).getCache() != cache) continue;
                hashSet.add((Session)objectArray2[j]);
            }
        }
        return hashSet.toArray(new Session[0]);
    }

    public void onPending(ClientChannel clientChannel) {
        this.putEventHandler(new ClientEventHandler(this.getClient(clientChannel)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(ClientChannel clientChannel) {
        HashMap hashMap = this.mClients;
        synchronized (hashMap) {
            Client client = (Client)this.mClients.remove(clientChannel);
            if (client != null) {
                client.close();
                APOCLogger.finer("Clmr002");
            }
        }
    }

    public void onConfigEvent() {
        this.startChangeDetectionTimer();
        this.mThreadPool.resizePool(DaemonConfig.getIntProperty("MaxClientThreads"));
    }

    public void onGarbageCollect() {
        try {
            Object[] objectArray = LocalDatabaseFactory.getInstance().getDatabases();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.putEventHandler(new GarbageCollectEventHandler((Database)((Object)objectArray[i])));
                }
            }
        }
        catch (Exception exception) {
            APOCLogger.throwing("ClientManager", "onGarbageCollect", exception);
        }
    }

    public synchronized void onSessionCreate(Session session) {
        ++this.mSessionCount;
        this.doInitialChangeDetect(session);
    }

    public synchronized void onSessionDestroy(Session session) {
        --this.mSessionCount;
        this.stopChangeDetectionTimer();
    }

    public void terminate() {
        this.mThreadPool.terminate();
        APOCLogger.fine("Clmr007");
    }

    private void doInitialChangeDetect(Session session) {
        try {
            long l = Timestamp.getMillis(session.getCache().getLastChangeDetect());
            long l2 = l + (long)(DaemonConfig.getFloatProperty("ChangeDetectionInterval") * 60000.0f);
            if (l == 0L || l2 < Timestamp.getMillis(Timestamp.getTimestamp())) {
                DaemonTimerTask daemonTimerTask = new DaemonTimerTask(new ChangeDetector(this, session), true);
                daemonTimerTask.setPeriod(DaemonConfig.getIntProperty("InitialChangeDetectionDelay") * 1000);
            }
            this.startChangeDetectionTimer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client getClient(ClientChannel clientChannel) {
        HashMap hashMap = this.mClients;
        synchronized (hashMap) {
            Client client = (Client)this.mClients.get(clientChannel);
            if (client == null) {
                client = new Client(clientChannel);
                client.addSessionListener(this);
                this.mClients.put(clientChannel, client);
                APOCLogger.finer("Clmr005");
            }
            return client;
        }
    }

    private boolean putEventHandler(EventHandler eventHandler) {
        boolean bl = true;
        this.mPendingEvents.put(eventHandler);
        try {
            this.mThreadPool.ensureThread();
        }
        catch (APOCException aPOCException) {
            bl = false;
            APOCLogger.throwing("ChangeDetector", "run", aPOCException);
        }
        return bl;
    }

    private void startChangeDetectionTimer() {
        float f;
        if (this.mSessionCount > 0 && this.mChangeDetector.setPeriod((long)(60000.0f * (f = DaemonConfig.getFloatProperty("ChangeDetectionInterval"))))) {
            if (this.mChangeDetector.getPeriod() > 0L) {
                APOCLogger.fine("Clmr004", String.valueOf(f));
            } else {
                APOCLogger.fine("Clmr006");
            }
        }
    }

    private void stopChangeDetectionTimer() {
        if (this.mSessionCount < 1) {
            this.mChangeDetector.cancel();
        }
    }

    class ChangeDetector
    implements Runnable {
        private ClientManager mManager;
        private Session mSession = null;

        public ChangeDetector(ClientManager clientManager2, Session session) {
            this.mManager = clientManager2;
            this.mSession = session;
        }

        public ChangeDetector(ClientManager clientManager2) {
            this.mManager = clientManager2;
        }

        public void run() {
            if (this.mSession == null) {
                this.changeDetect();
            } else {
                this.changeDetect(this.mSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changeDetect() {
            Cache[] cacheArray = null;
            Cloneable cloneable = ClientManager.this.mClients;
            synchronized (cloneable) {
                if (!ClientManager.this.mClients.isEmpty()) {
                    cacheArray = CacheFactory.getInstance().getCaches();
                }
            }
            if (cacheArray != null) {
                cloneable = new ArrayList();
                if (cacheArray != null) {
                    int n;
                    for (n = 0; n < cacheArray.length; ++n) {
                        ChangeDetectEventHandler changeDetectEventHandler = new ChangeDetectEventHandler(this.mManager, cacheArray[n]);
                        if (!ClientManager.this.putEventHandler(changeDetectEventHandler)) continue;
                        ((ArrayList)cloneable).add(changeDetectEventHandler);
                    }
                    n = ((ArrayList)cloneable).size();
                    for (int i = 0; i < n; ++i) {
                        ((ChangeDetectEventHandler)((ArrayList)cloneable).get(i)).waitForCompletion();
                    }
                    ClientManager.this.startChangeDetectionTimer();
                }
            }
        }

        private void changeDetect(Session session) {
            ChangeDetectEventHandler changeDetectEventHandler = new ChangeDetectEventHandler(this.mManager, session.getCache());
            if (ClientManager.this.putEventHandler(changeDetectEventHandler)) {
                changeDetectEventHandler.waitForCompletion();
            }
        }
    }
}

