/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.Session;
import com.sun.apoc.daemon.apocd.SessionListener;
import com.sun.apoc.daemon.transport.ClientChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Client {
    private final ClientChannel mChannel;
    private final HashMap mSessions = new HashMap(1);
    private final HashSet mSessionListeners = new HashSet(1);

    public Client(ClientChannel clientChannel) {
        this.mChannel = clientChannel;
    }

    public ClientChannel getClientChannel() {
        return this.mChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSessions() {
        HashMap hashMap = this.mSessions;
        synchronized (hashMap) {
            return this.mSessions.values().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String string) {
        HashMap hashMap = this.mSessions;
        synchronized (hashMap) {
            return string != null ? (Session)this.mSessions.get(string) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(Session session) {
        HashMap hashMap = this.mSessions;
        synchronized (hashMap) {
            this.mSessions.put(session.getSessionId(), session);
        }
        this.notifySessionCreated(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener sessionListener) {
        HashSet hashSet = this.mSessionListeners;
        synchronized (hashSet) {
            this.mSessionListeners.add(sessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(Session session) {
        HashMap hashMap = this.mSessions;
        synchronized (hashMap) {
            this.mSessions.remove(session.getSessionId());
        }
        session.close();
        this.notifySessionDestroyed(session);
    }

    public synchronized void close() {
        Iterator iterator = this.mSessions.keySet().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)this.mSessions.get(iterator.next());
            session.close();
            this.notifySessionDestroyed(session);
        }
        this.mSessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener sessionListener) {
        HashSet hashSet = this.mSessionListeners;
        synchronized (hashSet) {
            this.mSessionListeners.remove(sessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionCreated(Session session) {
        HashSet hashSet = this.mSessionListeners;
        synchronized (hashSet) {
            Iterator iterator = this.mSessionListeners.iterator();
            while (iterator.hasNext()) {
                ((SessionListener)iterator.next()).onSessionCreate(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionDestroyed(Session session) {
        HashSet hashSet = this.mSessionListeners;
        synchronized (hashSet) {
            Iterator iterator = this.mSessionListeners.iterator();
            while (iterator.hasNext()) {
                ((SessionListener)iterator.next()).onSessionDestroy(session);
            }
        }
    }
}

