/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.Cache;
import com.sun.apoc.daemon.apocd.ClientManager;
import com.sun.apoc.daemon.apocd.EventHandler;
import com.sun.apoc.daemon.messaging.Messenger;
import com.sun.apoc.daemon.transaction.ChangeDetectTransaction;
import com.sun.apoc.daemon.transaction.TransactionFactory;

class ChangeDetectEventHandler
implements EventHandler {
    private final ChangeDetectTransaction mTransaction;
    private long sTimeout = 100L;
    private final Object mCompleteLock = new Object();
    private boolean mComplete = false;

    ChangeDetectEventHandler(ClientManager clientManager, Cache cache) {
        this.mTransaction = TransactionFactory.getInstance().createChangeDetectTransaction(clientManager, cache);
    }

    public void handleEvent(Messenger messenger) {
        this.mTransaction.execute();
        this.setComplete();
    }

    public synchronized void waitForCompletion() {
        while (!this.isComplete()) {
            try {
                this.wait(this.sTimeout);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isComplete() {
        Object object = this.mCompleteLock;
        synchronized (object) {
            return this.mComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setComplete() {
        Object object = this.mCompleteLock;
        synchronized (object) {
            this.mComplete = true;
        }
    }
}

