/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.Cache;
import com.sun.apoc.daemon.apocd.SaslAuthCallbackHandler;
import com.sun.apoc.daemon.misc.APOCException;
import java.util.HashMap;

public class CacheFactory {
    private final HashMap mCaches = new HashMap();
    private static final CacheFactory sInstance = new CacheFactory();
    private static final Cache[] sCacheModel = new Cache[0];

    public synchronized void closeCache(Cache cache) {
        Cache cache2;
        if (cache.release() == 0 && (cache2 = (Cache)this.mCaches.remove(this.makeKey(cache.getUserId(), cache.getEntityId()))) != null) {
            cache2.close();
        }
    }

    public synchronized Cache[] getCaches() {
        Cache[] cacheArray = null;
        if (this.mCaches.size() > 0) {
            cacheArray = this.mCaches.values().toArray(sCacheModel);
        }
        return cacheArray;
    }

    public static CacheFactory getInstance() {
        return sInstance;
    }

    public synchronized Cache openCache(String string, String string2, SaslAuthCallbackHandler saslAuthCallbackHandler) throws APOCException {
        Cache cache = null;
        cache = this.getExistingCache(string, string2);
        if (cache == null) {
            cache = this.createNewCache(string, string2, saslAuthCallbackHandler);
        }
        cache.acquire();
        return cache;
    }

    private CacheFactory() {
    }

    private Cache createNewCache(String string, String string2, SaslAuthCallbackHandler saslAuthCallbackHandler) throws APOCException {
        Cache cache = new Cache(string, string2, saslAuthCallbackHandler);
        this.mCaches.put(this.makeKey(string, string2), cache);
        return cache;
    }

    private Cache getExistingCache(String string, String string2) {
        return (Cache)this.mCaches.get(this.makeKey(string, string2));
    }

    private String makeKey(String string, String string2) {
        return string + "/" + (string2 == null ? string : string2);
    }
}

