/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.CacheReadResult;
import com.sun.apoc.daemon.apocd.PolicyBackend;
import com.sun.apoc.daemon.apocd.PolicyBackendFactory;
import com.sun.apoc.daemon.apocd.SaslAuthCallbackHandler;
import com.sun.apoc.daemon.config.ConfigEventListener;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.localdatabase.Database;
import com.sun.apoc.daemon.localdatabase.LocalDatabase;
import com.sun.apoc.daemon.localdatabase.LocalDatabaseFactory;
import com.sun.apoc.daemon.localdatabase.Timestamp;
import com.sun.apoc.daemon.localdatabase.UpdateItem;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.misc.Name;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.policies.PolicyInfo;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;

public class Cache
implements ConfigEventListener {
    private String mUserName;
    private String mUserEntityName;
    private CallbackHandler mHandler;
    private final DataSource[] mDataSources = new DataSource[4];
    private int mRefCount = 0;
    private boolean mIsLocalPolicyEnabled = DaemonConfig.getBooleanProperty("ApplyLocalPolicy");
    private static final String[] sStringModel = new String[0];

    public Cache(String string, String string2, SaslAuthCallbackHandler saslAuthCallbackHandler) {
        this.mUserName = string;
        this.mUserEntityName = string2 == null ? string : string2;
        this.mHandler = saslAuthCallbackHandler;
        this.createDataSources();
        saslAuthCallbackHandler.setReconnectMode();
        DaemonConfig.addConfigEventListener(this);
    }

    public synchronized int acquire() {
        return ++this.mRefCount;
    }

    public synchronized int release() {
        return --this.mRefCount;
    }

    public synchronized ArrayList changeDetect() {
        this.mDataSources[0].open();
        this.mDataSources[1].open();
        this.mDataSources[2].open();
        this.mDataSources[3].open();
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = null;
        int n = (this.mDataSources[0].isOnline() ? 1 : 0) + (this.mDataSources[1].isOnline() ? 1 : 0) + (this.mDataSources[2].isOnline() ? 1 : 0) + (this.mDataSources[3].isOnline() ? 1 : 0);
        if (n > 1) {
            hashSet = this.list();
        }
        for (int i = 0; i < 4; ++i) {
            ArrayList arrayList2 = this.changeDetect(this.mDataSources[i]);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        if (n > 1) {
            arrayList = this.mergeUpdateResults(arrayList, hashSet);
        }
        return arrayList;
    }

    public synchronized void close() {
        for (int i = 0; i < 4; ++i) {
            this.mDataSources[i].close();
        }
    }

    public String getEntityId() {
        return this.mUserEntityName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getLastChangeDetect() {
        String string = null;
        for (int i = 0; i < 4; ++i) {
            LocalDatabase localDatabase = this.mDataSources[i].getLocalDatabase();
            if (localDatabase == null) continue;
            try {
                localDatabase.beginTransaction();
                String string2 = localDatabase.getLastChangeDetect();
                if (string2.compareTo("19700101000000Z") == 0) break;
                if (string == null) {
                    string = string2;
                    continue;
                }
                if (!Timestamp.isNewer(string, string2)) continue;
                string = string2;
                continue;
            }
            catch (APOCException aPOCException) {
                APOCLogger.throwing("Cache", "getLastChangeDetect", aPOCException);
                continue;
            }
            finally {
                try {
                    localDatabase.endTransaction();
                }
                catch (APOCException aPOCException) {
                    APOCLogger.throwing("Cache", "getLastChangeDetect", aPOCException);
                }
            }
        }
        return string != null ? string : "19700101000000Z";
    }

    public String getUserId() {
        return this.mUserName;
    }

    public synchronized boolean hasDatabase(Database database) {
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            if (this.mDataSources[i].getLocalDatabase() != database) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public synchronized HashSet list() {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < 4; ++i) {
            HashSet hashSet2 = this.list(this.mDataSources[i]);
            if (hashSet2 == null) continue;
            hashSet.addAll(hashSet2);
        }
        return hashSet;
    }

    public synchronized void onConfigEvent() {
        boolean bl = DaemonConfig.getBooleanProperty("ApplyLocalPolicy");
        if (bl != this.mIsLocalPolicyEnabled) {
            this.mIsLocalPolicyEnabled = bl;
            if (this.mIsLocalPolicyEnabled) {
                this.enableLocalPolicy();
            } else {
                this.disableLocalPolicy();
            }
        }
    }

    public synchronized ArrayList read(String string) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            ArrayList arrayList2 = this.read(this.mDataSources[i], string);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(" dataSource" + (i + 1)).append("\n ").append(this.mDataSources[i].toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ArrayList changeDetect(DataSource var1_1) {
        var2_2 = null;
        if (var1_1.isOnline()) {
            var3_3 = var1_1.getLocalDatabase();
            try {
                var3_3.beginTransaction();
                switch (var1_1.getState()) {
                    case 0: {
                        var2_2 = this.updateLocalDatabase(var1_1);
                        ** break;
lbl10:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        var2_2 = new ArrayList<E>();
                        this.addRemovalItems(var2_2, var3_3.getLocalComponentList());
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        var2_2 = new ArrayList<E>();
                        this.addAdditionItems(var2_2, var1_1, var3_3.getLocalComponentList());
                        var1_1.setState(0);
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    ** default:
lbl23:
                    // 1 sources

                    break;
                }
            }
            catch (Exception var4_5) {
                APOCLogger.throwing("Cache", "changeDetect", var4_5);
            }
            finally {
                try {
                    var3_3.endTransaction();
                }
                catch (APOCException var4_6) {
                    APOCLogger.throwing("Cache", "changeDetect", var4_6);
                }
            }
            if (var1_1.mState == 3) {
                var1_1.close();
            }
        }
        return var2_2;
    }

    private void createDataSources() {
        this.mDataSources[0] = new LocalHostDataSource();
        this.mDataSources[1] = new GlobalHostDataSource();
        this.mDataSources[2] = new LocalUserDataSource();
        this.mDataSources[3] = new GlobalUserDataSource();
        if (this.mIsLocalPolicyEnabled) {
            this.mDataSources[0].open();
            this.mDataSources[2].open();
        }
        this.mDataSources[1].open();
        this.mDataSources[3].open();
    }

    private void disableLocalPolicy() {
        this.mDataSources[0].setState(3);
        this.mDataSources[2].setState(3);
    }

    private void enableLocalPolicy() {
        this.mDataSources[0].setState(2);
        this.mDataSources[2].setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet list(DataSource dataSource) {
        LocalDatabase localDatabase;
        HashSet hashSet = null;
        if (dataSource.getState() == 0 && (localDatabase = dataSource.getLocalDatabase()) != null) {
            try {
                localDatabase.beginTransaction();
                hashSet = localDatabase.getRemoteComponentList();
            }
            catch (APOCException aPOCException) {
                APOCLogger.throwing("Cache", "list", aPOCException);
            }
            finally {
                try {
                    localDatabase.endTransaction();
                }
                catch (APOCException aPOCException) {
                    APOCLogger.throwing("Cache", "list", aPOCException);
                }
            }
        }
        return hashSet;
    }

    private ArrayList mergeUpdateResults(ArrayList arrayList, HashSet hashSet) {
        ArrayList<UpdateItem> arrayList2 = arrayList;
        if (arrayList.size() > 0 && hashSet != null && hashSet.size() > 0) {
            HashSet hashSet2 = this.list();
            HashSet<String> hashSet3 = new HashSet<String>();
            Iterator iterator = arrayList.iterator();
            arrayList2 = new ArrayList<UpdateItem>();
            while (iterator.hasNext()) {
                UpdateItem updateItem = (UpdateItem)iterator.next();
                String string = updateItem.getComponentName();
                if (!hashSet3.add(string)) continue;
                if (updateItem.getUpdateType() == 1 && hashSet.contains(string) || updateItem.getUpdateType() == 2 && hashSet2.contains(string)) {
                    updateItem.setUpdateType(3);
                }
                arrayList2.add(updateItem);
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList read(DataSource dataSource, String string) {
        ArrayList<CacheReadResult> arrayList = new ArrayList<CacheReadResult>();
        LocalDatabase localDatabase = dataSource.getLocalDatabase();
        if (localDatabase != null) {
            try {
                Policy[] policyArray;
                AbstractCollection abstractCollection;
                localDatabase.beginTransaction();
                boolean bl = localDatabase.hasComponent(string);
                if (!bl && dataSource.isOnline() && (abstractCollection = localDatabase.getRemoteComponentList()) != null && ((HashSet)abstractCollection).contains(string) && (policyArray = dataSource.getPolicyBackend().getLayeredPolicies(string, false)) != null) {
                    localDatabase.update(new UpdateItem(1, string, policyArray), Timestamp.getTimestamp());
                    bl = true;
                }
                if (bl) {
                    abstractCollection = localDatabase.getLayerIds(string);
                    for (int i = 0; i < ((Vector)abstractCollection).size(); ++i) {
                        String string2 = (String)((Vector)abstractCollection).elementAt(i);
                        arrayList.add(new CacheReadResult(localDatabase.getLastModified(string2, string), localDatabase.getLayer(string, string2)));
                    }
                }
            }
            catch (APOCException aPOCException) {
                APOCLogger.throwing("Cache", "read", aPOCException);
            }
            finally {
                try {
                    localDatabase.endTransaction();
                }
                catch (APOCException aPOCException) {
                    APOCLogger.throwing("Cache", "read", aPOCException);
                }
            }
        }
        return arrayList;
    }

    private void addDownloadItems(ArrayList arrayList, DataSource dataSource, HashSet hashSet, HashSet hashSet2) throws APOCException {
        if (hashSet != null && hashSet2 != null) {
            HashSet hashSet3 = (HashSet)hashSet.clone();
            int n = hashSet3.size();
            hashSet3.addAll(hashSet2);
            Policy[][] policyArray = (Policy[][])dataSource.getPolicyBackend().getLayeredPolicies(hashSet3, false);
            Iterator iterator = hashSet3.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                arrayList.add(new UpdateItem(hashSet.contains(string) ? 1 : 3, string, policyArray[n2++]));
            }
        } else if (hashSet != null) {
            this.addAdditionItems(arrayList, dataSource, hashSet);
        } else if (hashSet2 != null) {
            this.addModificationItems(arrayList, dataSource, hashSet2);
        }
    }

    private void addAdditionItems(ArrayList arrayList, DataSource dataSource, HashSet hashSet) throws APOCException {
        if (hashSet != null) {
            Policy[][] policyArray = (Policy[][])dataSource.getPolicyBackend().getLayeredPolicies(hashSet, false);
            Iterator iterator = hashSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                arrayList.add(new UpdateItem(1, (String)iterator.next(), policyArray[n++]));
            }
        }
    }

    private void addModificationItems(ArrayList arrayList, DataSource dataSource, HashSet hashSet) throws APOCException {
        if (hashSet != null) {
            Policy[][] policyArray = (Policy[][])dataSource.getPolicyBackend().getLayeredPolicies(hashSet, false);
            Iterator iterator = hashSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                arrayList.add(new UpdateItem(3, (String)iterator.next(), policyArray[n++]));
            }
        }
    }

    private void addRemovalItems(ArrayList arrayList, HashSet hashSet) throws APOCException {
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new UpdateItem(2, (String)iterator.next(), null));
            }
        }
    }

    private int compareLayers(DataSource dataSource, String string, PolicyInfo[] policyInfoArray) throws APOCException {
        int n = 0;
        LocalDatabase localDatabase = dataSource.getLocalDatabase();
        Vector vector = localDatabase.getLayerIds(string);
        if (vector.size() != policyInfoArray.length) {
            n = 1;
        } else {
            String string2 = policyInfoArray[0].getId();
            for (int i = 0; i < policyInfoArray.length; ++i) {
                String string3 = (String)vector.elementAt(i);
                if (string3.compareTo(String.valueOf(policyInfoArray[i].getProfileId().hashCode())) == 0 && Timestamp.getTimestamp(policyInfoArray[i].getLastModified()).compareTo(localDatabase.getLastModified(string3, string2)) == 0) continue;
                n = 1;
                break;
            }
        }
        return n;
    }

    private void createUpdateItems(ArrayList arrayList, DataSource dataSource, HashSet hashSet) throws APOCException {
        HashSet hashSet2 = dataSource.getLocalDatabase().getLocalComponentList();
        HashSet hashSet3 = this.diff(hashSet, hashSet2);
        HashSet hashSet4 = this.diff(hashSet2, hashSet);
        HashSet hashSet5 = this.getModifications(dataSource, this.diff(hashSet2, hashSet4));
        this.addDownloadItems(arrayList, dataSource, hashSet3, hashSet5);
        this.addRemovalItems(arrayList, hashSet4);
    }

    private HashSet diff(HashSet hashSet, HashSet hashSet2) {
        HashSet hashSet3 = null;
        if (hashSet2 == null) {
            hashSet3 = hashSet;
        } else if (hashSet != null) {
            hashSet3 = (HashSet)hashSet.clone();
            hashSet3.removeAll(hashSet2);
            if (hashSet3.size() == 0) {
                hashSet3 = null;
            }
        }
        return hashSet3;
    }

    private HashSet getModifications(DataSource dataSource, HashSet hashSet) throws APOCException {
        HashSet<String> hashSet2 = null;
        if (hashSet != null) {
            PolicyInfo[][] policyInfoArray = dataSource.getPolicyBackend().getLayeredPolicies(hashSet, true);
            String[] stringArray = hashSet.toArray(sStringModel);
            hashSet2 = new HashSet<String>();
            for (int i = 0; i < policyInfoArray.length; ++i) {
                if (!this.isUpdated(dataSource, stringArray[i], policyInfoArray[i])) continue;
                hashSet2.add(stringArray[i]);
            }
            if (hashSet2.size() == 0) {
                hashSet2 = null;
            }
        }
        return hashSet2;
    }

    private boolean isUpdated(DataSource dataSource, String string, PolicyInfo[] policyInfoArray) throws APOCException {
        boolean bl = false;
        bl = policyInfoArray == null ? true : this.compareLayers(dataSource, string, policyInfoArray) != 0;
        return bl;
    }

    private ArrayList updateLocalDatabase(DataSource dataSource) throws APOCException {
        ArrayList arrayList = new ArrayList();
        try {
            PolicyBackend policyBackend = dataSource.getPolicyBackend();
            policyBackend.refreshProfiles();
            HashSet hashSet = policyBackend.getComponentList();
            this.createUpdateItems(arrayList, dataSource, hashSet);
            arrayList.trimToSize();
            String string = Timestamp.getTimestamp();
            LocalDatabase localDatabase = dataSource.getLocalDatabase();
            localDatabase.update(arrayList, string);
            localDatabase.putLastChangeDetect(string);
            localDatabase.putRemoteComponentList(hashSet != null ? hashSet : new HashSet());
        }
        catch (SPIException sPIException) {
            throw new APOCException(sPIException);
        }
        return arrayList;
    }

    class GlobalUserDataSource
    extends DataSource {
        public GlobalUserDataSource() {
            this.mName = new Name(Cache.this.mUserName, Cache.this.mUserEntityName, false, false);
        }
    }

    class GlobalHostDataSource
    extends DataSource {
        public GlobalHostDataSource() {
            this.mName = new Name(Cache.this.mUserName, DaemonConfig.getHostIdentifier(), false, true);
        }
    }

    class LocalUserDataSource
    extends DataSource {
        public LocalUserDataSource() {
            this.mName = new Name(Cache.this.mUserName, "localUser", true, false);
        }
    }

    class LocalHostDataSource
    extends DataSource {
        public LocalHostDataSource() {
            this.mName = new Name(Cache.this.mUserName, "localHost", true, true);
        }
    }

    abstract class DataSource {
        protected LocalDatabase mLocalDatabase;
        protected PolicyBackend mPolicyBackend;
        protected Name mName;
        protected int mState = 1;
        protected boolean mInitialised = false;
        static final int sStateEnabled = 0;
        static final int sStateDisabled = 1;
        static final int sStateEnabling = 2;
        static final int sStateDisabling = 3;

        DataSource() {
        }

        void close() {
            this.closePolicyBackend();
            this.closeLocalDatabase();
        }

        synchronized LocalDatabase getLocalDatabase() {
            return this.mLocalDatabase;
        }

        synchronized PolicyBackend getPolicyBackend() {
            return this.mPolicyBackend;
        }

        synchronized int getState() {
            return this.mState;
        }

        synchronized boolean isOnline() {
            return this.mPolicyBackend != null && this.mLocalDatabase != null;
        }

        synchronized void open() {
            boolean bl = this.mName.isLocal();
            if (!bl || DaemonConfig.getBooleanProperty("ApplyLocalPolicy")) {
                if (this.mLocalDatabase == null) {
                    this.mLocalDatabase = this.openLocalDatabase();
                }
                try {
                    if (this.mLocalDatabase != null && this.mPolicyBackend == null && (this.mInitialised || this.mLocalDatabase.getLastChangeDetect().compareTo("19700101000000Z") == 0)) {
                        this.mPolicyBackend = this.openPolicyBackend(Cache.this.mHandler);
                        if (!this.mInitialised && this.mPolicyBackend != null) {
                            this.initialiseDatabase();
                        }
                    }
                }
                catch (APOCException aPOCException) {
                    APOCLogger.throwing("DataSource", "open", aPOCException);
                }
                this.mInitialised = true;
                if (!bl || this.mState != 2) {
                    this.mState = 0;
                }
            }
        }

        synchronized void setState(int n) {
            this.mState = n;
        }

        public String toString() {
            return "     Name: " + this.mName.toString() + "\n     Cache: " + (Object)((Object)this.mLocalDatabase) + "\n   Backend: " + this.mPolicyBackend;
        }

        protected void initialiseDatabase() {
            try {
                HashSet hashSet = this.mPolicyBackend.getComponentList();
                if (hashSet != null) {
                    this.mLocalDatabase.beginTransaction();
                    this.mLocalDatabase.putRemoteComponentList(hashSet);
                    this.mLocalDatabase.endTransaction();
                }
            }
            catch (Exception exception) {
                APOCLogger.throwing("DataSource", "initialiseDatabase", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void closeLocalDatabase() {
            if (this.mLocalDatabase != null) {
                try {
                    LocalDatabaseFactory.getInstance().closeLocalDatabase(this.mLocalDatabase);
                }
                catch (Exception exception) {
                }
                finally {
                    this.mLocalDatabase = null;
                }
            }
        }

        protected void closePolicyBackend() {
            if (this.mPolicyBackend != null) {
                PolicyBackendFactory.getInstance().closePolicyBackend(this.mPolicyBackend);
                this.mPolicyBackend = null;
            }
        }

        protected LocalDatabase openLocalDatabase() {
            LocalDatabase localDatabase = null;
            try {
                localDatabase = LocalDatabaseFactory.getInstance().openLocalDatabase(this.mName);
            }
            catch (Exception exception) {
                APOCLogger.throwing("DataSource", "openLocalDatabase", exception);
            }
            return localDatabase;
        }

        protected PolicyBackend openPolicyBackend(CallbackHandler callbackHandler) {
            PolicyBackend policyBackend = null;
            try {
                policyBackend = PolicyBackendFactory.getInstance().openPolicyBackend(this.mName, callbackHandler);
            }
            catch (APOCException aPOCException) {
                APOCLogger.throwing("PolicyBackend", "openPolicyBackend", aPOCException);
            }
            return policyBackend;
        }
    }
}

