/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.admin;

import com.sun.apoc.daemon.admin.AdminOpHandler;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.APOCAuthenticator;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transport.ClientChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class AdminManager
extends Thread {
    private static final byte[] sSuccess = new byte[]{0};
    private static final byte[] sFailure = new byte[]{1};
    private static final byte sOpChangeDetect = 1;
    private static final byte sOpReload = 6;
    private static final byte sOpStatus = 9;
    private static final byte sOpStop = 10;
    private static final byte[] sAcceptByte = new byte[]{1};
    private static final ByteBuffer sAccept = ByteBuffer.wrap(sAcceptByte);
    private Selector mSelector;
    private ServerSocketChannel mChannel;
    private AdminOpHandler mAdminOpHandler;
    private final Object mTerminateLock = new Object();
    private boolean mTerminate = false;

    public AdminManager(AdminOpHandler adminOpHandler) throws APOCException {
        this.setName("AdminManager");
        this.mAdminOpHandler = adminOpHandler;
        this.initChannel();
    }

    public void run() {
        APOCLogger.fine("Admr001");
        while (!this.shouldTerminate()) {
            try {
                ClientChannel clientChannel = this.acceptClientChannel();
                if (clientChannel == null) continue;
                if (this.authenticate(clientChannel)) {
                    try {
                        this.handleRequest(clientChannel);
                    }
                    catch (Exception exception) {
                        APOCLogger.throwing("AdminManager", "run", exception);
                    }
                }
                clientChannel.close();
            }
            catch (IOException iOException) {
                APOCLogger.throwing("AdminManager", "run", iOException);
                break;
            }
        }
        this.closeServerChannel();
        APOCLogger.fine("Admr002");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.mTerminateLock;
        synchronized (object) {
            this.mTerminate = true;
        }
    }

    private ClientChannel acceptClientChannel() throws IOException {
        ClientChannel clientChannel = null;
        if (this.mSelector.select() > 0) {
            Iterator<SelectionKey> iterator = this.mSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (!selectionKey.isAcceptable()) continue;
                SocketChannel socketChannel = null;
                try {
                    socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
                    if (!socketChannel.socket().getInetAddress().isLoopbackAddress()) continue;
                    clientChannel = new ClientChannel(socketChannel, null);
                    clientChannel.write(sAccept);
                    sAccept.flip();
                    break;
                }
                catch (IOException iOException) {
                    if (socketChannel != null) {
                        try {
                            socketChannel.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    APOCLogger.throwing("AdminManager", "acceptClientChannel", iOException);
                }
            }
        }
        return clientChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(ClientChannel clientChannel) {
        boolean bl;
        APOCAuthenticator aPOCAuthenticator = null;
        try {
            aPOCAuthenticator = new APOCAuthenticator(null);
            byte[] byArray = aPOCAuthenticator.getChallenge();
            clientChannel.write((ByteBuffer)ByteBuffer.allocate(byArray.length + 1).put(byArray).put((byte)0).flip());
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[APOCAuthenticator.getAuthBufferSize()]);
            while (clientChannel.read(byteBuffer) == 0L) {
            }
            aPOCAuthenticator.processResponse(byteBuffer.array());
            clientChannel.write((ByteBuffer)ByteBuffer.allocate(1).put(sSuccess).flip());
            bl = true;
        }
        catch (Exception exception) {
            clientChannel.write((ByteBuffer)ByteBuffer.allocate(1).put(sFailure).flip());
            bl = false;
        }
        finally {
            if (aPOCAuthenticator != null) {
                aPOCAuthenticator.cleanup();
            }
        }
        return bl;
    }

    private void closeServerChannel() {
        try {
            this.mSelector.close();
            this.mChannel.close();
        }
        catch (IOException iOException) {
            APOCLogger.throwing("AdminManager", "closeServerChannel", iOException);
        }
    }

    private void handleRequest(ClientChannel clientChannel) throws Exception {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[1]);
        while (clientChannel.read(byteBuffer) != 1L) {
        }
        switch (byteBuffer.array()[0]) {
            case 10: {
                n = this.mAdminOpHandler.onStop();
                this.terminate();
                break;
            }
            case 9: {
                n = this.mAdminOpHandler.onStatus();
                break;
            }
            case 6: {
                n = this.mAdminOpHandler.onReload();
                break;
            }
            case 1: {
                n = this.mAdminOpHandler.onChangeDetect();
                break;
            }
            default: {
                n = -1;
            }
        }
        byteBuffer = ByteBuffer.wrap(n == 0 ? sSuccess : sFailure);
        clientChannel.write(byteBuffer);
    }

    private void initChannel() throws APOCException {
        try {
            this.mSelector = Selector.open();
            this.mChannel = ServerSocketChannel.open();
            this.mChannel.configureBlocking(false);
            this.mChannel.socket().bind(new InetSocketAddress(DaemonConfig.getIntProperty("DaemonAdminPort")));
            this.mChannel.register(this.mSelector, 16);
        }
        catch (IOException iOException) {
            throw new APOCException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldTerminate() {
        Object object = this.mTerminateLock;
        synchronized (object) {
            return this.mTerminate;
        }
    }
}

