#!/usr/bin/ksh
#
# Script to update the CSM firmware patch with new firmware
#
GREP=/usr/bin/grep
SED=/usr/bin/sed
SHOWREV=/usr/bin/showrev
LS=/usr/bin/ls
MV=/usr/bin/mv
CP=/usr/bin/cp
LN=/usr/bin/ln
RM=/usr/bin/rm
cur_dir=`/usr/bin/dirname $0`

patch_id=`${LS} | ${GREP} 117856`
if ! `${SHOWREV} -p | ${GREP} ${patch_id} > /dev/null`; then
    echo "Please install Sun StorEdge 6130 Management Host Software V 1.1 before executing this script"
    exit 1
fi

# Check for IOM-F
if [ -d ${patch_id}/IOM-F ]; then
    if [ -f ${patch_id}/IOM-F/baseline.txt ]; then # New firmware
        new_filename=`${LS} ${patch_id}/IOM-F | ${GREP} s3r | ${GREP} -v old`
        if [ -f /var/sadm/swimages/${patch_id}/IOM-F/${new_filename} ]; then # found new firmware
            old_filename=`${LS} /var/sadm/swimages/${patch_id}/IOM-F | ${GREP} s3r | ${GREP} -v old`
	    if [ ${old_filename} = ${new_filename} ]; then # We need to remove
	        old_filename=`${LS} /var/sadm/swimages/${patch_id}/IOM-F | ${GREP} s3r.old | ${SED} "s/.old//g" `
                ${MV} /var/sadm/swimages/${patch_id}/IOM-F/baseline.txt.old /var/sadm/swimages/${patch_id}/IOM-F/baseline.txt
                ${MV} /var/sadm/swimages/${patch_id}/IOM-F/${old_filename}.old /var/sadm/swimages/${patch_id}/IOM-F/${old_filename}
                ${RM} /var/sadm/swimages/${patch_id}/IOM-F/image.fw
		${RM} /var/sadm/swimages//${patch_id}/IOM-F/${new_filename}
		cd /var/sadm/swimages/${patch_id}/IOM-F
                ${LN} -s ${old_filename} image.fw
		cd ${cur_dir}
		echo "Uninstall completed"
 	    else
	        echo "Uninstall completed"
            fi
	fi
    fi
fi
