/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class Unity_OnlineHelpDetector
extends RealizationDetectorPrtl {
    private final int VERSION_3_0;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[1];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWunhlp", "3.0.0"))) {
                    blArray[0] = true;
                }
                int n = 0;
                while (n < 1) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public Unity_OnlineHelpDetector() throws DetectorFailedException {
        this.VERSION_3_0 = 0;
        this.VERSION_COUNT = 1;
        String[] stringArray = new String[]{"3.0"};
        this.initialize("Unity.OnlineHelp", stringArray);
        this.statusMessage = new String("Looking for Unity.OnlineHelp...");
    }
}

