/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.DspHardwareComponent;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.LoopCardHardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.model.PatchProProperties;
import java.util.Enumeration;

public class T4StorageArrayLoopCardDetector
extends RealizationDetectorPrtl {
    private final String LOOPCARD_FRUMODEL_BASELINE;
    private final String LOOPCARD_VERSION_6_27;
    private final String LOOPCARD_VERSION_6_28;
    private final String LOOPCARD_VERSION_6_29;
    private final String LOOPCARD_VERSION_7_19;
    private final String LOOPCARD_VERSION_7_20;
    private final String LOOPCARD_VERSION_7_21;
    private final String LOOPCARD_VERSION_7_22;
    private final String LOOPCARD_VERSION_7_23;
    private final String LOOPCARD_VERSION_BASELINE;
    private final String PSX_FRUMODEL_MIC_BASELINE;
    private final String PSX_FRUMODEL_MIC_04;
    private final String PSX_FRUMODEL_MIC_03;
    private final String PSX_FRUMODEL_MIC_02;
    private final String PSX_FRUMODEL_MIC_01;
    private final String PSX_FRUMODEL_MIC2_BASELINE;
    private final String PSX_FRUMODEL_MIC2_04;
    private final String PSX_FRUMODEL_MIC2_03;
    private final String PSX_FRUMODEL_MIC2_02;
    private final String PSX_FRUMODEL_MIC2_01;
    private final String DSP_VERSION_BASELINE1;
    private final String DSP_VERSION_BASELINE2;
    private final String DSP_VERSION_BASELINE3;
    private final int VERSION_6_27;
    private final int VERSION_6_28;
    private final int VERSION_6_29;
    private final int VERSION_7_19;
    private final int VERSION_7_20;
    private final int VERSION_7_21;
    private final int VERSION_7_22;
    private final int VERSION_7_23;
    private final int VERSION_99_0;
    private final int VERSION_COUNT;
    private boolean[] have = new boolean[9];
    private boolean debug;
    private PatchProProperties properties;
    Enumeration assocHostList = null;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        this.properties = PatchProProperties.getInstance();
        boolean bl = this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        if (restrictedHost.getType().equals("T4") || restrictedHost.getType().equals("T4PP")) {
            try {
                if (this.debug) {
                    System.out.println("Detect Loopcard exist");
                }
                if (restrictedHost.hasHardwareComponent("5405384")) {
                    this.addHardwareComponent(restrictedHost, "5405384");
                }
                int n = 0;
                while (n < 9) {
                    if (this.have[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    private boolean isDspAtBaselineVersion(RestrictedHost restrictedHost) {
        boolean bl = false;
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof DspHardwareComponent)) continue;
                    DspHardwareComponent dspHardwareComponent = (DspHardwareComponent)e;
                    if (dspHardwareComponent == null || !dspHardwareComponent.getProduct().equals("720-00002-05") && !dspHardwareComponent.getProduct().equals("720-00002-01") && !dspHardwareComponent.getProduct().equals("720-00002-02") && !dspHardwareComponent.getProduct().equals("720-00002-03") && !dspHardwareComponent.getProduct().equals("720-00002-04") && !dspHardwareComponent.getProduct().equals("720-00047-05") && !dspHardwareComponent.getProduct().equals("720-00047-01") && !dspHardwareComponent.getProduct().equals("720-00047-02") && !dspHardwareComponent.getProduct().equals("720-00047-03") && !dspHardwareComponent.getProduct().equals("720-00047-04") || dspHardwareComponent.getDSPVersion().compareTo("D02.01.00.0359") != 0 && dspHardwareComponent.getDSPVersion().compareTo("D02.01.01.0023") != 0 && dspHardwareComponent.getDSPVersion().compareTo("D02.01.02.0034") != 0) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "T4StorageArrayLoopcardDetector.isDspAtBaselineVersion(): " + exception.getMessage());
            }
        } else {
            this.log.println((Object)this, 4, "T4StorageArrayLoopcardDetector: Component list is empty");
        }
        return bl;
    }

    private void addHardwareComponent(RestrictedHost restrictedHost, String string) {
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof LoopCardHardwareComponent)) continue;
                    LoopCardHardwareComponent loopCardHardwareComponent = (LoopCardHardwareComponent)e;
                    if (loopCardHardwareComponent == null || !loopCardHardwareComponent.getProduct().equals(string)) continue;
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("6.27") == 0) {
                        if (!this.have[0]) {
                            this.have[0] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(0)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("6.28") == 0) {
                        if (!this.have[1]) {
                            this.have[1] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(1)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("6.29") == 0) {
                        if (!this.have[2]) {
                            this.have[2] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(2)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("7.19") == 0) {
                        if (!this.have[3]) {
                            this.have[3] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(3)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("7.20") == 0) {
                        if (!this.have[4]) {
                            this.have[4] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(4)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("7.21") == 0) {
                        if (!this.have[5]) {
                            this.have[5] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(5)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("7.22") == 0) {
                        if (!this.have[6]) {
                            this.have[6] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(6)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("7.23") == 0) {
                        if (!this.have[7]) {
                            this.have[7] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(7)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                        continue;
                    }
                    if (loopCardHardwareComponent.getLoopCardVersion().compareTo("7.23") <= 0) continue;
                    if (!this.have[8]) {
                        this.have[8] = true;
                    }
                    ((Realization)this.applicableRealizations.elementAt(8)).addHardwareComponent((HardwareComponent)loopCardHardwareComponent);
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "T4StorageArrayLoopCardDetector.addHardwareComponents(): " + exception.getMessage());
            }
        }
    }

    public T4StorageArrayLoopCardDetector() throws DetectorFailedException {
        this.LOOPCARD_FRUMODEL_BASELINE = "5405384";
        this.LOOPCARD_VERSION_6_27 = "6.27";
        this.LOOPCARD_VERSION_6_28 = "6.28";
        this.LOOPCARD_VERSION_6_29 = "6.29";
        this.LOOPCARD_VERSION_7_19 = "7.19";
        this.LOOPCARD_VERSION_7_20 = "7.20";
        this.LOOPCARD_VERSION_7_21 = "7.21";
        this.LOOPCARD_VERSION_7_22 = "7.22";
        this.LOOPCARD_VERSION_7_23 = "7.23";
        this.LOOPCARD_VERSION_BASELINE = "7.23";
        this.PSX_FRUMODEL_MIC_BASELINE = "720-00002-05";
        this.PSX_FRUMODEL_MIC_04 = "720-00002-04";
        this.PSX_FRUMODEL_MIC_03 = "720-00002-03";
        this.PSX_FRUMODEL_MIC_02 = "720-00002-02";
        this.PSX_FRUMODEL_MIC_01 = "720-00002-01";
        this.PSX_FRUMODEL_MIC2_BASELINE = "720-00047-05";
        this.PSX_FRUMODEL_MIC2_04 = "720-00047-04";
        this.PSX_FRUMODEL_MIC2_03 = "720-00047-03";
        this.PSX_FRUMODEL_MIC2_02 = "720-00047-02";
        this.PSX_FRUMODEL_MIC2_01 = "720-00047-01";
        this.DSP_VERSION_BASELINE1 = "D02.01.00.0359";
        this.DSP_VERSION_BASELINE2 = "D02.01.01.0023";
        this.DSP_VERSION_BASELINE3 = "D02.01.02.0034";
        this.VERSION_6_27 = 0;
        this.VERSION_6_28 = 1;
        this.VERSION_6_29 = 2;
        this.VERSION_7_19 = 3;
        this.VERSION_7_20 = 4;
        this.VERSION_7_21 = 5;
        this.VERSION_7_22 = 6;
        this.VERSION_7_23 = 7;
        this.VERSION_99_0 = 8;
        this.VERSION_COUNT = 9;
        String[] stringArray = new String[]{"6.27", "6.28", "6.29", "7.19", "7.20", "7.21", "7.22", "7.23", "99.0"};
        this.initialize("T4StorageArray.LoopCard", stringArray);
        this.statusMessage = new String("Looking for T4StorageArray.LoopCard...");
    }
}

