/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.ControllerHardwareComponent;
import com.sun.patchpro.host.DSP;
import com.sun.patchpro.host.DspHardwareComponent;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.model.PatchProProperties;
import java.util.Enumeration;

public class T4StorageArrayControllerDetector
extends RealizationDetectorPrtl {
    private final String CONTROLLER_FRUMODEL_BASELINE;
    private final String CONTROLLER_VERSION_3_0_3;
    private final String CONTROLLER_VERSION_3_0_4;
    private final String CONTROLLER_VERSION_3_0_5;
    private final String CONTROLLER_VERSION_3_0_6;
    private final String CONTROLLER_VERSION_3_0_7;
    private final String CONTROLLER_VERSION_3_1_0;
    private final String CONTROLLER_VERSION_3_1_1;
    private final String CONTROLLER_VERSION_3_1_2;
    private final String CONTROLLER_VERSION_3_1_3;
    private final String CONTROLLER_VERSION_3_1_4;
    private final String CONTROLLER_VERSION_3_1_5;
    private final String CONTROLLER_VERSION_3_1_6;
    private final String CONTROLLER_VERSION_3_2_0;
    private final String CONTROLLER_VERSION_BASELINE;
    private final String PSX_FRUMODEL_MIC_BASELINE;
    private final String PSX_FRUMODEL_MIC_04;
    private final String PSX_FRUMODEL_MIC_03;
    private final String PSX_FRUMODEL_MIC_02;
    private final String PSX_FRUMODEL_MIC_01;
    private final String PSX_FRUMODEL_MIC2_BASELINE;
    private final String PSX_FRUMODEL_MIC2_04;
    private final String PSX_FRUMODEL_MIC2_03;
    private final String PSX_FRUMODEL_MIC2_02;
    private final String PSX_FRUMODEL_MIC2_01;
    private final String DSP_VERSION_BASELINE1;
    private final String DSP_VERSION_BASELINE2;
    private final String DSP_VERSION_BASELINE3;
    private final int VERSION_3_0_3;
    private final int VERSION_3_0_4;
    private final int VERSION_3_0_5;
    private final int VERSION_3_0_6;
    private final int VERSION_3_0_7;
    private final int VERSION_3_1_0;
    private final int VERSION_3_1_1;
    private final int VERSION_3_1_2;
    private final int VERSION_3_1_3;
    private final int VERSION_3_1_4;
    private final int VERSION_3_1_5;
    private final int VERSION_3_1_6;
    private final int VERSION_3_2_0;
    private final int VERSION_99_0;
    private final int VERSION_COUNT;
    private boolean[] have = new boolean[14];
    private boolean debug;
    private PatchProProperties properties;
    Enumeration assocHostList = null;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        this.properties = PatchProProperties.getInstance();
        boolean bl = this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        if (restrictedHost.getType().equals("T4") || restrictedHost.getType().equals("T4PP")) {
            try {
                if (this.debug) {
                    System.out.println("Detect Controller exist");
                }
                if (restrictedHost.hasHardwareComponent("5405559")) {
                    this.addHardwareComponent(restrictedHost, "5405559");
                }
                int n = 0;
                while (n < 14) {
                    if (this.have[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                        if (this.debug) {
                            System.out.println(n);
                        }
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    private boolean isDspAtBaselineVersion(RestrictedHost restrictedHost) {
        boolean bl = false;
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof DspHardwareComponent)) continue;
                    DspHardwareComponent dspHardwareComponent = (DspHardwareComponent)e;
                    if (dspHardwareComponent == null || !dspHardwareComponent.getProduct().equals("720-00002-05") && !dspHardwareComponent.getProduct().equals("720-00002-01") && !dspHardwareComponent.getProduct().equals("720-00002-02") && !dspHardwareComponent.getProduct().equals("720-00002-03") && !dspHardwareComponent.getProduct().equals("720-00002-04") && !dspHardwareComponent.getProduct().equals("720-00047-05") && !dspHardwareComponent.getProduct().equals("720-00047-01") && !dspHardwareComponent.getProduct().equals("720-00047-02") && !dspHardwareComponent.getProduct().equals("720-00047-03") && !dspHardwareComponent.getProduct().equals("720-00047-04")) continue;
                    if (this.debug) {
                        System.out.println("Found device version: " + ((DSP)restrictedHost).getSysLevelFirmware());
                    }
                    if (((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.01.00.0359") != 0 && ((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.01.01.0023") != 0 && ((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.01.02.0034") != 0) continue;
                    if (this.debug) {
                        System.out.println("FOUND IT");
                    }
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "T4StorageArrayControllerDetector.isDspAtBaselineVersion(): " + exception.getMessage());
            }
        } else {
            this.log.println((Object)this, 4, "T4StorageArrayControllerDetector: Component list is empty");
        }
        return bl;
    }

    private void addHardwareComponent(RestrictedHost restrictedHost, String string) {
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof ControllerHardwareComponent)) continue;
                    ControllerHardwareComponent controllerHardwareComponent = (ControllerHardwareComponent)e;
                    if (controllerHardwareComponent == null || !controllerHardwareComponent.getProduct().equals(string)) continue;
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030003") == 0) {
                        if (!this.have[0]) {
                            this.have[0] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(0)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030004") == 0) {
                        if (!this.have[1]) {
                            this.have[1] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(1)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030005") == 0) {
                        if (!this.have[2]) {
                            this.have[2] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(2)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030006") == 0) {
                        if (!this.have[3]) {
                            this.have[3] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(3)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030007") == 0) {
                        if (!this.have[4]) {
                            this.have[4] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(4)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030100") == 0) {
                        if (!this.have[5]) {
                            this.have[5] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(5)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030101") == 0) {
                        if (!this.have[6]) {
                            this.have[6] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(6)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030102") == 0) {
                        if (!this.have[7]) {
                            this.have[7] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(7)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030103") == 0) {
                        if (!this.have[8]) {
                            this.have[8] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(8)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030104") == 0) {
                        if (!this.have[9]) {
                            this.have[9] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(9)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030105") == 0) {
                        if (!this.have[10]) {
                            this.have[10] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(10)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030106") == 0) {
                        if (!this.have[11]) {
                            this.have[11] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(11)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030200") == 0) {
                        if (!this.have[12]) {
                            this.have[12] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(12)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                        continue;
                    }
                    if (controllerHardwareComponent.getLevel3Version().compareTo("030200") <= 0) continue;
                    if (!this.have[13]) {
                        this.have[13] = true;
                    }
                    ((Realization)this.applicableRealizations.elementAt(13)).addHardwareComponent((HardwareComponent)controllerHardwareComponent);
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "T4StorageArrayControllerDetector.addHardwareComponents(): " + exception.getMessage());
            }
        }
    }

    public T4StorageArrayControllerDetector() throws DetectorFailedException {
        this.CONTROLLER_FRUMODEL_BASELINE = "5405559";
        this.CONTROLLER_VERSION_3_0_3 = "030003";
        this.CONTROLLER_VERSION_3_0_4 = "030004";
        this.CONTROLLER_VERSION_3_0_5 = "030005";
        this.CONTROLLER_VERSION_3_0_6 = "030006";
        this.CONTROLLER_VERSION_3_0_7 = "030007";
        this.CONTROLLER_VERSION_3_1_0 = "030100";
        this.CONTROLLER_VERSION_3_1_1 = "030101";
        this.CONTROLLER_VERSION_3_1_2 = "030102";
        this.CONTROLLER_VERSION_3_1_3 = "030103";
        this.CONTROLLER_VERSION_3_1_4 = "030104";
        this.CONTROLLER_VERSION_3_1_5 = "030105";
        this.CONTROLLER_VERSION_3_1_6 = "030106";
        this.CONTROLLER_VERSION_3_2_0 = "030200";
        this.CONTROLLER_VERSION_BASELINE = "030200";
        this.PSX_FRUMODEL_MIC_BASELINE = "720-00002-05";
        this.PSX_FRUMODEL_MIC_04 = "720-00002-04";
        this.PSX_FRUMODEL_MIC_03 = "720-00002-03";
        this.PSX_FRUMODEL_MIC_02 = "720-00002-02";
        this.PSX_FRUMODEL_MIC_01 = "720-00002-01";
        this.PSX_FRUMODEL_MIC2_BASELINE = "720-00047-05";
        this.PSX_FRUMODEL_MIC2_04 = "720-00047-04";
        this.PSX_FRUMODEL_MIC2_03 = "720-00047-03";
        this.PSX_FRUMODEL_MIC2_02 = "720-00047-02";
        this.PSX_FRUMODEL_MIC2_01 = "720-00047-01";
        this.DSP_VERSION_BASELINE1 = "D02.01.00.0359";
        this.DSP_VERSION_BASELINE2 = "D02.01.01.0023";
        this.DSP_VERSION_BASELINE3 = "D02.01.02.0034";
        this.VERSION_3_0_3 = 0;
        this.VERSION_3_0_4 = 1;
        this.VERSION_3_0_5 = 2;
        this.VERSION_3_0_6 = 3;
        this.VERSION_3_0_7 = 4;
        this.VERSION_3_1_0 = 5;
        this.VERSION_3_1_1 = 6;
        this.VERSION_3_1_2 = 7;
        this.VERSION_3_1_3 = 8;
        this.VERSION_3_1_4 = 9;
        this.VERSION_3_1_5 = 10;
        this.VERSION_3_1_6 = 11;
        this.VERSION_3_2_0 = 12;
        this.VERSION_99_0 = 13;
        this.VERSION_COUNT = 14;
        String[] stringArray = new String[]{"3.0.3", "3.0.4", "3.0.5", "3.0.6", "3.0.7", "3.1.0", "3.1.1", "3.1.2", "3.1.3", "3.1.4", "3.1.5", "3.1.6", "3.2.0", "99.0"};
        this.initialize("T4StorageArray.Controller", stringArray);
        this.statusMessage = new String("Looking for T4StorageArray.Controller...");
    }
}

