/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class System1_ManagementSoftwareDetector
extends RealizationDetectorPrtl {
    private final int VERSION_4_0;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[1];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWseap", "4.0")) && restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWsedap", "4.0")) && restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWsedspp", "4.0")) && restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWsem9ui", "4.0")) && restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWsepsdx", "4.0")) && restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWseput", "4.0"))) {
                    blArray[0] = true;
                }
                int n = 0;
                while (n < 1) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public System1_ManagementSoftwareDetector() throws DetectorFailedException {
        this.VERSION_4_0 = 0;
        this.VERSION_COUNT = 1;
        String[] stringArray = new String[]{"4.0"};
        this.initialize("System1.ManagementSoftware", stringArray);
        this.statusMessage = new String("Looking for System1.ManagementSoftware...");
    }
}

