/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.model.PatchProProperties;

public class System1_L10N_ManpageDetector
extends RealizationDetectorPrtl {
    private boolean debug;
    private PatchProProperties properties;
    private final int VERSION_2_1;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[1];
                this.properties = PatchProProperties.getInstance();
                boolean bl = this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
                if (this.debug) {
                    System.out.println(this.statusMessage);
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWsesscj", "2.1"))) {
                    blArray[0] = true;
                }
                int n = 0;
                while (n < 1) {
                    if (blArray[n]) {
                        if (this.debug) {
                            System.out.println(n);
                        }
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public System1_L10N_ManpageDetector() throws DetectorFailedException {
        this.VERSION_2_1 = 0;
        this.VERSION_COUNT = 1;
        String[] stringArray = new String[]{"2.1"};
        this.initialize("System1.L10N.Manpage", stringArray);
        this.statusMessage = new String("Looking for System1.L10N.Manpage...");
    }
}

