/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.DSP;
import com.sun.patchpro.host.DspHardwareComponent;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.model.PatchProProperties;
import java.util.Enumeration;

public class StorEdge_DSPDetector
extends RealizationDetectorPrtl {
    private final String PSX_FRUMODEL_SRC_BASELINE;
    private final String PSX_FRUMODEL_SRC_03;
    private final String PSX_FRUMODEL_SRC_02;
    private final String PSX_FRUMODEL_SRC_01;
    private final String PSX_FRUMODEL_SFC_BASELINE;
    private final String PSX_FRUMODEL_SFC_03;
    private final String PSX_FRUMODEL_SFC_02;
    private final String PSX_FRUMODEL_SFC_01;
    private final String PSX_FRUMODEL_IO_BASELINE;
    private final String PSX_FRUMODEL_IO_02;
    private final String PSX_FRUMODEL_IO_01;
    private final String PSX_FRUMODEL_MIC_BASELINE;
    private final String PSX_FRUMODEL_MIC_04;
    private final String PSX_FRUMODEL_MIC_03;
    private final String PSX_FRUMODEL_MIC_02;
    private final String PSX_FRUMODEL_MIC_01;
    private final String PSX_FRUMODEL_MIC2_BASELINE;
    private final String PSX_FRUMODEL_MIC2_04;
    private final String PSX_FRUMODEL_MIC2_03;
    private final String PSX_FRUMODEL_MIC2_02;
    private final String PSX_FRUMODEL_MIC2_01;
    private final String DSP_VERSION_2_1_0_359;
    private final String DSP_VERSION_2_1_1_023;
    private final String DSP_VERSION_2_1_2_034;
    private final String DSP_VERSION_2_2_0_565;
    private final String DSP_VERSION_2_2_0_575;
    private final String DSP_VERSION_BASELINE;
    private final int VERSION_2_1_0_359;
    private final int VERSION_2_1_1_023;
    private final int VERSION_2_1_2_034;
    private final int VERSION_2_2_0_565;
    private final int VERSION_2_2_0_575;
    private final int VERSION_99_0;
    private final int VERSION_COUNT;
    private boolean[] have = new boolean[6];
    private boolean debug;
    private PatchProProperties properties;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        block27: {
            try {
                this.properties = PatchProProperties.getInstance();
                boolean bl = this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
                if (!restrictedHost.getType().equals("DSP")) break block27;
                try {
                    if (this.debug) {
                        System.out.println("Detect DSP exist");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00043-04")) {
                        this.addHardwareComponent(restrictedHost, "720-00043-04");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00043-03")) {
                        this.addHardwareComponent(restrictedHost, "720-00043-03");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00043-02")) {
                        this.addHardwareComponent(restrictedHost, "720-00043-02");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00043-01")) {
                        this.addHardwareComponent(restrictedHost, "720-00043-01");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00014-04")) {
                        this.addHardwareComponent(restrictedHost, "720-00014-04");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00014-03")) {
                        this.addHardwareComponent(restrictedHost, "720-00014-03");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00014-02")) {
                        this.addHardwareComponent(restrictedHost, "720-00014-02");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00014-01")) {
                        this.addHardwareComponent(restrictedHost, "720-00014-01");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00002-01")) {
                        this.addHardwareComponent(restrictedHost, "720-00002-01");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00002-02")) {
                        this.addHardwareComponent(restrictedHost, "720-00002-02");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00002-03")) {
                        this.addHardwareComponent(restrictedHost, "720-00002-03");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00002-04")) {
                        this.addHardwareComponent(restrictedHost, "720-00002-04");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00002-05")) {
                        this.addHardwareComponent(restrictedHost, "720-00002-05");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00047-01")) {
                        this.addHardwareComponent(restrictedHost, "720-00047-01");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00047-02")) {
                        this.addHardwareComponent(restrictedHost, "720-00047-02");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00047-03")) {
                        this.addHardwareComponent(restrictedHost, "720-00047-03");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00047-04")) {
                        this.addHardwareComponent(restrictedHost, "720-00047-04");
                    }
                    if (restrictedHost.hasHardwareComponent("720-00047-05")) {
                        this.addHardwareComponent(restrictedHost, "720-00047-05");
                    }
                    int n = 0;
                    while (n < 6) {
                        if (this.have[n]) {
                            restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                            if (this.debug) {
                                System.out.println(n);
                            }
                        }
                        ++n;
                    }
                }
                catch (NoSuchRealizationException noSuchRealizationException) {
                    throw new DetectorFailedException(noSuchRealizationException.getMessage());
                }
            }
            catch (Error error) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addHardwareComponent(RestrictedHost restrictedHost, String string) {
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof DspHardwareComponent)) continue;
                    DspHardwareComponent dspHardwareComponent = (DspHardwareComponent)e;
                    if (dspHardwareComponent == null || !dspHardwareComponent.getProduct().equals(string)) continue;
                    if (((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.01.00.0359") == 0) {
                        this.have[0] = true;
                        ((Realization)this.applicableRealizations.elementAt(0)).addHardwareComponent((HardwareComponent)dspHardwareComponent);
                    }
                    if (((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.01.01.0023") == 0) {
                        this.have[1] = true;
                        ((Realization)this.applicableRealizations.elementAt(1)).addHardwareComponent((HardwareComponent)dspHardwareComponent);
                    }
                    if (((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.01.02.0034") == 0) {
                        this.have[2] = true;
                        ((Realization)this.applicableRealizations.elementAt(2)).addHardwareComponent((HardwareComponent)dspHardwareComponent);
                    }
                    if (((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.02.00.0565") == 0) {
                        this.have[3] = true;
                        ((Realization)this.applicableRealizations.elementAt(3)).addHardwareComponent((HardwareComponent)dspHardwareComponent);
                    }
                    if (((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.02.00.0575") == 0) {
                        this.have[4] = true;
                        ((Realization)this.applicableRealizations.elementAt(4)).addHardwareComponent((HardwareComponent)dspHardwareComponent);
                    }
                    if (((DSP)restrictedHost).getSysLevelFirmware().compareTo("D02.02.00.0575") > 0) {
                        this.have[5] = true;
                        ((Realization)this.applicableRealizations.elementAt(5)).addHardwareComponent((HardwareComponent)dspHardwareComponent);
                    }
                    if (!this.debug) continue;
                    int n = 0;
                    while (n < 6) {
                        if (this.have[n]) {
                            System.out.println(n);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "StorEdge_DSPDetector.addHardwareComponents(): " + exception.getMessage());
            }
        }
    }

    public StorEdge_DSPDetector() throws DetectorFailedException {
        this.PSX_FRUMODEL_SRC_BASELINE = "720-00043-04";
        this.PSX_FRUMODEL_SRC_03 = "720-00043-03";
        this.PSX_FRUMODEL_SRC_02 = "720-00043-02";
        this.PSX_FRUMODEL_SRC_01 = "720-00043-01";
        this.PSX_FRUMODEL_SFC_BASELINE = "720-00014-04";
        this.PSX_FRUMODEL_SFC_03 = "720-00014-03";
        this.PSX_FRUMODEL_SFC_02 = "720-00014-02";
        this.PSX_FRUMODEL_SFC_01 = "720-00014-01";
        this.PSX_FRUMODEL_IO_BASELINE = "720-00031-03";
        this.PSX_FRUMODEL_IO_02 = "720-00031-02";
        this.PSX_FRUMODEL_IO_01 = "720-00031-01";
        this.PSX_FRUMODEL_MIC_BASELINE = "720-00002-05";
        this.PSX_FRUMODEL_MIC_04 = "720-00002-04";
        this.PSX_FRUMODEL_MIC_03 = "720-00002-03";
        this.PSX_FRUMODEL_MIC_02 = "720-00002-02";
        this.PSX_FRUMODEL_MIC_01 = "720-00002-01";
        this.PSX_FRUMODEL_MIC2_BASELINE = "720-00047-05";
        this.PSX_FRUMODEL_MIC2_04 = "720-00047-04";
        this.PSX_FRUMODEL_MIC2_03 = "720-00047-03";
        this.PSX_FRUMODEL_MIC2_02 = "720-00047-02";
        this.PSX_FRUMODEL_MIC2_01 = "720-00047-01";
        this.DSP_VERSION_2_1_0_359 = "D02.01.00.0359";
        this.DSP_VERSION_2_1_1_023 = "D02.01.01.0023";
        this.DSP_VERSION_2_1_2_034 = "D02.01.02.0034";
        this.DSP_VERSION_2_2_0_565 = "D02.02.00.0565";
        this.DSP_VERSION_2_2_0_575 = "D02.02.00.0575";
        this.DSP_VERSION_BASELINE = "D02.02.00.0575";
        this.VERSION_2_1_0_359 = 0;
        this.VERSION_2_1_1_023 = 1;
        this.VERSION_2_1_2_034 = 2;
        this.VERSION_2_2_0_565 = 3;
        this.VERSION_2_2_0_575 = 4;
        this.VERSION_99_0 = 5;
        this.VERSION_COUNT = 6;
        String[] stringArray = new String[]{"2.1.0.359", "2.1.1.023", "2.1.2.034", "2.2.0.565", "2.2.0.575", "99.0"};
        this.initialize("StorageSupport.DSP1000", stringArray);
        this.statusMessage = new String("Looking for StorageSupport.DSP1000...");
    }
}

