/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.model.PatchProProperties;

public class Software_SUNWstrfrDetector
extends RealizationDetectorPrtl {
    private boolean debug;
    private PatchProProperties properties;
    private final int VERSION_2_2;
    private final int VERSION_2_3;
    private final int VERSION_2_4;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[3];
                this.properties = PatchProProperties.getInstance();
                boolean bl = this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWstrfr", "2.2.00.03"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWstrfr", "2.3"))) {
                    blArray[1] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWstrfr", "2.4"))) {
                    blArray[2] = true;
                }
                int n = 0;
                while (n < 3) {
                    if (blArray[n]) {
                        if (this.debug) {
                            System.out.println(n);
                        }
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public Software_SUNWstrfrDetector() throws DetectorFailedException {
        this.VERSION_2_2 = 0;
        this.VERSION_2_3 = 1;
        this.VERSION_2_4 = 2;
        this.VERSION_COUNT = 3;
        String[] stringArray = new String[]{"2.2", "2.3", "2.4"};
        this.initialize("Software.SUNWstrfr", stringArray);
        this.statusMessage = new String("Looking for Software.SUNWstrfr...");
    }
}

