/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class Software_SUNWstfruDetector
extends RealizationDetectorPrtl {
    private final int VERSION_2_2;
    private final int VERSION_2_3;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[2];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWstfru", "2.2.00.03"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWstfru", "2.3"))) {
                    blArray[1] = true;
                }
                int n = 0;
                while (n < 2) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public Software_SUNWstfruDetector() throws DetectorFailedException {
        this.VERSION_2_2 = 0;
        this.VERSION_2_3 = 1;
        this.VERSION_COUNT = 2;
        String[] stringArray = new String[]{"2.2", "2.3"};
        this.initialize("Software.SUNWstfru", stringArray);
        this.statusMessage = new String("Looking for Software.SUNWstfru...");
    }
}

