/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class Maserati_SSRR_RSSDetector
extends RealizationDetectorPrtl {
    private final int VERSION_1_1_2_6;
    private final int VERSION_1_1_2_7;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[2];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWrsssp", "1.1.2.6"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWrsssp", "1.1.2.7"))) {
                    blArray[1] = true;
                }
                int n = 0;
                while (n < 2) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public Maserati_SSRR_RSSDetector() throws DetectorFailedException {
        this.VERSION_1_1_2_6 = 0;
        this.VERSION_1_1_2_7 = 1;
        this.VERSION_COUNT = 2;
        String[] stringArray = new String[]{"1.1.2.6", "1.1.2.7"};
        this.initialize("Maserati.SSRR.RSS", stringArray);
        this.statusMessage = new String("Looking for Maserati.SSRR.RSS...");
    }
}

