/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import java.util.Enumeration;

public class DiskDrive_Seagate_ST373405FDetector
extends RealizationDetectorPrtl {
    private final String DISKDRIVE_FRUMODEL_BASELINE;
    private final String DISKDRIVE_FRUREVISION_BASELINE;
    private final String DISKDRIVE_FRUREVISION_A236;
    private final String DISKDRIVE_FRUREVISION_A438;
    private final String DISKDRIVE_FRUREVISION_A538;
    private final int VERSION_2_0;
    private final int VERSION_3_0;
    private final int VERSION_4_0;
    private final int VERSION_5_0;
    private final int VERSION_99_0;
    private final int VERSION_COUNT;
    private boolean[] have = new boolean[5];

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        try {
            boolean[] blArray = new boolean[5];
            if (restrictedHost.hasHardwareComponent("ST373405FSUN72G")) {
                this.addHardwareComponent(restrictedHost, "ST373405FSUN72G");
            }
            int n = 0;
            while (n < 5) {
                if (blArray[n]) {
                    restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                }
                ++n;
            }
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException(noSuchRealizationException.getMessage());
        }
    }

    private void addHardwareComponent(RestrictedHost restrictedHost, String string) {
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    HardwareComponent hardwareComponent = (HardwareComponent)enumeration.nextElement();
                    if (hardwareComponent == null || !hardwareComponent.getProduct().equals(string)) continue;
                    if (hardwareComponent.getRevision().compareTo("A236") == 0) {
                        if (!this.have[0]) {
                            this.have[0] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(0)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (hardwareComponent.getRevision().compareTo("A438") == 0) {
                        if (!this.have[1]) {
                            this.have[1] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(1)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (hardwareComponent.getRevision().compareTo("A538") == 0) {
                        if (!this.have[2]) {
                            this.have[2] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(1)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (hardwareComponent.getRevision().compareTo("A638") == 0) {
                        if (!this.have[3]) {
                            this.have[3] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(3)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (hardwareComponent.getRevision().compareTo("A638") <= 0) continue;
                    if (!this.have[4]) {
                        this.have[4] = true;
                    }
                    ((Realization)this.applicableRealizations.elementAt(4)).addHardwareComponent(hardwareComponent);
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "DiskDrive_Seagate_ST373405FDetector.addHardwareComponents(): " + exception.getMessage());
            }
        }
    }

    public DiskDrive_Seagate_ST373405FDetector() throws DetectorFailedException {
        this.DISKDRIVE_FRUMODEL_BASELINE = "ST373405FSUN72G";
        this.DISKDRIVE_FRUREVISION_BASELINE = "A638";
        this.DISKDRIVE_FRUREVISION_A236 = "A236";
        this.DISKDRIVE_FRUREVISION_A438 = "A438";
        this.DISKDRIVE_FRUREVISION_A538 = "A538";
        this.VERSION_2_0 = 0;
        this.VERSION_3_0 = 1;
        this.VERSION_4_0 = 2;
        this.VERSION_5_0 = 3;
        this.VERSION_99_0 = 4;
        this.VERSION_COUNT = 5;
        String[] stringArray = new String[]{"2.0", "3.0", "4.0", "5.0", "99.0"};
        this.initialize("DiskDrive.Seagate.ST373405F", stringArray);
        this.statusMessage = new String("Looking for Seagate ST373405F...");
    }
}

