/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.ControllerHardwareComponent;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchID;
import java.util.Enumeration;

public class DiskDrive_Seagate_ST373307FDetector
extends RealizationDetectorPrtl {
    private final String DISKDRIVE_FRUMODEL_BASELINE;
    private final String DISKDRIVE_FRUREVISION_207;
    private final String DISKDRIVE_FRUREVISION_307;
    private final String DISKDRIVE_FRUREVISION_BASELINE;
    private final String CONTROLLER_FRUMODEL_BASELINE;
    private final String CONTROLLER_VERSION_3_1_3;
    private final String CONTROLLER_VERSION_3_1_4;
    private final String CONTROLLER_VERSION_3_1_5;
    private final String CONTROLLER_VERSION_3_1_6;
    private final String CONTROLLER_VERSION_3_2_0;
    private final int VERSION_1_0;
    private final int VERSION_2_0;
    private final int VERSION_3_0;
    private final int VERSION_99_0;
    private final int VERSION_COUNT;
    private boolean[] have = new boolean[4];

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        try {
            Host host = restrictedHost.getPrimaryHost();
            if (!restrictedHost.getType().equals("T4") && !restrictedHost.getType().equals("T4PP")) {
                return;
            }
            if (!host.hasPatch(new PatchID("119480-01"))) {
                this.log.println((Object)this, 4, "DiskDrive_Seagate_ST373307FDetector detector requires patch 119480-01. This patch is not installed.");
                return;
            }
            if (!this.isOkToProceed(restrictedHost)) {
                return;
            }
        }
        catch (NoSuchPatchException noSuchPatchException) {
            System.out.println(noSuchPatchException.getMessage());
            this.log.println((Object)this, 4, "DiskDrive_Seagate_ST373307FDetector: " + noSuchPatchException.getMessage());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.log.println((Object)this, 4, "DiskDrive_Seagate_ST373307FDetector: " + noSuchMethodError.getMessage());
            return;
        }
        try {
            if (restrictedHost.hasHardwareComponent("ST373307FSUN72G")) {
                this.addHardwareComponent(restrictedHost, "ST373307FSUN72G");
            }
            int n = 0;
            while (n < 4) {
                if (this.have[n]) {
                    restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                }
                ++n;
            }
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException(noSuchRealizationException.getMessage());
        }
    }

    private boolean isOkToProceed(RestrictedHost restrictedHost) {
        boolean bl = false;
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof ControllerHardwareComponent)) continue;
                    ControllerHardwareComponent controllerHardwareComponent = (ControllerHardwareComponent)e;
                    if (controllerHardwareComponent == null || !controllerHardwareComponent.getProduct().equals("5405559") || controllerHardwareComponent.getLevel3Version().compareTo("030103") != 0 && controllerHardwareComponent.getLevel3Version().compareTo("030104") != 0 && controllerHardwareComponent.getLevel3Version().compareTo("030105") != 0 && controllerHardwareComponent.getLevel3Version().compareTo("030106") != 0 && controllerHardwareComponent.getLevel3Version().compareTo("030200") != 0) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "DiskDrive_Seagate_ST373307FDetector.isOkToProceed(): " + exception.getMessage());
            }
        } else {
            this.log.println((Object)this, 4, "DiskDrive_Seagate_ST373307FDetector: Component list is empty");
        }
        return bl;
    }

    private void addHardwareComponent(RestrictedHost restrictedHost, String string) {
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    HardwareComponent hardwareComponent = (HardwareComponent)enumeration.nextElement();
                    if (hardwareComponent == null || !hardwareComponent.getProduct().equals(string)) continue;
                    if (hardwareComponent.getRevision().indexOf("207") != -1) {
                        if (!this.have[0]) {
                            this.have[0] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(0)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (hardwareComponent.getRevision().indexOf("307") != -1) {
                        if (!this.have[1]) {
                            this.have[1] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(1)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (hardwareComponent.getRevision().indexOf("407") != -1) {
                        if (!this.have[2]) {
                            this.have[2] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(2)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (!this.have[3]) {
                        this.have[3] = true;
                    }
                    ((Realization)this.applicableRealizations.elementAt(3)).addHardwareComponent(hardwareComponent);
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "DiskDrive_Seagate_ST373307FDetector.addHardwareComponents(): " + exception.getMessage());
            }
        }
    }

    public DiskDrive_Seagate_ST373307FDetector() throws DetectorFailedException {
        this.DISKDRIVE_FRUMODEL_BASELINE = "ST373307FSUN72G";
        this.DISKDRIVE_FRUREVISION_207 = "207";
        this.DISKDRIVE_FRUREVISION_307 = "307";
        this.DISKDRIVE_FRUREVISION_BASELINE = "407";
        this.CONTROLLER_FRUMODEL_BASELINE = "5405559";
        this.CONTROLLER_VERSION_3_1_3 = "030103";
        this.CONTROLLER_VERSION_3_1_4 = "030104";
        this.CONTROLLER_VERSION_3_1_5 = "030105";
        this.CONTROLLER_VERSION_3_1_6 = "030106";
        this.CONTROLLER_VERSION_3_2_0 = "030200";
        this.VERSION_1_0 = 0;
        this.VERSION_2_0 = 1;
        this.VERSION_3_0 = 2;
        this.VERSION_99_0 = 3;
        this.VERSION_COUNT = 4;
        String[] stringArray = new String[]{"1.0", "2.0", "3.0", "99.0"};
        this.initialize("DiskDrive.Seagate.ST373307F", stringArray);
        this.statusMessage = new String("Looking for Seagate ST373307F...");
    }
}

