/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import java.util.Enumeration;

public class DiskDrive_Seagate_ST336607FDetector
extends RealizationDetectorPrtl {
    private final String DISKDRIVE_FRUMODEL_BASELINE;
    private final String DISKDRIVE_FRUREVISION_BASELINE;
    private final int VERSION_5_0;
    private final int VERSION_99_0;
    private final int VERSION_COUNT;
    private boolean[] have = new boolean[2];

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        try {
            if (restrictedHost.hasHardwareComponent("ST336607FSUN36G")) {
                this.addHardwareComponent(restrictedHost, "ST336607FSUN36G");
            }
            int n = 0;
            while (n < 2) {
                if (this.have[n]) {
                    restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                }
                ++n;
            }
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException(noSuchRealizationException.getMessage());
        }
    }

    private void addHardwareComponent(RestrictedHost restrictedHost, String string) {
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    HardwareComponent hardwareComponent = (HardwareComponent)enumeration.nextElement();
                    if (hardwareComponent == null || !hardwareComponent.getProduct().equals(string)) continue;
                    if (hardwareComponent.getRevision().compareTo("A207") == 0) {
                        if (!this.have[0]) {
                            this.have[0] = true;
                        }
                        ((Realization)this.applicableRealizations.elementAt(0)).addHardwareComponent(hardwareComponent);
                        continue;
                    }
                    if (hardwareComponent.getRevision().compareTo("A207") <= 0) continue;
                    if (!this.have[1]) {
                        this.have[1] = true;
                    }
                    ((Realization)this.applicableRealizations.elementAt(1)).addHardwareComponent(hardwareComponent);
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "DiskDrive_Seagate_ST336607FDetector.addHardwareComponents(): " + exception.getMessage());
            }
        }
    }

    public DiskDrive_Seagate_ST336607FDetector() throws DetectorFailedException {
        this.DISKDRIVE_FRUMODEL_BASELINE = "ST336607FSUN36G";
        this.DISKDRIVE_FRUREVISION_BASELINE = "A207";
        this.VERSION_5_0 = 0;
        this.VERSION_99_0 = 1;
        this.VERSION_COUNT = 2;
        String[] stringArray = new String[]{"5.0", "99.0"};
        this.initialize("DiskDrive.Seagate.ST336607F", stringArray);
        this.statusMessage = new String("Looking for Seagate ST336607F...");
    }
}

