/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import java.util.Enumeration;

public class DiskDrive_Seagate_ST318203FDetector
extends RealizationDetectorPrtl {
    private final int VERSION_4_0;
    private final int VERSION_5_0;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        try {
            boolean[] blArray = new boolean[2];
            if (restrictedHost.hasExactHardwareComponent("ST318203FSUN18G", "D44A")) {
                blArray[0] = true;
                this.addHardwareComponent(restrictedHost, 0, "ST318203FSUN18G", "D44A");
            }
            if (restrictedHost.hasExactHardwareComponent("ST318203FSUN18G", "DF4A")) {
                blArray[1] = true;
                this.addHardwareComponent(restrictedHost, 1, "ST318203FSUN18G", "DF4A");
            }
            int n = 0;
            while (n < 2) {
                if (blArray[n]) {
                    restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                }
                ++n;
            }
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException(noSuchRealizationException.getMessage());
        }
    }

    private void addHardwareComponent(RestrictedHost restrictedHost, int n, String string, String string2) {
        Enumeration enumeration = restrictedHost.getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    HardwareComponent hardwareComponent = (HardwareComponent)enumeration.nextElement();
                    if (hardwareComponent == null || !hardwareComponent.getProduct().equals(string) || !hardwareComponent.getRevision().equals(string2)) continue;
                    ((Realization)this.applicableRealizations.elementAt(n)).addHardwareComponent(hardwareComponent);
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "DiskDrive_Seagate_ST318203FDetector.addHardwareComponents(): " + exception.getMessage());
            }
        }
    }

    public DiskDrive_Seagate_ST318203FDetector() throws DetectorFailedException {
        this.VERSION_4_0 = 0;
        this.VERSION_5_0 = 1;
        this.VERSION_COUNT = 2;
        String[] stringArray = new String[]{"4.0", "5.0"};
        this.initialize("DiskDrive.Seagate.ST318203F", stringArray);
        this.statusMessage = new String("Looking for Seagate ST318203F...");
    }
}

