/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class BaseOS_SolarisUnivDskFmt_64Detector
extends RealizationDetectorPrtl {
    private final int VERSION_5_7;
    private final int VERSION_5_8;
    private final int VERSION_5_9;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[3];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWudfrx", "11.7.0,REV=1999.06.18.18.50"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWudfrx", "11.8.0,REV=2000.01.08.18.12"))) {
                    blArray[1] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWudfrx", "11.9.0,REV=2002.04.06.15.27"))) {
                    blArray[2] = true;
                }
                int n = 0;
                while (n < 3) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public BaseOS_SolarisUnivDskFmt_64Detector() throws DetectorFailedException {
        this.VERSION_5_7 = 0;
        this.VERSION_5_8 = 1;
        this.VERSION_5_9 = 2;
        this.VERSION_COUNT = 3;
        String[] stringArray = new String[]{"5.7", "5.8", "5.9"};
        this.initialize("BaseOS.SolarisUnivDskFmt.64", stringArray);
        this.statusMessage = new String("Looking for BaseOS.SolarisUnivDskFmt.64...");
    }
}

