/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class BaseOS_SolarisSPARCstorageArrayDriversDetector
extends RealizationDetectorPrtl {
    private final int VERSION_5_6;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[1];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWssadv", "11.6.0,REV=1997.07.15.21.46"))) {
                    blArray[0] = true;
                }
                int n = 0;
                while (n < 1) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public BaseOS_SolarisSPARCstorageArrayDriversDetector() throws DetectorFailedException {
        this.VERSION_5_6 = 0;
        this.VERSION_COUNT = 1;
        String[] stringArray = new String[]{"5.6"};
        this.initialize("BaseOS.SolarisSPARCstorageArrayDrivers", stringArray);
        this.statusMessage = new String("Looking for BaseOS.SolarisSPARCstorageArrayDrivers...");
    }
}

