/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class BaseOS_SolarisSCSIEnclosureSvcDetector
extends RealizationDetectorPrtl {
    private final int VERSION_5_6;
    private final int VERSION_5_7;
    private final int VERSION_5_8;
    private final int VERSION_5_9;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[4];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWses", "1.2,REV=1997.07.15.21.46"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWses", "11.7.0,REV=1998.09.01.04.16"))) {
                    blArray[1] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWses", "11.8.0,REV=2000.01.08.18.12"))) {
                    blArray[2] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWses", "11.9.0,REV=2002.04.06.15.27"))) {
                    blArray[3] = true;
                }
                int n = 0;
                while (n < 4) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public BaseOS_SolarisSCSIEnclosureSvcDetector() throws DetectorFailedException {
        this.VERSION_5_6 = 0;
        this.VERSION_5_7 = 1;
        this.VERSION_5_8 = 2;
        this.VERSION_5_9 = 3;
        this.VERSION_COUNT = 4;
        String[] stringArray = new String[]{"5.6", "5.7", "5.8", "5.9"};
        this.initialize("BaseOS.SolarisSCSIEnclosureSvc", stringArray);
        this.statusMessage = new String("Looking for BaseOS.SolarisSCSIEnclosureSvc...");
    }
}

