/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class BaseOS_SolarisNetArrayLibs_64Detector
extends RealizationDetectorPrtl {
    private final int VERSION_5_8;
    private final int VERSION_5_9;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[2];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWluxox", "11.8.0,REV=2000.09.23.16.15"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWluxox", "11.9.0,REV=2002.04.06.15.27"))) {
                    blArray[1] = true;
                }
                int n = 0;
                while (n < 2) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public BaseOS_SolarisNetArrayLibs_64Detector() throws DetectorFailedException {
        this.VERSION_5_8 = 0;
        this.VERSION_5_9 = 1;
        this.VERSION_COUNT = 2;
        String[] stringArray = new String[]{"5.8", "5.9"};
        this.initialize("BaseOS.SolarisNetArrayLibs.64", stringArray);
        this.statusMessage = new String("Looking for BaseOS.SolarisNetArrayLibs.64...");
    }
}

