/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.detectors;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetectorPrtl;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SoftwarePackage;

public class AdminInstall_Solaris_SUNWwsr2Detector
extends RealizationDetectorPrtl {
    private final int VERSION_5_7;
    private final int VERSION_5_8;
    private final int VERSION_5_9;
    private final int VERSION_COUNT;

    public void analyze(RestrictedHost restrictedHost) throws DetectorFailedException {
        if (restrictedHost.isOperatingSystem("SunOS")) {
            try {
                boolean[] blArray = new boolean[3];
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWwsr", "2.0.6,REV=1998.11.28"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWwsr", "2.0.6,REV=1998.11.28"))) {
                    blArray[0] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWwsr2", "3.0.0,REV=2000.11.20.23.48"))) {
                    blArray[1] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWwsr2", "3.0.0,REV=2000.11.21.00.05"))) {
                    blArray[1] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWwsr2", "3.0.0,REV=2002.04.14.23.48"))) {
                    blArray[2] = true;
                }
                if (restrictedHost.hasExactSoftwarePackage(new SoftwarePackage("SUNWwsr2", "3.0.0,REV=2002.04.14.23.49"))) {
                    blArray[2] = true;
                }
                int n = 0;
                while (n < 3) {
                    if (blArray[n]) {
                        restrictedHost.verifyRealization((Realization)this.applicableRealizations.elementAt(n));
                    }
                    ++n;
                }
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                throw new DetectorFailedException(noSuchRealizationException.getMessage());
            }
        }
    }

    public AdminInstall_Solaris_SUNWwsr2Detector() throws DetectorFailedException {
        this.VERSION_5_7 = 0;
        this.VERSION_5_8 = 1;
        this.VERSION_5_9 = 2;
        this.VERSION_COUNT = 3;
        String[] stringArray = new String[]{"5.7", "5.8", "5.9"};
        this.initialize("AdminInstall.Solaris.SUNWwsr2", stringArray);
        this.statusMessage = new String("Looking for AdminInstall.Solaris.SUNWwsr2...");
    }
}

