/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.FailedStateEvent;
import com.sun.patchpro.util.FailedStateException;
import com.sun.patchpro.util.FailedStateListener;
import com.sun.patchpro.util.MalformedStateException;
import com.sun.patchpro.util.NextStateDecoder;
import com.sun.patchpro.util.NextStateEvent;
import com.sun.patchpro.util.NextStateListener;
import com.sun.patchpro.util.NoProblemException;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.NoSuchStateException;
import com.sun.patchpro.util.StateAction;
import com.sun.patchpro.util.StateMachine;
import com.sun.patchpro.util.StateSynchronizer;
import java.util.Enumeration;
import java.util.Vector;

public class State
implements Runnable {
    public static final int INITIALIZED = 0;
    public static final int RUNNING = 1;
    public static final int COMPLETED = 2;
    public static final int FAILED = 3;
    public static final int INAPPROPRIATE = 4;
    public static final int NOSTATE = -1;
    private boolean entryPoint = false;
    private boolean terminal = false;
    private Vector nextStateListeners = new Vector();
    private Vector failedStateListeners = new Vector();
    private Exception stateException = null;
    private Error stateError = null;
    private Object actionResult;
    private int stateState;
    private StateMachine machine;
    private int stateNumber;
    private boolean nextStateProcessed = false;
    private StateSynchronizer synchronizer;
    private NextStateDecoder nextStateDecoder;
    private int[] nextState = new int[0];
    private StateAction action;
    private PatchProLog log = PatchProLog.getInstance();

    protected State(StateMachine stateMachine, boolean bl, StateAction stateAction, StateSynchronizer stateSynchronizer, NextStateDecoder nextStateDecoder, int[] nArray) throws MalformedStateException {
        this.machine = stateMachine;
        this.entryPoint = bl;
        this.action = stateAction;
        this.synchronizer = stateSynchronizer;
        this.nextStateDecoder = nextStateDecoder;
        this.nextState = nArray;
        this.verifyState();
        this.initialize();
    }

    public State(StateMachine stateMachine, boolean bl, StateAction stateAction, int[] nArray) throws MalformedStateException {
        this(stateMachine, bl, stateAction, null, null, nArray);
    }

    public State(StateMachine stateMachine, boolean bl, StateAction stateAction, NextStateDecoder nextStateDecoder) throws MalformedStateException {
        this(stateMachine, bl, stateAction, null, nextStateDecoder, null);
    }

    public State(StateMachine stateMachine, boolean bl, StateAction stateAction, StateSynchronizer stateSynchronizer, int[] nArray) throws MalformedStateException {
        this(stateMachine, bl, stateAction, stateSynchronizer, null, nArray);
    }

    public State(StateMachine stateMachine, boolean bl, StateAction stateAction, StateSynchronizer stateSynchronizer, NextStateDecoder nextStateDecoder) throws MalformedStateException {
        this(stateMachine, bl, stateAction, stateSynchronizer, nextStateDecoder, null);
    }

    public State(StateMachine stateMachine, boolean bl, StateAction stateAction) throws MalformedStateException {
        this(stateMachine, bl, stateAction, null, null, null);
        this.terminal = true;
    }

    private void verifyState() throws MalformedStateException {
        if (this.nextState != null && this.nextState.length > 0 && this.nextStateDecoder != null) {
            throw new MalformedStateException("State.verifyState: Both static and dynamic next state not permitted.");
        }
    }

    public void initialize() {
        this.actionResult = null;
        this.setStateState(0);
        this.stateException = null;
        this.stateError = null;
        this.nextStateProcessed = false;
        this.log.println(this, 7, "State: initialized.");
    }

    public void setStateNumber(int n) {
        this.stateNumber = n;
        this.log.println(this, 7, "State: State number is " + n);
    }

    public synchronized void setNextStateProcessed(boolean bl) {
        this.nextStateProcessed = bl;
    }

    public boolean isNextStateProcessed() {
        return this.nextStateProcessed;
    }

    public int getStateNumber() {
        return this.stateNumber;
    }

    public void run() {
        this.log.println(this, 7, "State: run() begins");
        this.setStateState(1);
        try {
            if (this.isSynchronized()) {
                this.log.println(this, 7, "State: beginning synchronizer");
                this.synchronizer.synchronize(this.machine);
            } else {
                Thread.sleep(20000L);
            }
            this.log.println(this, 7, "State: beginning action");
            this.actionResult = this.action.run(this.machine, this);
            this.setStateState(this.action.actionStatus());
            if (this.stateState == 3) {
                try {
                    this.log.println(this, 7, "State " + this.stateNumber + " did not complete with " + this.getError().getMessage());
                    throw new FailedStateException("State " + this.stateNumber + " did not complete.", this.getError());
                }
                catch (NoProblemException noProblemException) {
                    try {
                        this.log.println(this, 7, "State " + this.stateNumber + " did not complete with " + this.getError().getMessage());
                        throw new FailedStateException("State " + this.stateNumber + " did not complete.", this.getException());
                    }
                    catch (NoProblemException noProblemException2) {
                        this.log.println(this, 7, "State " + this.stateNumber + " did not complete with " + this.getError().getMessage());
                        throw new FailedStateException("State " + this.stateNumber + " did not complete.");
                    }
                }
            }
            if (!this.hasFixedNextState()) {
                this.nextState = this.nextStateDecoder.getNextState(this.machine);
            }
            this.dispatchNextState(new NextStateEvent(this));
        }
        catch (Exception exception) {
            this.stateException = exception;
            this.setStateState(3);
            this.dispatchFailedState(new FailedStateEvent(this));
        }
        catch (Error error) {
            this.stateError = error;
            this.setStateState(3);
            this.dispatchFailedState(new FailedStateEvent(this));
        }
    }

    public boolean isEntryPoint() {
        return this.entryPoint;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public boolean isSynchronized() {
        return this.synchronizer != null;
    }

    public boolean hasFixedNextState() {
        return this.nextStateDecoder == null;
    }

    public synchronized void setException(Exception exception) {
        if (this.stateException == null) {
            this.stateException = exception;
        }
    }

    public synchronized Exception getException() throws NoProblemException {
        if (this.stateException == null) {
            throw new NoProblemException("State.getException(): State did not fail.");
        }
        return this.stateException;
    }

    public synchronized void setError(Error error) {
        if (this.stateError == null) {
            this.stateError = error;
        }
    }

    public synchronized Error getError() throws NoProblemException {
        if (this.stateError == null) {
            throw new NoProblemException("State.getError(): State did not fail.");
        }
        return this.stateError;
    }

    public Object getActionResult() throws NoResultException {
        if (this.getStateState() == 2) {
            return this.actionResult;
        }
        throw new NoResultException("State.getActionResult(): No valid result.");
    }

    public void setActionResult(Object object) {
        this.actionResult = object;
    }

    public void setStateState(int n) {
        this.stateState = n;
    }

    public int getStateState() {
        return this.stateState;
    }

    public synchronized boolean reserveState() {
        if (this.stateState == 1) {
            this.log.println(this, 7, "State: State cannot be reserved.");
            return false;
        }
        this.setStateState(1);
        this.log.println(this, 7, "State: State is reserved.");
        return true;
    }

    public int[] getNextState() throws NoSuchStateException {
        if ((this.getStateState() == 2 || this.getStateState() == 3 || this.getStateState() == 4) && this.nextState != null) {
            return this.nextState;
        }
        throw new NoSuchStateException("State.getNextState(): No valid next state.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNextStateListener(NextStateListener nextStateListener) {
        Vector vector = this.nextStateListeners;
        synchronized (vector) {
            this.nextStateListeners.addElement(nextStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNextStateListener(NextStateListener nextStateListener) {
        Vector vector = this.nextStateListeners;
        synchronized (vector) {
            this.nextStateListeners.removeElement(nextStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailedStateListener(FailedStateListener failedStateListener) {
        Vector vector = this.failedStateListeners;
        synchronized (vector) {
            this.failedStateListeners.addElement(failedStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFailedStateListener(FailedStateListener failedStateListener) {
        Vector vector = this.failedStateListeners;
        synchronized (vector) {
            this.failedStateListeners.removeElement(failedStateListener);
        }
    }

    private void dispatchNextState(NextStateEvent nextStateEvent) {
        Enumeration enumeration = this.nextStateListeners.elements();
        while (enumeration.hasMoreElements()) {
            NextStateListener nextStateListener = (NextStateListener)enumeration.nextElement();
            nextStateListener.processNextState(nextStateEvent);
        }
    }

    private void dispatchFailedState(FailedStateEvent failedStateEvent) {
        Enumeration enumeration = this.failedStateListeners.elements();
        while (enumeration.hasMoreElements()) {
            FailedStateListener failedStateListener = (FailedStateListener)enumeration.nextElement();
            failedStateListener.processFailedState(failedStateEvent);
        }
    }

    public static final String stateStateToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = new String("initialized");
                break;
            }
            case 1: {
                string = new String("running");
                break;
            }
            case 2: {
                string = new String("completed");
                break;
            }
            case 3: {
                string = new String("failed");
                break;
            }
            default: {
                string = new String("not valid");
            }
        }
        return string;
    }

    public void dumpState() {
        System.out.println("State is = " + this);
        System.out.println("State number is = " + this.stateNumber);
        System.out.println("State is entry point = " + this.entryPoint);
        System.out.println("State is synchronized = " + this.isSynchronized());
        System.out.println("State is terminal = " + this.terminal);
        System.out.println("State has fixed next state = " + this.hasFixedNextState());
        System.out.println("State state is = " + this.stateState + "(" + State.stateStateToString(this.stateState) + ")");
        if (this.hasFixedNextState() && !this.terminal) {
            System.out.print(" Next states: ");
            for (int i = 0; i < this.nextState.length; ++i) {
                System.out.print(this.nextState[i] + " ");
            }
        }
        System.out.print("\n\n");
    }
}

