/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import java.io.PrintStream;

public class Spinner {
    private static Spinner mySpinner;
    private SpinnerDisplayer displayer;

    private Spinner() {
    }

    public static final Spinner getInstance() {
        if (mySpinner == null) {
            mySpinner = new Spinner();
        }
        return mySpinner;
    }

    public void start() {
        if (this.displayer == null) {
            this.displayer = new SpinnerDisplayer();
        }
        Thread thread = new Thread(this.displayer);
        thread.start();
    }

    public void stop() {
        this.displayer.off();
    }

    public void setInterval(int n) {
        this.displayer.setInterval(n);
    }

    public void setDefaultInterval() {
        this.displayer.setDefaultInterval();
    }

    public static void main(String[] stringArray) {
        Spinner spinner = Spinner.getInstance();
        spinner.start();
        int n = 0;
        while (true) {
            try {
                if (++n == 10) break;
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Bla bla bla");
        }
        spinner.stop();
    }

    class SpinnerDisplayer
    implements Runnable {
        boolean spinnerOn = true;
        static final int DEFAULT_INTERVAL = 3;
        int interval = 3;

        SpinnerDisplayer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = 0;
            while (this.spinnerOn) {
                try {
                    PrintStream printStream = System.out;
                    synchronized (printStream) {
                        System.out.print(".");
                        if (n++ > 50) {
                            System.out.println();
                            n = 0;
                        }
                    }
                    Thread.sleep(this.interval * 1000);
                }
                catch (Exception exception) {}
            }
            System.out.flush();
        }

        public void off() {
            this.spinnerOn = false;
        }

        public void setInterval(int n) {
            this.interval = n;
        }

        public void setDefaultInterval() {
            this.interval = 3;
        }
    }
}

