/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.SnmpTrapThread;
import java.net.SocketException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.snmp.manager.SnmpEventReportDispatcher;
import javax.management.snmp.manager.SnmpTrapListener;

public class SnmpEventReportDispatcherPool {
    static Map dispatchers = Collections.synchronizedMap(new LinkedHashMap());
    static boolean DEBUG = false;

    private SnmpEventReportDispatcherPool() {
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        String string = patchProProperties.getProperty("patchpro.debug", "false");
        DEBUG = "true".equals(string);
    }

    public static SnmpEventReportDispatcher getDispatcher(int n) throws SocketException {
        SnmpEventReportDispatcher snmpEventReportDispatcher = (SnmpEventReportDispatcher)dispatchers.get(String.valueOf(n));
        if (snmpEventReportDispatcher == null) {
            snmpEventReportDispatcher = new SnmpEventReportDispatcher(n);
            SnmpTrapThread snmpTrapThread = new SnmpTrapThread(snmpEventReportDispatcher);
            snmpTrapThread.start();
            dispatchers.put(String.valueOf(n), snmpEventReportDispatcher);
        }
        return snmpEventReportDispatcher;
    }

    public static void addTrapListener(int n, SnmpTrapListener snmpTrapListener) throws SocketException {
        SnmpEventReportDispatcher snmpEventReportDispatcher = SnmpEventReportDispatcherPool.getDispatcher(n);
        if (!snmpEventReportDispatcher.containsTrapListener(snmpTrapListener)) {
            snmpEventReportDispatcher.addTrapListener(snmpTrapListener);
        }
    }

    public static void removeTrapListener(int n, SnmpTrapListener snmpTrapListener) throws SocketException {
        SnmpEventReportDispatcher snmpEventReportDispatcher = SnmpEventReportDispatcherPool.getDispatcher(n);
        if (snmpEventReportDispatcher.containsTrapListener(snmpTrapListener)) {
            snmpEventReportDispatcher.removeTrapListener(snmpTrapListener);
        }
    }
}

