/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.database.AuditRecord;
import com.sun.patchpro.database.FirmwareImageAuditRecord;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.InstallerEvent;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.manipulators.ManipulatorEvent;
import com.sun.patchpro.manipulators.ManipulatorListener;
import com.sun.patchpro.manipulators.NoManipulatorException;
import com.sun.patchpro.manipulators.PatchRemoveFailedException;
import com.sun.patchpro.manipulators.Removable;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.manipulators.RemoverEvent;
import com.sun.patchpro.manipulators.VerifierEvent;
import com.sun.patchpro.model.InvalidPatchTypeException;
import com.sun.patchpro.model.NoBackoutDataException;
import com.sun.patchpro.model.NonRootUserException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchRemoveException;
import com.sun.patchpro.model.SunOSPkgaddAccessException;
import com.sun.patchpro.model.UndoLastSessionEvent;
import com.sun.patchpro.model.UndoLastSessionListener;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchContents;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.AuditManager;
import com.sun.patchpro.util.AuditTransactionException;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.LineParser;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchBundleRemover
implements ManipulatorListener {
    static final String EMPTY_PATCH_LIST = "Empty patch list.";
    public static final String FAIL_TO_REMOVE = "Failed to backout a patch.";
    public static final String FAIL_TO_AUDIT = "Failed to record the patch removal in audit record.";
    static final String INTERNAL_SYSTEM_DATA_NOT_VALID = "Internal system data is not valid.";
    static final String INVALID_ARGUMENT_LIST = "Invalid argument list.";
    static final String INVALID_HOST = "Invalid host.";
    static final String INVALID_PATCH_TYPE = "Cannot determine patch type.";
    static final String NO_REMOVAL_ALLOWED = "Policy does not allow removal of patches.";
    public static final String NON_REMOVABLE_PATCH_TYPE = "Cannot find a method for removing this patch.";
    public static final String BLOCKED_PATCH = "Patch is blocked.";
    public static final String PATCHRM_PATCH_NOT_APPLIED = "Patch is not present.";
    public static final String PATCHRM_NON_ROOT_UID = "Not allowed to backout patches as non-root user.";
    public static final String PATCHRM_PKGADD_NOT_FOUND = "Not able to access /usr/sbin/pkgadd.";
    public static final String PATCHRM_NO_BACKOUT_DATA = "No backout data was retained for this patch.";
    public static final String PROBLEM_REMOVING_PATCH = "Problem backing out the patch.";
    private PatchPro model;
    private boolean smpatch;
    boolean thisPatchRemoveDone = false;
    boolean thisPatchRemoveFailed = false;
    boolean debug = false;
    int numberOfPatchesToRemove = 0;
    int numberOfPatchesProcessed = 0;
    boolean bundleFailed = false;
    LocalizedMessages msgcat;
    PatchListImpl removedList;
    PatchListImpl failedRemoveList;
    PatchProLog log;
    AuditManager auditManager;
    PatchProProperties properties = PatchProProperties.getInstance();
    Vector listeners;
    Vector exceptionRepository;
    SessionData sessionData;
    private boolean warnedNoRemove = false;
    private File sourceDirectory;
    private File backoutDirectory;
    private boolean force = false;
    private boolean permissive = false;

    public PatchBundleRemover(PatchPro patchPro) {
        this.auditManager = AuditManager.getInstance();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        String string = this.properties.getProperty("patchpro.override.level", "standard");
        if (string.equals("force")) {
            this.force = true;
        } else if (string.equals("permissive")) {
            this.permissive = true;
        }
        this.debug = this.properties.getProperty("patchpro.patch.install.debug", "false").equals("true");
        this.auditManager = AuditManager.getInstance();
        this.log = PatchProLog.getInstance();
        this.model = patchPro;
        this.listeners = new Vector();
    }

    protected void initialize(Host host) {
        this.sessionData = host.getSessionData();
        this.exceptionRepository = (Vector)this.sessionData.getPatchProExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UndoLastSessionListener undoLastSessionListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(undoLastSessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UndoLastSessionListener undoLastSessionListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(undoLastSessionListener);
        }
    }

    public PatchList testUndoLast(Host host, Host host2, PatchList patchList, SignatureValidationUtil signatureValidationUtil) {
        Host host3 = host2 == null ? host : host2;
        int n = 0;
        try {
            int n2 = patchList.size();
            Enumeration enumeration = null;
            for (n = 0; n < n2; ++n) {
                String string;
                if (patchList.hasErrorAt(n)) continue;
                Patch patch = patchList.getPatchAt(n);
                PatchContents patchContents = patch.getPatchContents();
                enumeration = null;
                try {
                    Manipulable manipulable = patchContents.getManipulator(host, host2, enumeration, signatureValidationUtil);
                    switch (manipulable.getRemoveStrategy(this.model.isInteractive())) {
                        case 5: {
                            patchList.setSelectionStatus(n, true);
                            break;
                        }
                        case 6: {
                            patchList.setSelectionStatus(n, false);
                            break;
                        }
                        case 7: {
                            patchList.setSelectionStatus(n, false);
                            break;
                        }
                        case 8: {
                            patchList.setSelectionStatus(n, false);
                            break;
                        }
                        case 9: {
                            if (this.force) {
                                patchList.setSelectionStatus(n, true);
                            } else {
                                patchList.setSelectionStatus(n, false);
                            }
                            string = manipulable.getProblem();
                            patchList.setErrorAt(n, string);
                            break;
                        }
                        case 10: {
                            if (this.force) {
                                patchList.setSelectionStatus(n, true);
                            } else {
                                patchList.setSelectionStatus(n, false);
                            }
                            string = manipulable.getProblem();
                            patchList.setErrorAt(n, string);
                        }
                    }
                    continue;
                }
                catch (NoManipulatorException noManipulatorException) {
                    patchList.setSelectionStatus(n, false);
                    Object[] objectArray = new Object[]{patch.getPatchID().getPatchID()};
                    string = this.msgcat.getMessage("PatchBundleRemover.NO_MANIPULATOR", objectArray, "\nNo method for backing out the patch " + objectArray[0] + ".");
                    patchList.setErrorAt(n, string);
                }
            }
        }
        catch (NoSuchPatchException noSuchPatchException) {
            this.log.println(this, 4, "Rolled off the end of the patch list for " + host3.getAddress() + " at " + n);
        }
        return patchList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchList undoLast(Host host, Host host2, PatchList patchList, SignatureValidationUtil signatureValidationUtil) {
        PatchList patchList2;
        this.smpatch = this.properties.getProperty("smpatch.request", "false").equals("true");
        Enumeration enumeration = null;
        if (patchList == null || patchList.size() <= 0) {
            this.dispatchDoneEvent();
            this.log.println(this, 4, EMPTY_PATCH_LIST);
            return patchList;
        }
        if (host == null) {
            this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("PatchBundleRemover.INVALID_HOST", INVALID_HOST)));
            this.log.println(this, 3, INVALID_HOST);
            return patchList;
        }
        PatchList patchList3 = patchList;
        this.numberOfPatchesToRemove = patchList3.size();
        this.log.println(this, 7, "Number of patches to process: " + this.numberOfPatchesToRemove);
        if (this.debug) {
            System.out.println("Number of patches to process: " + this.numberOfPatchesToRemove);
        }
        Patch patch = null;
        PatchContents patchContents = null;
        Manipulable manipulable = null;
        Removable removable = null;
        Host host3 = host2 == null ? host : host2;
        for (int i = 0; i < this.numberOfPatchesToRemove; ++i) {
            Object var17_24;
            AuditRecord auditRecord = null;
            try {
                try {
                    patch = patchList3.getPatchAt(i);
                    if (patchList.getSelectionStatus(i)) {
                        if (this.debug) {
                            System.out.println("Removing " + patch.getPatchID().getPatchID());
                        }
                        this.log.println(this, 7, "Dealing with patch: " + patch.getPatchID().getPatchID());
                        patchContents = patch.getPatchContents();
                        enumeration = null;
                        manipulable = patchContents.getManipulator(host, host2, enumeration, signatureValidationUtil);
                        this.removePatch(this.smpatch, manipulable, host3);
                    } else {
                        if (this.debug) {
                            System.out.println("PatchBundleRemover: undoLast(): patchList.getSelectionStatus(index) == false");
                        }
                        try {
                            auditRecord = this.auditManager.getInstalledPatchAuditRecord(patch.getPatchID());
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 4, "Exception calling auditManager.getInstalledPatchAuditRecord(): " + noSuchPatchException.getMessage());
                        }
                        PatchID patchID = null;
                        if (auditRecord instanceof FirmwareImageAuditRecord && (patchID = ((FirmwareImageAuditRecord)auditRecord).getOldPatchID()) == null) {
                            System.out.println("Patch " + patch.getPatchID().getPatchID() + " cannot " + " be backed out since the old patch that is " + "required ");
                            System.out.println("to back it out cannot be found.");
                        }
                        try {
                            this.auditManager.removeConfirm(patch, host3);
                        }
                        catch (AuditTransactionException auditTransactionException) {
                            this.log.println(this, 4, "Exception calling auditManager.removeConfirm(): " + auditTransactionException.getMessage());
                        }
                    }
                    var17_24 = null;
                    if (removable == null) continue;
                    removable.removeListener(this);
                }
                catch (RemoveFailedException removeFailedException) {
                    if (this.force) {
                        try {
                            this.auditManager.removeConfirm(patch, host3);
                        }
                        catch (AuditTransactionException auditTransactionException) {
                            this.log.println(this, 4, "Exception calling auditManager.removeConfirm() " + auditTransactionException.getMessage());
                        }
                    }
                    var17_24 = null;
                    if (removable == null) continue;
                    removable.removeListener(this);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 4, "Rolled off the end of the patch list for " + host3.getAddress() + " at " + i);
                    var17_24 = null;
                    if (removable == null) continue;
                    removable.removeListener(this);
                }
                catch (NoManipulatorException noManipulatorException) {
                    this.log.println(this, 4, noManipulatorException.getMessage());
                    var17_24 = null;
                    if (removable == null) continue;
                    removable.removeListener(this);
                }
                continue;
            }
            catch (Throwable throwable) {
                var17_24 = null;
                if (removable != null) {
                    removable.removeListener(this);
                }
                throw throwable;
            }
        }
        this.log.println(this, 7, "PatchBundleRemover: Done with all patches.");
        this.dispatchProgressEvent();
        this.dispatchDoneEvent();
        try {
            patchList2 = this.sessionData.getPatchesRequired();
        }
        catch (Exception exception) {
            patchList2 = new PatchListImpl();
        }
        return patchList2;
    }

    public void errorRemainingPatchList(PatchList patchList, int n, String string, Host host) {
        int n2 = patchList.size();
        try {
            for (int i = n; i < n2; ++i) {
                patchList.setErrorAt(i, string);
                this.force = true;
                if (true) {
                    patchList.setSelectionStatus(i, true);
                    try {
                        this.auditManager.removeConfirm(patchList.getPatchAt(i), host);
                    }
                    catch (AuditTransactionException auditTransactionException) {}
                    continue;
                }
                patchList.setSelectionStatus(i, false);
            }
        }
        catch (NoSuchPatchException noSuchPatchException) {
            // empty catch block
        }
    }

    public Collection getPatchProExceptions() {
        return this.exceptionRepository;
    }

    public Percentage removeProgress() {
        Percentage percentage;
        float f = 100.0f;
        if (this.numberOfPatchesToRemove != 0) {
            f = (float)this.numberOfPatchesProcessed / (float)this.numberOfPatchesToRemove * 100.0f;
        }
        try {
            percentage = new Percentage((int)f);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "PatchBundleRemover.getPatchRemoveProgress(): Unable to create a Percentage from " + f + ".");
            f = 100.0f;
            percentage = new Percentage((int)f);
        }
        return percentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProgressEvent() {
        UndoLastSessionListener undoLastSessionListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                undoLastSessionListener = (UndoLastSessionListener)this.listeners.elementAt(i);
                undoLastSessionListener.undoLastSessionProgress(new UndoLastSessionEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDoneEvent() {
        UndoLastSessionListener undoLastSessionListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                undoLastSessionListener = (UndoLastSessionListener)this.listeners.elementAt(i);
                undoLastSessionListener.undoLastSessionDone(new UndoLastSessionEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchFailedEvent(String string) {
        UndoLastSessionListener undoLastSessionListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                undoLastSessionListener = (UndoLastSessionListener)this.listeners.elementAt(i);
                undoLastSessionListener.undoLastSessionFailed(new UndoLastSessionEvent(this, string));
            }
        }
    }

    private void addToPatchList(int n, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
    }

    private void addToPatchList(int n, int n2, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
        this.sessionData.addToPatchList(n2, patch, string);
    }

    private boolean allPatchTypesAreAllowed(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.contains(vector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePatch(boolean bl, Manipulable manipulable, Host host) throws RemoveFailedException {
        Removable removable = null;
        Patch patch = manipulable.getPatch();
        this.thisPatchRemoveDone = false;
        this.thisPatchRemoveFailed = false;
        try {
            try {
                Object[] objectArray;
                if (bl) {
                    System.out.println(this.msgcat.getMessage("remove_patch", "Removing patch") + " " + patch.getPatchID().getPatchID() + " ...");
                }
                removable = manipulable.getRemover();
                Thread thread = new Thread(removable);
                removable.addListener(this);
                thread.start();
                while (!this.thisPatchRemoveDone) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                removable.removeListener(this);
                if (thread != null) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.thisPatchRemoveFailed) {
                    throw new PatchRemoveFailedException(removable.getFailure().getMessage());
                }
                if (!bl) {
                    objectArray = new Object[]{patch.getPatchID().getPatchID()};
                    System.out.println(this.msgcat.getMessage("PatchBundleRemover.backed_out", objectArray, "\n" + objectArray[0] + "has been backed out."));
                }
                objectArray = patch.getPatchID().getPatchID();
                this.log.println(this, 7, "Just invoked removePatch for: " + (String)objectArray);
                this.sessionData.addToPatchList(9, patch, "");
                this.auditManager.removeConfirm(patch, host);
                if (host.isAssociate()) {
                    try {
                        this.deletePkgOfAssociatePatchOnPrimaryHost((String)objectArray);
                    }
                    catch (InteractiveSessionException interactiveSessionException) {
                        this.log.println(this, 1, "Failed to backout a patch. " + (String)objectArray);
                        this.dispatchFailedEvent(PatchProLog.createMessage(1, this.msgcat.getMessage("PatchBundleRemover.FAIL_TO_REMOVE", FAIL_TO_REMOVE) + " " + (String)objectArray));
                        this.log.printStackTrace(this, 7, interactiveSessionException);
                    }
                }
                Object var11_13 = null;
                if (removable != null) {
                    removable.removeListener(this);
                }
            }
            catch (RemoveFailedException removeFailedException) {
                this.recordRemoveFailedException(removeFailedException, patch);
                if (removeFailedException instanceof PatchRemoveFailedException) {
                    this.log.println(this, 1, "Failed to backout a patch. " + patch.getPatchID().getPatchID() + "\n\npatchadd utility failed. " + "Reason code :" + ((PatchRemoveFailedException)removeFailedException).getReasonCode() + "\n" + ((PatchRemoveFailedException)removeFailedException).getMessage());
                } else {
                    this.log.println(this, 1, "Failed to backout a patch. " + patch.getPatchID().getPatchID());
                }
                this.dispatchFailedEvent(PatchProLog.createMessage(1, this.msgcat.getMessage("PatchBundleRemover.FAIL_TO_REMOVE", "Fail to remove a patch.") + " " + patch.getPatchID().getPatchID()));
                this.log.printStackTrace(this, 7, removeFailedException);
                Object var11_14 = null;
                if (removable != null) {
                    removable.removeListener(this);
                }
            }
            catch (AuditTransactionException auditTransactionException) {
                this.log.println(this, 1, "Failed to record the patch removal in audit record. " + patch.getPatchID().getPatchID());
                this.dispatchFailedEvent(PatchProLog.createMessage(1, this.msgcat.getMessage("PatchBundleRemover.FAIL_TO_AUDIT", "Fail to audit backingout of patch.") + " " + patch.getPatchID().getPatchID()));
                this.log.printStackTrace(this, 7, auditTransactionException);
                Object var11_15 = null;
                if (removable != null) {
                    removable.removeListener(this);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (removable != null) {
                removable.removeListener(this);
            }
            throw throwable;
        }
    }

    private void handleProblem(Manipulable manipulable) {
        this.handleProblem(manipulable, true, 10, new InvalidPatchTypeException("InvalidPatchTypeException", "InvalidPatchTypeException.MESSAGE", "InvalidPatchTypeException.REMEDY", 4), "PatchBundleRemover.INVALID_PATCH_TYPE", INVALID_PATCH_TYPE);
    }

    private void handleProblem(boolean bl, PatchProException patchProException, String string, String string2) {
        this.handleProblem(null, bl, -1, patchProException, string, string2);
    }

    private void handleProblem(Manipulable manipulable, boolean bl, int n, PatchProException patchProException, String string, String string2) {
        Patch patch;
        String string3 = "";
        this.bundleFailed = true;
        if (manipulable != null && (patch = manipulable.getPatch()) != null) {
            if (!this.model.isInteractive()) {
                if (n == 10) {
                    this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, "Patch has failed for an unknown reason."));
                } else {
                    this.addToPatchList(n, 10, patch, this.msgcat.getMessage(string, "Patch has failed for an unknown reason."));
                }
                try {
                    manipulable.sequester();
                }
                catch (IOException iOException) {}
            } else {
                this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, "Patch has failed for an unknown reason."));
            }
            string3 = new String(": " + patch.getPatchID().getPatchID());
        }
        if (!this.warnedNoRemove) {
            this.updateExceptionRepository(patchProException);
            this.log.println(this, patchProException.getSeverity(), string2);
            if (bl) {
                this.dispatchFailedEvent(PatchProLog.createMessage(patchProException.getSeverity(), this.msgcat.getMessage(string, "Patch remove has failed for an unknown reason.") + string3));
            }
        }
    }

    protected void deletePkgOfAssociatePatchOnPrimaryHost(String string) throws InteractiveSessionException {
        String string2 = "";
        String string3 = this.properties.getProperty("SunOS.command.get.patch.data", "/usr/bin/showrev -p");
        String string4 = "|";
        String string5 = string3 + " | " + "/usr/bin/grep " + string;
        try {
            string2 = this.executeCommand(string5).trim();
        }
        catch (InteractiveSessionException interactiveSessionException) {
            throw new InteractiveSessionException(interactiveSessionException.getMessage());
        }
        LineParser lineParser = new LineParser();
        String string6 = "";
        try {
            string6 = this.getLine("Patch: " + string, string2);
            string6 = lineParser.getTokenBetween(string6, "Packages:", "");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.log.println(this, 1, stringIndexOutOfBoundsException.getMessage());
            this.log.printStackTrace(this, 7, stringIndexOutOfBoundsException);
        }
        if (!string6.equals("")) {
            Object[] objectArray;
            StringTokenizer stringTokenizer = new StringTokenizer(string6.trim(), ",");
            while (stringTokenizer.hasMoreElements()) {
                String string7 = stringTokenizer.nextToken().trim();
                string2 = "";
                objectArray = this.properties.getProperty("SunOS.command.remove.package", "/usr/sbin/pkgrm");
                String string8 = (String)objectArray + " -n " + string7;
                try {
                    string2 = this.executeCommand(string8).trim();
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
            }
            if (this.debug) {
                objectArray = new Object[]{string};
                System.out.println(this.msgcat.getMessage("PatchBundleRemover.REMOVED_PKG", objectArray, "Removed all package instances for the patch " + string));
            }
        }
    }

    protected String getLine(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.indexOf(string) == -1) continue;
            string3 = string4;
            break;
        }
        return string3;
    }

    private String executeCommand(String string) throws InteractiveSessionException {
        String string2 = "";
        int n = -1;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.add(12, 60);
        CommandSession commandSession = new CommandSession();
        commandSession.start(string);
        while (gregorianCalendar.before(gregorianCalendar2)) {
            try {
                n = commandSession.getProcessExitValue();
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                gregorianCalendar = null;
                gregorianCalendar = new GregorianCalendar();
            }
        }
        string2 = commandSession.getSessionMessages();
        commandSession.stop();
        commandSession.cleanup();
        if (n != 0) {
            throw new InteractiveSessionException(string2);
        }
        return string2;
    }

    private void recordRemoveFailedException(RemoveFailedException removeFailedException, Patch patch) {
        if (removeFailedException instanceof PatchRemoveFailedException) {
            int n = ((PatchRemoveFailedException)removeFailedException).getReasonCode();
            switch (n) {
                case 2: {
                    this.sessionData.addToPatchList(8, patch, PATCHRM_PATCH_NOT_APPLIED);
                    break;
                }
                case 3: {
                    this.sessionData.addToPatchList(8, patch, PATCHRM_NON_ROOT_UID);
                    NonRootUserException nonRootUserException = new NonRootUserException("NonRootUserException", "NonRootUserException.MESSAGE", "NonRootUserException.REMEDY", 3);
                    this.updateExceptionRepository(nonRootUserException);
                    break;
                }
                case 9: {
                    this.sessionData.addToPatchList(8, patch, PATCHRM_PKGADD_NOT_FOUND);
                    SunOSPkgaddAccessException sunOSPkgaddAccessException = new SunOSPkgaddAccessException("SunOSPkgaddAccessException", "SunOSPkgaddAccessException.MESSAGE", "SunOSPkgaddAccessException.REMEDY", 3);
                    this.updateExceptionRepository(sunOSPkgaddAccessException);
                    break;
                }
                case 4: {
                    this.addToPatchList(8, patch, PATCHRM_NO_BACKOUT_DATA);
                    NoBackoutDataException noBackoutDataException = new NoBackoutDataException("NoBackoutDataException", "NoBackoutDataException.MESSAGE", "NoBackoutDataException.REMEDY", 3);
                    this.updateExceptionRepository(noBackoutDataException);
                    break;
                }
                default: {
                    this.sessionData.addToPatchList(8, patch, PROBLEM_REMOVING_PATCH);
                    PatchRemoveException patchRemoveException = this.smpatch ? new PatchRemoveException("PatchRemoveException", "PatchRemoveException.SMPATCH_MESSAGE", "PatchRemoveException.SMPATCH_REMEDY", 3) : new PatchRemoveException("PatchRemoveException", "PatchRemoveException.MESSAGE", "PatchRemoveException.REMEDY", 3);
                    this.updateExceptionRepository(patchRemoveException);
                }
            }
        }
    }

    private void updateExceptionRepository(PatchProException patchProException) {
        if (!this.exceptionRepository.contains(patchProException)) {
            this.exceptionRepository.add(patchProException);
        }
    }

    public void manipulatorProgress(ManipulatorEvent manipulatorEvent) {
        this.dispatchProgressEvent();
    }

    public void manipulatorDone(ManipulatorEvent manipulatorEvent) {
        this.thisPatchRemoveDone = true;
    }

    public void manipulatorFailed(InstallerEvent installerEvent) {
        Exception exception = ((Removable)installerEvent.getSource()).getFailure();
        this.thisPatchRemoveDone = true;
        this.thisPatchRemoveFailed = true;
        this.dispatchFailedEvent(exception.getMessage());
    }

    public void manipulatorFailed(RemoverEvent removerEvent) {
        this.thisPatchRemoveDone = true;
        this.thisPatchRemoveFailed = true;
        this.dispatchFailedEvent("Received a Remover event.");
    }

    public void manipulatorFailed(VerifierEvent verifierEvent) {
        this.thisPatchRemoveDone = true;
        this.thisPatchRemoveFailed = true;
        this.dispatchFailedEvent("Received a Verifier event.");
    }

    public void manipulatorFailed(ManipulatorEvent manipulatorEvent) {
        this.thisPatchRemoveDone = true;
        this.thisPatchRemoveFailed = true;
        this.dispatchFailedEvent("Received a Manipulable event.");
    }
}

