/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.database.FirmwareImageAuditRecord;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.log.ApplicationLog;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.CannotDeferException;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.InstallerEvent;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.ManipulatorEvent;
import com.sun.patchpro.manipulators.ManipulatorListener;
import com.sun.patchpro.manipulators.NoManipulatorException;
import com.sun.patchpro.manipulators.NoSuchImageException;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.RemoverEvent;
import com.sun.patchpro.manipulators.VerifierEvent;
import com.sun.patchpro.model.BackoutDirectoryAccessException;
import com.sun.patchpro.model.DuplicatePatchException;
import com.sun.patchpro.model.InstallPatchEvent;
import com.sun.patchpro.model.InstallPatchListener;
import com.sun.patchpro.model.InsufficientFileSystemSpaceException;
import com.sun.patchpro.model.InvalidPatchSourceDirectoryException;
import com.sun.patchpro.model.InvalidPatchTypeException;
import com.sun.patchpro.model.NonRootUserException;
import com.sun.patchpro.model.PatchBundlesExtractionException;
import com.sun.patchpro.model.PatchDependenciesException;
import com.sun.patchpro.model.PatchInstallException;
import com.sun.patchpro.model.PatchIsRiskyException;
import com.sun.patchpro.model.PatchNotFoundException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.SequesterDirectoryAccessException;
import com.sun.patchpro.model.SunOSPkgaddAccessException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchContents;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.AuditManager;
import com.sun.patchpro.util.AuditTransactionException;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.SunOSTarFileHandler;
import com.sun.patchpro.util.TarFileHandlerFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchBundleInstaller
implements ManipulatorListener {
    static final String SEQUESTER_DIR_NOT_WRITABLE = "Sequester directory is not writable.";
    static final String BACKOUT_DIR_NOT_WRITABLE = "Backout directory is not writable.";
    static final String EMPTY_PATCH_LIST = "Empty patch list.";
    static final String EMPTY_PATCH_BUNDLE = "Empty patch bundle was detected.";
    public static final String FAIL_TO_INSTALL = "Failed to install a patch.";
    public static final String FAIL_TO_AUDIT = "Failed to record the patch installation in audit record.";
    public static final String FAILED_TO_VALIDATE_SIGNATURE = "Failed to validate the digital signature(s) for:";
    static final String INTERNAL_SYSTEM_DATA_NOT_VALID = "Internal system data is not valid.";
    static final String INVALID_ARGUMENT_LIST = "Invalid argument list.";
    static final String INVALID_HOST = "Invalid host.";
    static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Specified filename for the patch bundle is invalid.";
    static final String INVALID_PATCH_TYPE = "Cannot determine patch type.";
    static final String NO_INSTALL_ALLOWED = "Policy does not allow installation of patches.";
    public static final String NON_INSTALLABLE_PATCH_TYPE = "Patch type not installable in this case.";
    public static final String DEFERRED_INSTALLABLE_PATCH_TYPE = "Patch type not installable in this case.";
    public static final String PATCH_REQT_NOT_MET = "Patch requirement for this patch is not met. ";
    static final String PATCH_NOT_SELECTED = "The patch is not selected.";
    static final String PATCH_SOURCE_DIR_NOT_VALID = "Invalid patch source directory.";
    static final String REQUIRED_PATCH_REVOKED = "Required patch has been revoked. ";
    static final String PROBLEM_EXTRACTING_PATCHES = "Problem extracting patches from patch bundles.";
    static final String RISKY_PATCH = "Recognized a discontinued, obsolete or point patch.";
    public static final String PATCHADD_PATCH_ALREADY_APPLIED = "Patch is already present.";
    public static final String PATCHADD_NON_ROOT_UID = "Not allowed to apply patches as non-root user.";
    public static final String PATCHADD_PKGADD_NOT_FOUND = "Not able to access /usr/sbin/pkgadd.";
    public static final String PATCHADD_NOT_ENOUGH_SPACE = "Not enough file system space for patch installation.";
    public static final String PROBLEM_INSTALLING_PATCH = "Problem installing patch.";
    public static final String NO_SEQUESTER_SPECIFIED = "No sequester directory has been specified.";
    private PatchPro model;
    boolean thisPatchInstallDone = false;
    boolean thisPatchInstallFailed = false;
    boolean debug = false;
    boolean smpatch = false;
    boolean installAuthenticate = true;
    int numberOfPatchesToInstall = 0;
    int numberOfPatchesProcessed = 0;
    boolean bundleFailed = false;
    File sourceDirectory;
    File backoutDirectory;
    File sequesterDirectory;
    LocalizedMessages msgcat;
    PatchListImpl installedList;
    PatchListImpl sequesteredList;
    PatchListImpl deferredList;
    PatchListImpl failedInstallList;
    PatchListImpl unexpectedPropertyList;
    PatchListImpl uninstalledList = new PatchListImpl();
    PatchProLog log;
    PatchProProperties properties = PatchProProperties.getInstance();
    SignatureValidationUtil validationUtility = null;
    Vector listeners;
    Vector exceptionRepository;
    SessionData sessionData;
    private boolean warnedNoInstall = false;
    private AuditManager auditManager;

    public PatchBundleInstaller() throws Exception {
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        this.log = PatchProLog.getInstance();
        try {
            String string = this.properties.getProperty("patchpro.log.file", "system");
            this.log.setLogger(new ApplicationLog(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.installAuthenticate = this.properties.getProperty("patchpro.patch.install.authenticate", "true").equals("true");
        this.auditManager = AuditManager.getInstance();
        this.listeners = new Vector();
        if (this.properties.installAuthenticationRequired()) {
            try {
                this.validationUtility = SignatureValidationUtil.getValidationUtility(this.properties, this.validationUtility);
            }
            catch (NoKeystorePresentException noKeystorePresentException) {
                this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage(noKeystorePresentException.getMessage(), "patchpro.security.kslocation is not defined or file does not exist.")));
                this.log.println(this, 3, PatchProLog.createMessage(3, noKeystorePresentException.getMessage()));
            }
            catch (NoSigningCertException noSigningCertException) {
                this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage(noSigningCertException.getMessage(), "Failed to create the signature validation utility")));
                this.log.println(this, 3, PatchProLog.createMessage(3, noSigningCertException.getMessage() + ":" + noSigningCertException.getSigningCertAlias()));
            }
        }
    }

    protected void initialize(Host host) {
        this.sessionData = host.getSessionData();
        this.exceptionRepository = (Vector)this.sessionData.getPatchProExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(installPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(installPatchListener);
        }
    }

    public PatchList install(Host host, PatchList patchList, File file, File file2, PatchPro patchPro) {
        return this.install(host, null, patchList, file, file2, patchPro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PatchList install(Host host, Host host2, PatchList patchList, File file, File file2, PatchPro patchPro) {
        Object object;
        block78: {
            File file3;
            Object object2;
            String string;
            String string2;
            Object object3;
            Object object4;
            block77: {
                String string3;
                Object object5;
                Object object6;
                this.model = patchPro;
                this.smpatch = this.properties.getProperty("smpatch.request", "false").equals("true");
                Enumeration enumeration = null;
                if (patchList == null || patchList.size() <= 0) {
                    this.dispatchDoneEvent();
                    this.log.println(this, 4, EMPTY_PATCH_LIST);
                    return patchList;
                }
                if (file == null || !file.exists()) {
                    this.handleProblem(true, new InvalidPatchSourceDirectoryException("InvalidPatchSourceDirectoryException", "InvalidPatchSourceDirectoryException.MESSAGE", "InvalidPatchSourceDirectoryException.REMEDY", 2), "PatchBundleInstaller.PATCH_SOURCE_DIR_NOT_VALID", PATCH_SOURCE_DIR_NOT_VALID);
                    return patchList;
                }
                this.sourceDirectory = file;
                if (host == null) {
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("PatchBundleInstaller.INVALID_HOST", INVALID_HOST)));
                    this.log.println(this, 3, INVALID_HOST);
                    return patchList;
                }
                this.backoutDirectory = file2;
                if (file2 != null) {
                    if (!file2.exists()) {
                        file2.mkdirs();
                    } else if (!file2.isDirectory() || !file2.canWrite()) {
                        this.handleProblem(true, new BackoutDirectoryAccessException("BackoutDirectoryAccessException", "BackoutDirectoryAccessException.MESSAGE", "BackoutDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.BACKOUT_DIR_NOT_WRITABLE", BACKOUT_DIR_NOT_WRITABLE);
                        return patchList;
                    }
                }
                File file4 = this.sequesterDirectory = this.sequesterDirectory == null ? new File(this.properties.getProperty("patchpro.patch.sequester.directory")) : this.sequesterDirectory;
                if (this.sequesterDirectory == null) {
                    this.handleProblem(true, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.NO_SEQUESTER_SPECIFIED", NO_SEQUESTER_SPECIFIED);
                    return patchList;
                }
                if (!this.sequesterDirectory.exists()) {
                    this.sequesterDirectory.mkdirs();
                } else if (!this.sequesterDirectory.isDirectory() || !this.sequesterDirectory.canWrite()) {
                    this.handleProblem(true, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.SEQUESTER_DIR_NOT_WRITABLE", SEQUESTER_DIR_NOT_WRITABLE);
                    return patchList;
                }
                HostSpecificInterpreter hostSpecificInterpreter = this.sessionData.getInterpreter();
                if (!this.properties.installIsAllowed(patchPro.isInteractive())) {
                    object6 = "PatchBundleInstaller.NO_INSTALL_ALLOWED";
                    object5 = "InvalidPatchTypeException.MESSAGE";
                    boolean bl = true;
                    if (patchPro.isInteractive()) {
                        string3 = "InvalidPatchTypeException.INTERACTIVE_REMEDY";
                    } else {
                        string3 = "InvalidPatchTypeException.REMEDY";
                        bl = false;
                    }
                    this.handleProblem(bl, new InvalidPatchTypeException("InvalidPatchTypeException", (String)object5, string3, 4), (String)object6, NO_INSTALL_ALLOWED);
                    this.warnedNoInstall = true;
                }
                object6 = patchList;
                this.numberOfPatchesToInstall = object6.size();
                if (this.numberOfPatchesToInstall <= 0) {
                    this.handleProblem(true, new PatchBundlesExtractionException("PatchBundlesExtractionException", "PatchBundlesExtractionException.MESSAGE", "PatchBundlesExtractionException.REMEDY", 2), "none", "numberOfPatchesToInstall (" + this.numberOfPatchesToInstall + ") <= 0");
                    return patchList;
                }
                this.log.println(this, 7, "Number of patches to install: " + this.numberOfPatchesToInstall);
                object5 = null;
                string3 = null;
                PatchInfo patchInfo = null;
                PatchProperties patchProperties = null;
                Enumeration enumeration2 = null;
                Enumeration enumeration3 = null;
                Realization realization = null;
                Host host3 = host2 == null ? host : host2;
                for (int i = 0; i < this.numberOfPatchesToInstall; ++i) {
                    try {
                        Vector<HardwareComponent> vector = null;
                        vector = new Vector<HardwareComponent>();
                        object5 = object6.getPatchAt(i);
                        enumeration2 = object6.getIPatchAt(i).getRealizations();
                        while (enumeration2.hasMoreElements()) {
                            realization = (Realization)enumeration2.nextElement();
                            enumeration3 = realization.getHardwareComponents();
                            while (enumeration3.hasMoreElements()) {
                                vector.addElement((HardwareComponent)enumeration3.nextElement());
                            }
                        }
                        enumeration = vector.size() == 0 ? null : vector.elements();
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.printStackTrace(this, 2, noSuchPatchException);
                        continue;
                    }
                    this.log.println(this, 7, "Dealing with patch: " + object5.getPatchID().getPatchID());
                    if (!this.checkPatchDependencies(hostSpecificInterpreter, (Patch)object5)) {
                        object4 = null;
                        try {
                            object4 = new Manipulator((Patch)object5, host, null, this.validationUtility);
                        }
                        catch (NoSuchImageException noSuchImageException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.handleProblem((Manipulable)object4, false, 10, new PatchDependenciesException("PatchDependenciesException", "PatchDependenciesException.MESSAGE", "PatchDependenciesException.REMEDY", 5), "PatchBundleInstaller.PATCH_REQT_NOT_MET", "Patch requirement for this patch is not met.  " + object5.getPatchID().getPatchID());
                        ++this.numberOfPatchesProcessed;
                    } else {
                        patchInfo = object5.getPatchInfo();
                        patchProperties = patchInfo.getProperties();
                        object3 = object5.getPatchContents();
                        try {
                            object4 = ((PatchContents)object3).getManipulator(this.sourceDirectory, host, host2, enumeration, this.validationUtility);
                            switch (object4.getStrategy(patchPro.isInteractive())) {
                                case 1: {
                                    try {
                                        this.installPatch(this.smpatch, (Manipulable)object4, host3);
                                    }
                                    catch (InstallFailedException installFailedException) {
                                        this.handleProblem((Manipulable)object4, true, 8, new PatchInstallException("PatchInstallException", "PatchInstallException.MESSAGE", "PatchInstallException.REMEDY", 4), "PatchBundleInstaller.FAIL_TO_INSTALL", object5.getPatchID().getPatchID() + ": " + PROBLEM_INSTALLING_PATCH);
                                    }
                                    break;
                                }
                                case 3: {
                                    try {
                                        object4.sequester();
                                        this.sessionData.addToPatchList(10, (Patch)object5, this.msgcat.getMessage("Patch type not installable in this case.", "Patch type not installable in this case."));
                                        this.log.println(this, 6, object5.getPatchID().getPatchID() + ": " + "Patch type not installable in this case.");
                                    }
                                    catch (IOException iOException) {
                                        this.handleProblem((Manipulable)object4, true, 10, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.FAIL_TO_INSTALL", SEQUESTER_DIR_NOT_WRITABLE);
                                    }
                                    break;
                                }
                                case 2: {
                                    try {
                                        object4.defer();
                                        this.sessionData.addToPatchList(11, (Patch)object5, this.msgcat.getMessage("Patch type not installable in this case.", "Patch will be installed at the next scheduled reboot."));
                                        this.log.println(this, 6, object5.getPatchID().getPatchID() + ": " + "Patch type not installable in this case.");
                                    }
                                    catch (CannotDeferException cannotDeferException) {
                                        this.handleProblem((Manipulable)object4, true, 10, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.FAIL_TO_INSTALL", SEQUESTER_DIR_NOT_WRITABLE);
                                    }
                                    break;
                                }
                                case 4: {
                                    if (!patchPro.isInteractive()) {
                                        string2 = "PatchIsRiskyException.MESSAGE";
                                        string = "PatchIsRiskyException.MESSAGE";
                                        object = "PatchIsRiskyException.REMEDY";
                                        this.handleProblem((Manipulable)object4, true, 7, new PatchIsRiskyException("PatchIsRiskyException", string, (String)object, 2), string2, "Recognized a discontinued, obsolete or point patch. " + object5.getPatchID().getPatchID());
                                        break;
                                    }
                                    if (patchProperties.isDiscontinued() || patchProperties.isNonstandard() || patchProperties.isPointpatch() || patchProperties.isObsolete()) {
                                        string2 = "PatchIsRiskyException.INTERACTIVE_MESSAGE";
                                        string = "PatchIsRiskyException.INTERACTIVE_MESSAGE";
                                        object = "PatchIsRiskyException.INTERACTIVE_REMEDY";
                                        object2 = new PatchIsRiskyException("PatchIsRiskyException", string, (String)object, 2);
                                        this.handleProblem((Manipulable)object4, true, 7, (PatchProException)object2, string2, "Policy does not allow installation of patches. " + object5.getPatchID().getPatchID());
                                        break;
                                    }
                                    string2 = "InvalidPatchTypeException.INTERACTIVE_MESSAGE";
                                    string = "InvalidPatchTypeException.INTERACTIVE_MESSAGE";
                                    object = "InvalidPatchTypeException.INTERACTIVE_REMEDY";
                                    object2 = new InvalidPatchTypeException("InvalidPatchTypeException", string, (String)object, 5);
                                    this.handleProblem((Manipulable)object4, true, 0, (PatchProException)object2, string2, "Policy does not allow installation of patches. " + object5.getPatchID().getPatchID());
                                    break;
                                }
                                default: {
                                    this.handleProblem((Manipulable)object4, true, 7, new PatchIsRiskyException("PatchIsRiskyException", "PatchIsRiskyException.MESSAGE", "PatchIsRiskyException.REMEDY", 4), "PatchBundleInstaller.RISKY_PATCH_TYPE", "Recognized a discontinued, obsolete or point patch. " + object5.getPatchID().getPatchID());
                                    break;
                                }
                            }
                        }
                        catch (NoManipulatorException noManipulatorException) {
                            this.handleProblem(new Manipulator(), true, 10, new InvalidPatchTypeException("InvalidPatchTypeException", "InvalidPatchTypeException.MESSAGE", "InvalidPatchTypeException.REMEDY", 4), "PatchBundleInstaller.INVALID_PATCH_TYPE", "Patch type not installable in this case. " + object5.getPatchID().getPatchID());
                        }
                        catch (NoSuchImageException noSuchImageException) {
                            this.handleProblem(new Manipulator(), true, 0, new PatchNotFoundException("PatchNotFoundException", "PatchNotFoundException.MESSAGE", "PatchNotFoundException.REMEDY", 3), "Installer.NO_PATCH_IMAGE", "The installer cannot find the patch. " + object5.getPatchID().getPatchID());
                        }
                        ++this.numberOfPatchesProcessed;
                    }
                    this.dispatchProgressEvent();
                }
                this.log.println(this, 7, "PatchBundleInstaller: Done with all patches.");
                this.dispatchProgressEvent();
                try {
                    this.auditManager.setDeferredPatches(this.sessionData.getPatchesDeferred());
                }
                catch (NoResultException noResultException) {
                    this.log.println(this, 7, "PatchBundleInstaller: Deferred patch list was null.");
                }
                file3 = null;
                object4 = null;
                object3 = this.sourceDirectory.listFiles();
                string2 = null;
                string = null;
                if (object3 != null) break block77;
                this.log.println(this, 4, "No download summary file to be sequestered.");
                break block78;
            }
            object = null;
            object2 = null;
            byte[] byArray = new byte[16384];
            for (int i = 0; i < ((File[])object3).length; ++i) {
                block74: {
                    string2 = object3[i].getName();
                    string = object3[i].getPath();
                    if (string2.indexOf("patchpro_dnld_") == -1 || !(file3 = new File(string)).exists()) continue;
                    object = null;
                    object2 = null;
                    object4 = new File(this.sequesterDirectory.getPath() + File.separator + string2);
                    if (!((File)object4).exists()) {
                        ((File)object4).createNewFile();
                    }
                    object = new FileInputStream(file3.getPath());
                    object2 = new FileOutputStream(((File)object4).getPath());
                    int n = 0;
                    while ((n = ((FileInputStream)object).read(byArray, 0, byArray.length)) != -1) {
                        ((FileOutputStream)object2).write(byArray, 0, n);
                    }
                    Object var31_43 = null;
                    try {
                        if (object != null) {
                            ((FileInputStream)object).close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        if (object2 != null) {
                            ((FileOutputStream)object2).close();
                        }
                        break block74;
                    }
                    catch (IOException iOException2) {}
                    break block74;
                    {
                        catch (IOException iOException) {
                            this.log.printStackTrace(this, 2, iOException);
                            var31_43 = null;
                            try {
                                if (object != null) {
                                    ((FileInputStream)object).close();
                                }
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            try {
                                if (object2 != null) {
                                    ((FileOutputStream)object2).close();
                                }
                                break block74;
                            }
                            catch (IOException iOException2) {}
                            break block74;
                        }
                        catch (Exception exception) {
                            this.log.printStackTrace(this, 2, exception);
                            var31_43 = null;
                            try {
                                if (object != null) {
                                    ((FileInputStream)object).close();
                                }
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            try {
                                if (object2 != null) {
                                    ((FileOutputStream)object2).close();
                                }
                                break block74;
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        var31_43 = null;
                        try {
                            if (object != null) {
                                ((FileInputStream)object).close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        try {
                            if (object2 != null) {
                                ((FileOutputStream)object2).close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (file3.delete()) {
                    System.out.println(file3.getPath() + " " + this.msgcat.getMessage("PatchBundleInstaller.moved", "has been moved to") + " " + ((File)object4).getPath());
                    continue;
                }
                System.out.println(file3.getPath() + " " + this.msgcat.getMessage("PatchBundleInstaller.copied", "has been copied to") + " " + ((File)object4).getPath());
            }
        }
        this.dispatchDoneEvent();
        try {
            object = this.sessionData.getPatchesNotInstalled();
        }
        catch (Exception exception) {
            object = new PatchListImpl();
        }
        return object;
    }

    public Collection getPatchProExceptions() {
        return this.exceptionRepository;
    }

    public Percentage installProgress() {
        Percentage percentage;
        float f = 100.0f;
        if (this.numberOfPatchesToInstall != 0) {
            f = (float)this.numberOfPatchesProcessed / (float)this.numberOfPatchesToInstall * 100.0f;
        }
        try {
            percentage = new Percentage((int)f);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "PatchBundleInstaller.getPatchInstallProgress(): Unable to create a Percentage from " + f + ".");
            f = 100.0f;
            percentage = new Percentage((int)f);
        }
        return percentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProgressEvent() {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchProgress(new InstallPatchEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDoneEvent() {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchDone(new InstallPatchEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchFailedEvent(String string) {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchFailed(new InstallPatchEvent(this, string));
            }
        }
    }

    private void addToPatchList(int n, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
    }

    private void addToPatchList(int n, int n2, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
        this.sessionData.addToPatchList(n2, patch, string);
    }

    private void extractBundle(File file) {
        SunOSTarFileHandler sunOSTarFileHandler = new SunOSTarFileHandler();
        try {
            sunOSTarFileHandler.extract(file.getPath(), file.getPath(), "patchesBundle.tar", false);
        }
        catch (TarFileHandlerFailedException tarFileHandlerFailedException) {
            // empty catch block
        }
    }

    private boolean checkPatchDependencies(HostSpecificInterpreter hostSpecificInterpreter, Patch patch) {
        String[] stringArray;
        this.log.println(this, 7, "Checking patch dependencies for: " + patch.getPatchID().getPatchID());
        PatchInfo patchInfo = patch.getPatchInfo();
        if (patchInfo == null) {
            this.log.println(this, 3, patch.getPatchID().getPatchID() + ": " + INTERNAL_SYSTEM_DATA_NOT_VALID + ": patchInfo is null");
            return false;
        }
        String string = patchInfo.getRequires();
        if (string.indexOf("(") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        } else {
            try {
                stringArray = hostSpecificInterpreter.getPatchList(string);
            }
            catch (ParseError parseError) {
                this.log.printStackTrace(this, 3, parseError);
                return false;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.uninstalledList.getIPatchByIDString(stringArray[i]) == null) continue;
            this.log.println(this, 4, patch.getPatchID().getPatchID() + ": " + REQUIRED_PATCH_REVOKED + " " + stringArray[i]);
            return false;
        }
        return true;
    }

    private boolean allPatchTypesAreAllowed(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.contains(vector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPatch(boolean bl, Manipulable manipulable, Host host) throws InstallFailedException {
        block22: {
            Installable installable = null;
            Patch patch = manipulable.getPatch();
            this.thisPatchInstallDone = false;
            this.thisPatchInstallFailed = false;
            try {
                block21: {
                    try {
                        if (bl) {
                            System.out.println(this.msgcat.getMessage("install_patch", "Installing patch") + " " + patch.getPatchID().getPatchID() + " ...");
                        }
                        installable = manipulable.getInstaller();
                        Thread thread = new Thread(installable);
                        installable.addListener(this);
                        thread.start();
                        while (!this.thisPatchInstallDone) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        installable.removeListener(this);
                        if (thread != null) {
                            try {
                                thread.join();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (this.thisPatchInstallFailed) {
                            throw new PatchInstallFailedException(installable.getFailure().getMessage());
                        }
                        if (!bl) {
                            System.out.println(patch.getPatchID().getPatchID() + " " + this.msgcat.getMessage("PatchBundleInstaller.applied", "has been applied."));
                        }
                        this.log.println(this, 7, "Just invoked installPatch for: " + patch.getPatchID().getPatchID());
                        this.sessionData.addToPatchList(9, patch, "");
                        if (installable.getAuditRecord() instanceof FirmwareImageAuditRecord) {
                            this.auditManager.installConfirm(installable.getAuditRecord());
                            break block21;
                        }
                        this.auditManager.installConfirm(patch, host);
                    }
                    catch (InstallFailedException installFailedException) {
                        this.recordInstallFailedException(installFailedException, patch);
                        if (installFailedException instanceof PatchInstallFailedException) {
                            this.log.println(this, 1, "Failed to install a patch. " + patch.getPatchID().getPatchID() + "\n\npatchadd utility failed. " + "Reason code :" + ((PatchInstallFailedException)installFailedException).getReasonCode() + "\n" + ((PatchInstallFailedException)installFailedException).getMessage());
                        } else {
                            this.log.println(this, 1, "Failed to install a patch. " + patch.getPatchID().getPatchID());
                        }
                        this.dispatchFailedEvent(PatchProLog.createMessage(1, this.msgcat.getMessage("PatchBundleInstaller.FAIL_TO_INSTALL", "Fail to install a patch.") + " " + patch.getPatchID().getPatchID()));
                        this.log.printStackTrace(this, 7, installFailedException);
                        Object var9_12 = null;
                        if (installable != null) {
                            installable.removeListener(this);
                        }
                        break block22;
                    }
                    catch (AuditTransactionException auditTransactionException) {
                        this.log.println(this, 1, "Failed to record the patch installation in audit record. " + patch.getPatchID().getPatchID());
                        this.dispatchFailedEvent(PatchProLog.createMessage(1, this.msgcat.getMessage("PatchBundleInstaller.FAIL_TO_AUDIT", "Fail to audit installation of patch.") + " " + patch.getPatchID().getPatchID()));
                        this.log.printStackTrace(this, 7, auditTransactionException);
                        Object var9_13 = null;
                        if (installable != null) {
                            installable.removeListener(this);
                        }
                    }
                }
                Object var9_11 = null;
                if (installable != null) {
                    installable.removeListener(this);
                }
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                if (installable != null) {
                    installable.removeListener(this);
                }
                throw throwable;
            }
        }
    }

    private void handleProblem(Manipulable manipulable) {
        this.handleProblem(manipulable, true, 10, new InvalidPatchTypeException("InvalidPatchTypeException", "InvalidPatchTypeException.MESSAGE", "InvalidPatchTypeException.REMEDY", 4), "PatchBundleInstaller.INVALID_PATCH_TYPE", INVALID_PATCH_TYPE);
    }

    private void handleProblem(boolean bl, PatchProException patchProException, String string, String string2) {
        this.handleProblem(null, bl, -1, patchProException, string, string2);
    }

    private void handleProblem(Manipulable manipulable, boolean bl, int n, PatchProException patchProException, String string, String string2) {
        Patch patch;
        String string3 = "";
        this.bundleFailed = true;
        if (manipulable != null && (patch = manipulable.getPatch()) != null) {
            if (!this.model.isInteractive()) {
                if (n == 10) {
                    this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, "Patch has failed for an unknown reason."));
                } else {
                    this.addToPatchList(n, 10, patch, this.msgcat.getMessage(string, "Patch has failed for an unknown reason."));
                }
                try {
                    manipulable.sequester();
                }
                catch (IOException iOException) {}
            } else {
                this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, "Patch has failed for an unknown reason."));
            }
            string3 = new String(": " + patch.getPatchID().getPatchID());
        }
        if (!this.warnedNoInstall) {
            this.updateExceptionRepository(patchProException);
            this.log.println(this, patchProException.getSeverity(), string2);
            if (bl) {
                this.dispatchFailedEvent(PatchProLog.createMessage(patchProException.getSeverity(), this.msgcat.getMessage(string, "Patch install has failed for an unknown reason.") + string3));
            }
        }
    }

    private void recordInstallFailedException(InstallFailedException installFailedException, Patch patch) {
        if (installFailedException instanceof PatchInstallFailedException) {
            int n = ((PatchInstallFailedException)installFailedException).getReasonCode();
            switch (n) {
                case 2: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_PATCH_ALREADY_APPLIED);
                    DuplicatePatchException duplicatePatchException = new DuplicatePatchException("DuplicatePatchException", "DuplicatePatchException.MESSAGE", "DuplicatePatchException.REMEDY", 3);
                    this.updateExceptionRepository(duplicatePatchException);
                    break;
                }
                case 3: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_NON_ROOT_UID);
                    NonRootUserException nonRootUserException = new NonRootUserException("NonRootUserException", "NonRootUserException.MESSAGE", "NonRootUserException.REMEDY", 3);
                    this.updateExceptionRepository(nonRootUserException);
                    break;
                }
                case 9: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_PKGADD_NOT_FOUND);
                    SunOSPkgaddAccessException sunOSPkgaddAccessException = new SunOSPkgaddAccessException("SunOSPkgaddAccessException", "SunOSPkgaddAccessException.MESSAGE", "SunOSPkgaddAccessException.REMEDY", 3);
                    this.updateExceptionRepository(sunOSPkgaddAccessException);
                    break;
                }
                case 18: {
                    this.addToPatchList(8, patch, PATCHADD_NOT_ENOUGH_SPACE);
                    InsufficientFileSystemSpaceException insufficientFileSystemSpaceException = new InsufficientFileSystemSpaceException("InsufficientFileSystemSpaceException", "InsufficientFileSystemSpaceException.MESSAGE", "InsufficientFileSystemSpaceException.REMEDY", 3);
                    this.updateExceptionRepository(insufficientFileSystemSpaceException);
                    break;
                }
                default: {
                    this.sessionData.addToPatchList(7, patch, FAIL_TO_INSTALL);
                    PatchInstallException patchInstallException = this.smpatch ? new PatchInstallException("PatchInstallException", "PatchInstallException.SMPATCH_MESSAGE", "PatchInstallException.SMPATCH_REMEDY", 3) : new PatchInstallException("PatchInstallException", "PatchInstallException.MESSAGE", "PatchInstallException.REMEDY", 3);
                    this.updateExceptionRepository(patchInstallException);
                }
            }
        }
    }

    private void updateExceptionRepository(PatchProException patchProException) {
        if (!this.exceptionRepository.contains(patchProException)) {
            this.exceptionRepository.add(patchProException);
        }
    }

    public void manipulatorProgress(ManipulatorEvent manipulatorEvent) {
        this.dispatchProgressEvent();
    }

    public void manipulatorDone(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
    }

    public void manipulatorFailed(InstallerEvent installerEvent) {
        Exception exception = ((Installable)installerEvent.getSource()).getFailure();
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent(exception.getMessage());
    }

    public void manipulatorFailed(RemoverEvent removerEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Remover event.");
    }

    public void manipulatorFailed(VerifierEvent verifierEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Verifier event.");
    }

    public void manipulatorFailed(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Manipulable event.");
    }
}

