/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedMessages {
    private Locale locale;
    private ResourceBundle messages;
    private PatchProLog log = PatchProLog.getInstance();

    public LocalizedMessages(Locale locale) {
        this.locale = locale;
        this.messages = ResourceBundle.getBundle("com.sun.patchpro.conf.PatchProMessages", locale);
        if (this.messages == null) {
            this.log.println(this, 6, "Unable to open requested catalog: " + locale.toString());
        }
    }

    public String getMessage(String string, String string2) {
        try {
            return this.messages.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            this.log.println(this, 4, "Corrupt message catalog: locale=\"" + this.locale.toString() + "\" messageID=\"" + string + "\" default english=\"" + string2 + "\"");
            return string2;
        }
    }

    public String getMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = this.messages.getString(string);
            if (string3 != null) {
                MessageFormat messageFormat = new MessageFormat(string3);
                String string4 = messageFormat.format(objectArray);
                return string4;
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.log.println(this, 4, "Corrupt message catalog: locale=\"" + this.locale.toString() + "\" messageID=\"" + string + "\" default english=\"" + string2 + "\"");
            return string2;
        }
        return string2;
    }

    public String getDate(Date date) {
        return DateFormat.getDateInstance(2, this.locale).format(date);
    }

    public String getLTime() {
        Calendar calendar = Calendar.getInstance();
        return DateFormat.getDateTimeInstance(2, 2, this.locale).format(calendar.getTime());
    }
}

