/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.patchpro.database.AuditRecord;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.model.InternalErrorException;
import com.sun.patchpro.model.NoUndoElementsException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.UndoLastSessionEvent;
import com.sun.patchpro.model.UndoLastSessionListener;
import com.sun.patchpro.model.UndoNotPermittedException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.AuditManager;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.PatchBundleRemover;
import com.sun.patchpro.util.Percentage;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class GroupPatchBundleRemover
implements UndoLastSessionListener {
    public static boolean nowRemoving = false;
    private int hostCount = 1;
    private int hostsRemaining = 1;
    private Percentage progress = new Percentage(0);
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties;
    private PatchProProperties associateProperties;
    private PatchBundleRemover patchRemover;
    private PatchList patchesToRemove;
    private LocalizedMessages msgcat;
    private File downloadDirectory;
    private Vector patchproExceptions = new Vector();
    private Enumeration associateHosts;
    private Host primaryHost;
    private Host associateHost;
    private PatchPro model;
    private AuditManager auditManager;
    private SignatureValidationUtil validationUtility = null;
    private boolean force = false;
    private boolean permissive = false;
    Vector missingHosts = new Vector();
    private boolean debug = false;

    public GroupPatchBundleRemover(PatchPro patchPro) {
        this.properties = PatchProProperties.getInstance();
        this.auditManager = AuditManager.getInstance();
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
        this.model = patchPro;
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        String string = this.properties.getProperty("patchpro.override.level", "standard");
        if (string.equals("force")) {
            this.force = true;
        } else if (string.equals("permissive")) {
            this.permissive = true;
        }
        this.debug = this.properties.getProperty("patchpro.patch.install.debug", "false").equals("true");
    }

    public void populateHostPatchLists(Host host) {
        AuditRecord[] auditRecordArray = this.auditManager.getLastInstallSession();
        for (int i = 0; i < auditRecordArray.length; ++i) {
            Object object;
            Object object2;
            SessionData sessionData;
            IPatch iPatch;
            AuditRecord auditRecord = auditRecordArray[i];
            String string = auditRecord.getTargetHostAddress();
            Host host2 = null;
            try {
                Object[] objectArray;
                host2 = host.getAssociateByAddress(string);
                if (this.missingHosts.contains(host2)) {
                    throw new NoSuchObjectException();
                }
                iPatch = new IPatch(auditRecord.getPatch());
                sessionData = host2.getSessionData();
                if (!host2.isArchitecture(auditRecord.getTargetHostArchitecture())) {
                    objectArray = new Object[]{string};
                    object2 = this.msgcat.getMessage("InternalErrorException.WRONGHOSTARCH_MESSAGE", objectArray, "IP Address " + string + ": architecture has changed.");
                    object = new InternalErrorException("InternalErrorException.WRONGHOSTARCH_MESSAGE", (String)object2, this.msgcat.getMessage("InternalErrorException.REMEDY", "Check the configuration of the current host."), 2);
                    sessionData.addPatchProException((PatchProException)object);
                    iPatch.setError((String)object2);
                } else if (!host2.isOperatingSystem(auditRecord.getTargetHostOS())) {
                    objectArray = new Object[]{string};
                    object2 = this.msgcat.getMessage("InternalErrorException.WRONGHOSTOS_MESSAGE", objectArray, "IP Address " + string + ": OS has changed.");
                    object = new InternalErrorException("InternalErrorException.WRONGHOSTOS_MESSAGE", (String)object2, this.msgcat.getMessage("InternalErrorException.REMEDY", "Check the configuration of your current host."), 2);
                    sessionData.addPatchProException((PatchProException)object);
                    iPatch.setError((String)object2);
                } else if (!host2.isOSRelease(auditRecord.getTargetHostOSRelease())) {
                    objectArray = new Object[]{string};
                    object2 = this.msgcat.getMessage("InternalErrorException.WRONGHOSTRELEASE_MESSAGE", objectArray, "IP Address " + string + ": OS release has changed.");
                    object = new InternalErrorException("InternalErrorException.WRONGHOSTRELEASE_MESSAGE", (String)object2, this.msgcat.getMessage("InternalErrorException.REMEDY", "Check the configuration of your current host."), 2);
                    sessionData.addPatchProException((PatchProException)object);
                    iPatch.setError((String)object2);
                }
                sessionData.addPatchToRemove(iPatch);
                continue;
            }
            catch (Exception exception) {
                try {
                    if (host2 == null) {
                        host2 = new Host();
                        host2.setAddress(string);
                        host2.setType(auditRecord.getTargetHostType());
                        host2.setArchitecture(auditRecord.getTargetHostArchitecture());
                        host2.setOperatingSystem(auditRecord.getTargetHostOS());
                        host2.setOSRelease(auditRecord.getTargetHostOSRelease());
                        host.addAssociate(host2);
                        this.missingHosts.addElement(host2);
                    }
                    object2 = new Object[]{string};
                    object = this.msgcat.getMessage("InternalErrorException.NOHOST_MESSAGE", (Object[])object2, "IP Address " + string + ": No such host.");
                    iPatch = new IPatch(auditRecord.getPatch());
                    sessionData = host2.getSessionData();
                    InternalErrorException internalErrorException = new InternalErrorException("InternalErrorException.NOHOST_MESSAGE", (String)object, this.msgcat.getMessage("InternalErrorException.NOHOST_REMEDY", "Determine if the indicated host is supposed to still be a part of this system. If so, use the \"-P\" option to skip it for now. If that component has been permanently removed, retry with the \"-F\" option."), 2);
                    sessionData.addPatchProException(internalErrorException);
                    iPatch.setError((String)object);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public void testUndoLast(Host host) {
        this.hostCount = this.hostsRemaining = host.getAssociateCount() + 1;
        this.associateHosts = host.getAssociates();
        while (this.associateHosts.hasMoreElements()) {
            this.associateHost = (Host)this.associateHosts.nextElement();
            this.patchesToRemove = null;
            if (this.associateHost.getSessionData().getIgnoreStatus()) continue;
            try {
                this.patchesToRemove = this.associateHost.getSessionData().getPatchesToRemove();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            this.properties = this.properties.getHostSpecificProperties(this.associateHost);
            try {
                this.validationUtility = SignatureValidationUtil.getValidationUtility(this.properties, null);
            }
            catch (NoKeystorePresentException noKeystorePresentException) {
                this.validationUtility = null;
            }
            catch (NoSigningCertException noSigningCertException) {
                this.validationUtility = null;
            }
            this.patchRemover = new PatchBundleRemover(this.model);
            this.patchRemover.initialize(this.associateHost);
            this.patchRemover.testUndoLast(host, this.associateHost, this.patchesToRemove, this.validationUtility);
        }
        if (!host.getSessionData().getIgnoreStatus()) {
            try {
                this.patchesToRemove = host.getSessionData().getPatchesToRemove();
            }
            catch (NoResultException noResultException) {
                this.patchesToRemove = null;
            }
            this.patchRemover = new PatchBundleRemover(this.model);
            this.patchRemover.initialize(host);
            this.patchRemover.testUndoLast(host, null, this.patchesToRemove, this.validationUtility);
        }
    }

    public void mayUndo(ReadOnlyHost readOnlyHost) throws UndoNotPermittedException, NoUndoElementsException {
        int n;
        int n2;
        PatchList patchList;
        SessionData sessionData;
        int n3 = 0;
        this.associateHosts = readOnlyHost.getAssociates();
        while (this.associateHosts.hasMoreElements()) {
            this.associateHost = (Host)this.associateHosts.nextElement();
            sessionData = this.associateHost.getSessionData();
            try {
                patchList = sessionData.getPatchesToRemove();
                n2 = patchList.size();
                n3 += n2;
                if (!patchList.hasAnyErrors()) continue;
                for (n = 0; n < n2; ++n) {
                    if (!patchList.hasErrorAt(n) || this.force || this.permissive) continue;
                    Patch patch = patchList.getPatchAt(n);
                    String string = patchList.getErrorAt(n);
                    UndoNotPermittedException undoNotPermittedException = new UndoNotPermittedException("UndoNotPermittedException", patch.getPatchID().getPatchID() + ": " + "UndoNotPermittedException.MESSAGE", string, 4);
                    sessionData.addPatchProException(undoNotPermittedException);
                    throw undoNotPermittedException;
                }
            }
            catch (NoResultException noResultException) {
            }
            catch (NoSuchPatchException noSuchPatchException) {
            }
        }
        sessionData = readOnlyHost.getSessionData();
        try {
            patchList = sessionData.getPatchesToRemove();
            n2 = patchList.size();
            n3 += n2;
            if (patchList.hasAnyErrors()) {
                for (n = 0; n < n2; ++n) {
                    if (!patchList.hasErrorAt(n) || this.force || this.permissive) continue;
                    Patch patch = patchList.getPatchAt(n);
                    String string = patchList.getErrorAt(n);
                    UndoNotPermittedException undoNotPermittedException = new UndoNotPermittedException("UndoNotPermittedException", patch.getPatchID().getPatchID() + ": " + "UndoNotPermittedException.MESSAGE", string, 4);
                    sessionData.addPatchProException(undoNotPermittedException);
                    throw undoNotPermittedException;
                }
            }
        }
        catch (NoResultException noResultException) {
        }
        catch (NoSuchPatchException noSuchPatchException) {
            // empty catch block
        }
        if (n3 == 0) {
            NoUndoElementsException noUndoElementsException = new NoUndoElementsException("NoUndoElementsException", "NoUndoElementsException.MESSAGE", "NoUndoElementsException.REMEDY", 4);
            readOnlyHost.getSessionData().addPatchProException(noUndoElementsException);
            throw noUndoElementsException;
        }
    }

    public void undoLast(Host host) throws RemoveFailedException {
        block14: {
            if (nowRemoving) {
                throw new RemoveFailedException("Already Running");
            }
            nowRemoving = true;
            this.auditManager.startBackoutSession();
            this.hostCount = this.hostsRemaining = host.getAssociateCount() + 1;
            try {
                Object[] objectArray;
                this.associateHosts = host.getAssociates();
                while (this.associateHosts.hasMoreElements()) {
                    this.associateHost = (Host)this.associateHosts.nextElement();
                    this.patchesToRemove = null;
                    if (this.associateHost.getSessionData().getIgnoreStatus()) continue;
                    try {
                        this.patchesToRemove = this.associateHost.getSessionData().getPatchesToRemove();
                    }
                    catch (NoResultException noResultException) {
                        // empty catch block
                    }
                    this.properties = this.properties.getHostSpecificProperties(this.associateHost);
                    this.patchRemover = new PatchBundleRemover(this.model);
                    if (this.missingHosts.contains(this.associateHost)) {
                        objectArray = new Object[]{this.associateHost.getAddress()};
                        this.patchRemover.errorRemainingPatchList(this.patchesToRemove, 0, this.msgcat.getMessage("PatchBundleRemover.NOHOST_MESSAGE", objectArray, "This patch is for a non-existent host at IP Address " + objectArray[0] + "."), this.associateHost);
                        continue;
                    }
                    this.patchRemover.addListener(this);
                    this.patchRemover.initialize(this.associateHost);
                    this.patchRemover.undoLast(host, this.associateHost, this.patchesToRemove, this.validationUtility);
                    this.patchRemover.removeListener(this);
                }
                if (host.getSessionData().getIgnoreStatus()) break block14;
                try {
                    this.patchesToRemove = host.getSessionData().getPatchesToRemove();
                }
                catch (NoResultException noResultException) {
                    this.patchesToRemove = null;
                }
                this.patchRemover = new PatchBundleRemover(this.model);
                if (this.missingHosts.contains(this.associateHost)) {
                    objectArray = new Object[]{this.associateHost.getAddress()};
                    this.patchRemover.errorRemainingPatchList(this.patchesToRemove, 0, this.msgcat.getMessage("PatchBundleRemover.NOHOST_MESSAGE", objectArray, "This patch is for a non-existent host at IP Address " + objectArray[0] + "."), host);
                } else {
                    this.patchRemover.addListener(this);
                    this.patchRemover.initialize(host);
                    this.patchRemover.undoLast(host, null, this.patchesToRemove, this.validationUtility);
                    this.patchRemover.removeListener(this);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 2, "GroupPatchBundleRemover: Internal error. Unknown Error");
                this.log.printStackTrace(this, 2, exception);
                nowRemoving = false;
                throw new RemoveFailedException(exception.getMessage());
            }
            finally {
                this.patchRemover.removeListener(this);
                this.auditManager.endBackoutSession();
            }
        }
        nowRemoving = false;
    }

    public Percentage percentComplete() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UndoLastSessionListener undoLastSessionListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(undoLastSessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UndoLastSessionListener undoLastSessionListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(undoLastSessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoLastSessionProgress(UndoLastSessionEvent undoLastSessionEvent) {
        int n = undoLastSessionEvent == null ? 100 : ((PatchBundleRemover)undoLastSessionEvent.getSource()).removeProgress().getPercentage();
        Percentage percentage = this.progress;
        synchronized (percentage) {
            this.progress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
        }
        this.dispatchProgressEvent(new UndoLastSessionEvent(this));
    }

    public void undoLastSessionDone(UndoLastSessionEvent undoLastSessionEvent) {
        if (--this.hostsRemaining == 0) {
            this.dispatchDoneEvent(new UndoLastSessionEvent(this));
        }
    }

    public void undoLastSessionFailed(UndoLastSessionEvent undoLastSessionEvent) {
        this.dispatchFailedEvent(undoLastSessionEvent);
    }

    private void dispatchProgressEvent(UndoLastSessionEvent undoLastSessionEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            UndoLastSessionListener undoLastSessionListener = (UndoLastSessionListener)enumeration.nextElement();
            undoLastSessionListener.undoLastSessionProgress(undoLastSessionEvent);
        }
    }

    private void dispatchDoneEvent(UndoLastSessionEvent undoLastSessionEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            UndoLastSessionListener undoLastSessionListener = (UndoLastSessionListener)enumeration.nextElement();
            undoLastSessionListener.undoLastSessionDone(undoLastSessionEvent);
        }
    }

    private void dispatchFailedEvent(UndoLastSessionEvent undoLastSessionEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            UndoLastSessionListener undoLastSessionListener = (UndoLastSessionListener)enumeration.nextElement();
            undoLastSessionListener.undoLastSessionFailed(undoLastSessionEvent);
        }
    }
}

