/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

public class GetOpt {
    private int optind = 0;
    private String optarg;
    private String[] argv;
    private int argc;
    private String optionString;
    static int MINUS_POSITION = 0;
    static int OPTION_POSITION = 1;
    static int AFTER_OPTION_POSITION = 2;
    private static final String sccs_id = "1.1";

    public GetOpt(String[] stringArray, String string) {
        this.argv = stringArray;
        this.optionString = string;
        this.argc = stringArray.length;
    }

    public int getNextOption() throws IllegalArgumentException {
        this.optarg = null;
        if (this.optind >= this.argc || this.argv[this.optind].length() < 2 || this.argv[this.optind].charAt(MINUS_POSITION) != '-') {
            return -1;
        }
        char c = this.argv[this.optind].charAt(OPTION_POSITION);
        if (!this.isValidOption(c)) {
            ++this.optind;
            throw new IllegalArgumentException("Illegal Option -- " + c);
        }
        if (this.isOptionArgAllowedByOption(c)) {
            if (this.argv[this.optind].length() != 2) {
                this.optarg = this.argv[this.optind].substring(AFTER_OPTION_POSITION);
                ++this.optind;
            } else if (this.optind + 1 >= this.argc) {
                ++this.optind;
                if (this.isOptionArgMandatoryByOption(c)) {
                    throw new IllegalArgumentException("Option requires an argument:" + c);
                }
            } else if (this.argv[this.optind + 1].charAt(MINUS_POSITION) == '-' && this.isValidOption(this.argv[this.optind + 1].charAt(OPTION_POSITION))) {
                ++this.optind;
                if (this.isOptionArgMandatoryByOption(c)) {
                    throw new IllegalArgumentException("Option -- " + c + " requires an argument");
                }
            } else {
                this.optarg = this.argv[++this.optind];
                ++this.optind;
            }
        } else if (this.argv[this.optind].length() == 2) {
            ++this.optind;
        } else {
            throw new IllegalArgumentException("Option -- " + c + " does not take an argument");
        }
        return c;
    }

    public String getOptionArg() {
        return this.optarg;
    }

    private boolean isValidOption(char c) {
        return c != ':' && this.optionString.indexOf(c) != -1;
    }

    private boolean isOptionArgMandatoryByOption(char c) {
        char c2 = c;
        return this.isValidOption(c) && this.optionString.length() > this.optionString.indexOf(c) + 1 && this.optionString.charAt(this.optionString.indexOf(c) + 1) == ':';
    }

    public int getNextOptionIndex() {
        return this.optind;
    }

    private boolean isOptionArgAllowedByOption(char c) {
        char c2 = c;
        return this.isValidOption(c) && this.optionString.length() > this.optionString.indexOf(c) + 1 && (this.optionString.charAt(this.optionString.indexOf(c) + 1) == ':' || this.optionString.charAt(this.optionString.indexOf(c) + 1) == ';');
    }

    public static void main(String[] stringArray) {
        GetOpt getOpt = new GetOpt(stringArray, "abc;d:ef");
        try {
            int n;
            block5: while ((n = getOpt.getNextOption()) != -1) {
                switch (n) {
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        System.out.println((char)n + " happened with optarg:" + getOpt.getOptionArg() + ":" + getOpt.getNextOptionIndex());
                        continue block5;
                    }
                }
                System.out.println("How did this happen");
            }
        }
        catch (Exception exception) {
            System.out.println("optind:" + getOpt.getNextOptionIndex());
            exception.printStackTrace();
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }
}

