/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.net.ssl.HttpsURLConnection;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.security.SSLTunnelSocketFactory;
import com.sun.patchpro.util.DownloadEvent;
import com.sun.patchpro.util.DownloadListener;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;
import sun.misc.BASE64Encoder;

public class Downloader
extends InputStream {
    private static final int MAXBUFFERSIZE = 0x100000;
    private static final double PERCENT = 0.05;
    protected URL sourceURL = null;
    private String postHeaderString = null;
    private String protocol = "";
    private int contentLength = 0;
    private URLConnection connection = null;
    private boolean protocolIsFile = false;
    private boolean fileIsAccessible = false;
    protected int onePercent;
    protected int totalbytes;
    private int numBytesRead;
    protected boolean cancelEnabled;
    protected boolean contract;
    protected String user = null;
    protected String password = null;
    private Vector listeners;
    protected BufferedInputStream in;
    protected PatchProLog log;

    public Downloader(URL uRL, String string, boolean bl, String string2, String string3) {
        this.sourceURL = uRL;
        this.protocol = this.sourceURL.getProtocol();
        this.postHeaderString = string;
        this.contract = bl;
        this.user = string2;
        this.password = string3;
        this.totalbytes = 0;
        this.cancelEnabled = false;
        this.log = PatchProLog.getInstance();
        if (this.protocol.compareTo("file") == 0) {
            this.protocolIsFile = true;
            File file = new File(this.sourceURL.getFile());
            if (file.exists() && file.canRead()) {
                this.fileIsAccessible = true;
            }
        }
        this.listeners = new Vector();
    }

    public Downloader(URL uRL) {
        this(uRL, "", false, "", "");
    }

    public void connectToURL() throws IOException {
        Object object;
        this.connection = this.sourceURL.openConnection();
        if (this.connection instanceof HttpsURLConnection) {
            object = System.getProperty("https.proxyHost");
            String string = System.getProperty("https.proxyPort");
            if (object != null && string != null && ((String)object).length() > 0 && string.length() > 0) {
                ((HttpsURLConnection)this.connection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory((String)object, string));
            }
        }
        this.connection.setAllowUserInteraction(true);
        if (this.contract) {
            this.setAuthentication(this.user, this.password);
        }
        if (this.postHeaderString.compareTo("") != 0) {
            this.connection.setDoOutput(true);
            object = new PrintWriter(this.connection.getOutputStream());
            ((PrintWriter)object).print(this.postHeaderString);
            ((PrintWriter)object).flush();
            if (((PrintWriter)object).checkError()) {
                this.log.println(this, 4, "PrinterWriter error!");
            }
            ((PrintWriter)object).close();
        }
        this.resetProgress();
        try {
            this.in = new BufferedInputStream(this.connection.getInputStream());
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            this.log.println(this, 4, "URLConnection.getInputStream threw an exception which is not of type IOException as described in the Java API specification.");
            throw new IOException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadListener downloadListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadListener downloadListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadListener);
        }
    }

    public String getContentType() {
        return this.connection.getContentType();
    }

    public int getContentLength() {
        int n;
        try {
            n = this.connection.getContentLength();
            if (n == -1) {
                n = 0x100000;
            }
        }
        catch (Exception exception) {
            this.log.println(this, 4, "URLConnection.getContentLength threw an exception instead of returning -1 as described in the Java API specification.");
            n = 0x100000;
        }
        return n;
    }

    public int getBufferLength() {
        int n = this.getContentLength();
        double d = (double)n * 0.05;
        if (d > 1048576.0) {
            d = 1048576.0;
        }
        return (int)d;
    }

    public int available() {
        return 1;
    }

    public Percentage getStatus() {
        Percentage percentage;
        int n = (int)((long)this.totalbytes / (long)this.onePercent);
        try {
            percentage = new Percentage(n);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Downloader.getStatus(): Unable to create a Percentage from " + n + ".");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    public Percentage getProgress() {
        return this.getStatus();
    }

    protected void resetProgress() {
        this.contentLength = this.getContentLength();
        this.onePercent = (int)((long)this.contentLength / 100L);
        this.numBytesRead = 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.cancelEnabled) {
            this.sendFailureEvent();
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            if (this.contentLength >= 0) {
                this.sendDoneEvent();
            } else {
                this.sendFailureEvent();
            }
        }
        this.numBytesRead += n3;
        if (this.numBytesRead >= this.getBufferLength()) {
            this.totalbytes += this.numBytesRead;
            this.numBytesRead = 0;
            this.updateProgress();
        }
        return n3;
    }

    public int read() throws IOException {
        if (this.cancelEnabled) {
            this.sendFailureEvent();
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            if (this.contentLength >= 0) {
                this.sendDoneEvent();
            } else {
                this.sendFailureEvent();
            }
        }
        ++this.totalbytes;
        if (this.totalbytes % (this.onePercent * 5) == 0) {
            this.updateProgress();
        }
        return n;
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgress() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadProgress(new DownloadEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDoneEvent() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadDone(new DownloadEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFailureEvent() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadFailed(new DownloadEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAuthenticationFailureEvent() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadFailed(new DownloadEvent(this));
            }
        }
    }

    public void cancelDownload() {
        this.cancelEnabled = true;
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public String getAuthenticationDomain() {
        String string = this.connection.getHeaderField("WWW-Authenticate");
        string = string.substring(string.indexOf(34) + 1, string.length() - 1);
        return string;
    }

    public void setAuthentication(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(':').append(string2);
        String string3 = new BASE64Encoder().encode(stringBuffer.toString().getBytes());
        this.connection.setRequestProperty("Authorization", "Basic " + string3);
    }

    public int getResponseCode() {
        int n = 0;
        if (this.protocolIsFile) {
            n = this.fileIsAccessible ? 200 : 404;
        } else {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.connection;
            StringTokenizer stringTokenizer = new StringTokenizer(httpURLConnection.getHeaderField(0));
            stringTokenizer.nextToken();
            Integer n2 = new Integer(stringTokenizer.nextToken());
            n = n2;
            this.log.println(this, 4, "response code is " + n);
        }
        return n;
    }

    public String getHeaderField(String string) {
        return this.connection.getHeaderField(string);
    }
}

