/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.ApplicationLog;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchEvent;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.Messagable;
import com.sun.patchpro.model.NonCriticalFailureEvent;
import com.sun.patchpro.model.NonCriticalFailureListener;
import com.sun.patchpro.model.PatchDownloadDirectoryAccessException;
import com.sun.patchpro.model.PatchDownloadIOException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.ServerConnectionException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.util.BundleDownloaderFailedException;
import com.sun.patchpro.util.DownloadEvent;
import com.sun.patchpro.util.DownloadListener;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class BundleDownloader
implements DownloadListener,
Messagable {
    public static final String defaultBundleName = "patchesBundle.tar";
    private PatchProProperties properties;
    private URL url;
    private Downloader downloader = null;
    private PatchProLog log = PatchProLog.getInstance();
    private Vector listeners;
    private Vector nonCriticalListeners;
    Vector exceptionRepository;
    private String user;
    private String password;
    private final String PATCHNOTES = "This patch bundle was generated by PatchPro.\n\nPlease refer to the README file within each patch for installation\ninstructions.  To properly patch your system, the following patches\nshould be installed in the listed order:\n\n";
    private final String README = " !!! SEE README !!! ";
    private static final String INCORRECT_URL = "Incorrect URL specified.";
    private static final String FAILED_CREATING_DOWNLOADER = "Failed to create downloader.";
    private static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Specified file name for the patch bundle is invalid.";
    private static final String INVALID_FILE_PERMISSION_TO_DOWNLOAD = "Write permissions required to perform patch download request.";
    private static final String INVALID_CONTENT_DATA = "Invalid content data.";
    private static final String AUTHENTICATION_FAILURE = "Server authentication failure.";
    private BundleDownloaderFailedException lnkBundleDownloaderFailedException;

    public BundleDownloader() throws Exception {
        this(null, "", "");
    }

    public BundleDownloader(String string) throws Exception {
        this(null, "", "");
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.log.println(this, 2, "MalformedURLException - incorrect URL " + malformedURLException.getMessage());
            this.dispatchFailedEvent(PatchProLog.createMessage(2, INCORRECT_URL));
            throw new Exception("URL error" + malformedURLException.getMessage());
        }
    }

    public BundleDownloader(URL uRL, String string, String string2) throws Exception {
        this.properties = PatchProProperties.getInstance();
        try {
            String string3 = this.properties.getProperty("patchpro.log.file", "system");
            this.log.setLogger(new ApplicationLog(string3));
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        this.url = uRL;
        this.user = string;
        this.password = string2;
        this.listeners = new Vector();
        this.nonCriticalListeners = new Vector();
        this.exceptionRepository = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(PatchList patchList, String string) throws BundleDownloaderFailedException {
        Closeable closeable;
        Object object;
        Object object2;
        File file = new File(string);
        String string2 = null;
        if (!file.isDirectory()) {
            string2 = string;
        } else {
            if (!file.exists()) {
                file.mkdirs();
            }
            string2 = string + File.separator + defaultBundleName;
        }
        int n = patchList.size();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            try {
                if (!patchList.getSelectionStatus(i)) continue;
                bl2 = true;
                object2 = patchList.getPatchAt(i);
                object = object2.getPatchID().getPatchID();
                stringBuffer.append((String)object).append(" ");
                stringBuffer2.append("p=").append(URLEncoder.encode((String)object));
                stringBuffer2.append('&');
                if (object2.getPatchInfo().getProperties().isNoncontract()) continue;
                bl = true;
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("This patch bundle was generated by PatchPro.\n\nPlease refer to the README file within each patch for installation\ninstructions.  To properly patch your system, the following patches\nshould be installed in the listed order:\n\n").append(this.convertPatch2ReadMeNotes(stringBuffer.toString()));
        stringBuffer2.append("t=").append(URLEncoder.encode(stringBuffer3.toString()));
        stringBuffer2.append('\n');
        if (this.url == null) {
            try {
                this.createURL(bl);
            }
            catch (BundleDownloaderFailedException bundleDownloaderFailedException) {
                object = new ServerConnectionException("ServerConnectionException", "ServerConnectionException.MESSAGE", "ServerConnectionException.REMEDY", 2);
                if (!this.exceptionRepository.contains(object)) {
                    this.exceptionRepository.add(object);
                }
                throw bundleDownloaderFailedException;
            }
        }
        if (!bl2) {
            this.dispatchDoneEvent("");
            return;
        }
        try {
            this.downloader = new Downloader(this.url, stringBuffer2.toString(), bl, this.user, this.password);
            this.downloader.connectToURL();
            this.log.println(this, 7, "BundleDownloader.download(): downloader is " + this.downloader);
        }
        catch (IOException iOException) {
            object = new ServerConnectionException("ServerConnectionException", "ServerConnectionException.MESSAGE", "ServerConnectionException.REMEDY", 2);
            if (!this.exceptionRepository.contains(object)) {
                this.exceptionRepository.add(object);
            }
            if (this.downloader == null) {
                this.log.println(this, 3, "BundleDownloader: Cannot create Downloader that connects to: " + this.url.toString());
                this.log.printStackTrace(this, 3, iOException);
                throw new BundleDownloaderFailedException("Failed to create Downloader " + iOException.getMessage());
            }
            if (this.downloader.getResponseCode() != 401) {
                this.log.println(this, 3, "BundleDownloader : IOException" + iOException.getMessage());
                throw new BundleDownloaderFailedException("Failed to create Downloader " + iOException.getMessage());
            }
            closeable = new BufferedInputStream(this.downloader);
            this.downloader.sendAuthenticationFailureEvent();
        }
        object2 = this.listeners;
        synchronized (object2) {
            this.downloader.addListener(this);
        }
        if (this.downloader.getContentType().compareTo("application/octet-stream") == 0) {
            block38: {
                object2 = new BufferedInputStream(this.downloader);
                boolean bl3 = false;
                closeable = null;
                try {
                    closeable = new FileOutputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 3);
                    if (!this.exceptionRepository.contains(patchDownloadDirectoryAccessException)) {
                        this.exceptionRepository.add(patchDownloadDirectoryAccessException);
                    }
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_PATCH_BUNDLE_FILE_NAME));
                    this.sendNonCriticalFailureEvent();
                    throw new BundleDownloaderFailedException(INVALID_PATCH_BUNDLE_FILE_NAME);
                }
                this.log.println(this, 6, "Downloading tar file in " + string2 + " ....");
                int n2 = 0;
                int n3 = this.downloader.getBufferLength();
                byte[] byArray = new byte[n3];
                try {
                    while ((n2 = ((BufferedInputStream)object2).read(byArray, 0, n3)) != -1) {
                        try {
                            ((FileOutputStream)closeable).write(byArray, 0, n2);
                        }
                        catch (SecurityException securityException) {
                            PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 3);
                            if (!this.exceptionRepository.contains(patchDownloadDirectoryAccessException)) {
                                this.exceptionRepository.add(patchDownloadDirectoryAccessException);
                            }
                            this.log.println(this, 3, string2 + "no permission to access");
                            this.log.printStackTrace(this, 3, securityException);
                            this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_FILE_PERMISSION_TO_DOWNLOAD));
                            this.sendNonCriticalFailureEvent();
                            throw new BundleDownloaderFailedException(INVALID_FILE_PERMISSION_TO_DOWNLOAD);
                        }
                    }
                    ((FileOutputStream)closeable).close();
                    ((BufferedInputStream)object2).close();
                }
                catch (IOException iOException) {
                    PatchDownloadIOException patchDownloadIOException = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                    if (this.exceptionRepository.contains(patchDownloadIOException)) break block38;
                    this.exceptionRepository.add(patchDownloadIOException);
                }
            }
            if (!this.downloader.isCancelEnabled()) {
                this.log.println(this, 6, "Downloading done " + string2);
            } else {
                this.log.println(this, 6, "Cancel downloading done " + string2);
            }
            this.dispatchDoneEvent("");
        } else {
            object2 = new BufferedInputStream(this.downloader);
            int n4 = 0;
            while (n4 >= 0) {
                try {
                    n4 = ((BufferedInputStream)object2).read();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n4 != -1) continue;
            }
            this.log.println(this, 3, "Error : Invalid content data " + this.downloader.getContentType());
        }
        object2 = this.listeners;
        synchronized (object2) {
            this.downloader.addListener(this);
        }
    }

    public Collection getPatchProExceptions() {
        return this.exceptionRepository;
    }

    private void createURL(boolean bl) throws BundleDownloaderFailedException {
        this.log.println(this, 7, "BundleDownloader: Dealing with contract patch: " + bl);
        String string = bl ? this.properties.getProperty("patchpro.contract.patch.bundle.url") : this.properties.getProperty("patchpro.public.patch.bundle.url");
        this.log.println(this, 7, "BundleDownloader: urlString: " + string);
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.log.println(this, 2, "MalformedURLException - incorrect URL " + malformedURLException.getMessage());
            throw new BundleDownloaderFailedException("URL error" + malformedURLException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDownload() throws BundleDownloaderFailedException {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.downloader != null) {
                try {
                    this.downloader.cancelDownload();
                }
                catch (Exception exception) {
                    this.log.println(this, 7, "Exception - failed to cancel download " + exception.getMessage());
                    throw new BundleDownloaderFailedException("Exception - failed to cancel download " + exception.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(NonCriticalFailureListener nonCriticalFailureListener) {
        Vector vector = this.nonCriticalListeners;
        synchronized (vector) {
            this.nonCriticalListeners.addElement(nonCriticalFailureListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(NonCriticalFailureListener nonCriticalFailureListener) {
        Vector vector = this.nonCriticalListeners;
        synchronized (vector) {
            this.nonCriticalListeners.removeElement(nonCriticalFailureListener);
        }
    }

    private String convertPatch2ReadMeNotes(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = ") ";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            stringBuffer.append(++n).append(string2).append(string3).append(" !!! SEE README !!! ").append('\n');
        }
        return stringBuffer.toString();
    }

    public Percentage getStatus() {
        return this.downloader.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNonCriticalFailureEvent() {
        Vector vector = this.nonCriticalListeners;
        synchronized (vector) {
            for (int i = 0; i < this.nonCriticalListeners.size(); ++i) {
                NonCriticalFailureListener nonCriticalFailureListener = (NonCriticalFailureListener)this.nonCriticalListeners.elementAt(i);
                nonCriticalFailureListener.failure(new NonCriticalFailureEvent(this));
            }
        }
    }

    public void setAuthentication(String string, String string2) {
        this.user = string;
        this.password = string2;
    }

    public String getAuthenticationDomain() {
        return this.downloader.getAuthenticationDomain();
    }

    public synchronized void downloadProgress(DownloadEvent downloadEvent) {
        this.dispatchProgressEvent(downloadEvent.toString());
    }

    public synchronized void downloadDone(DownloadEvent downloadEvent) {
        this.dispatchDoneEvent(downloadEvent.toString());
    }

    public synchronized void downloadFailed(DownloadEvent downloadEvent) {
        this.dispatchFailedEvent(downloadEvent.toString());
    }

    private void dispatchProgressEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchProgress(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchDoneEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchDone(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchFailedEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchFailed(new DownloadPatchEvent(this, string));
        }
    }
}

