/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.database.AuditRecord;
import com.sun.patchpro.database.AuditRecordParsingException;
import com.sun.patchpro.database.DspFirmwareImageAuditRecord;
import com.sun.patchpro.database.FirmwareImageAuditRecord;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.util.AuditTransactionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class AuditManager {
    private static AuditManager thisAuditManager;
    private boolean keepAudit;
    private boolean testMode;
    private boolean backoutSessionCompleted;
    private boolean installSessionCompleted;
    private File cachedLastBackoutAuditFile = null;
    private File cachedLastInstallAuditFile = null;
    private File currentBackoutAuditFile = null;
    private File currentInstallAuditFile = null;
    private PatchProProperties properties;
    private Vector lastInstallSessionRecords = new Vector(0);
    private Vector lastBackoutSessionRecords = new Vector(0);

    private AuditManager() {
        this.properties = PatchProProperties.getInstance();
        String string = this.properties.getProperty("history.test", "false");
        this.testMode = string.compareTo("true") == 0;
        String string2 = this.properties.getProperty("patchpro.keep.history", "false");
        this.keepAudit = string2.compareTo("true") == 0;
        this.installSessionCompleted = true;
        this.backoutSessionCompleted = true;
    }

    public static AuditManager getInstance() {
        if (thisAuditManager == null) {
            thisAuditManager = new AuditManager();
        }
        return thisAuditManager;
    }

    public synchronized void installConfirm(Patch patch, Host host) throws AuditTransactionException {
        if (this.keepAudit) {
            AuditRecord auditRecord = new AuditRecord(host, patch);
            this.installConfirm(auditRecord);
        }
    }

    public synchronized void installConfirm(AuditRecord auditRecord) throws AuditTransactionException {
        if (this.keepAudit) {
            File file = this.getCurrentInstallAuditFile();
            if (file == null) {
                throw new AuditTransactionException("Cannot find an appropriate install audit file.", null, 1);
            }
            auditRecord.recordInstall(file, "");
        }
    }

    public synchronized void removeConfirm(Patch patch, Host host) throws AuditTransactionException {
        if (this.keepAudit) {
            AuditRecord auditRecord = new AuditRecord(host, patch);
            this.removeConfirm(auditRecord);
        }
    }

    public synchronized void removeConfirm(AuditRecord auditRecord) throws AuditTransactionException {
        if (this.keepAudit) {
            File file = this.getCurrentBackoutAuditFile();
            if (file == null) {
                throw new AuditTransactionException("Cannot find an appropriate backout audit file.", null, 1);
            }
            auditRecord.recordBackout(file);
            this.postprocessBackout();
        }
    }

    private void postprocessBackout() {
        if (this.bHasAllA()) {
            File file;
            File file2 = this.cachedLastInstallAuditFile;
            if (file2 != null) {
                file = this.getReprefixedFile("ua", file2);
                file2.renameTo(file);
            }
            if ((file = this.cachedLastBackoutAuditFile) != null) {
                File file3 = this.getReprefixedFile("ub", file);
                file.renameTo(file3);
            }
            this.backoutSessionCompleted = true;
        }
    }

    private File getReprefixedFile(String string, File file) {
        String string2 = file.getName();
        String string3 = file.getParentFile().getPath();
        String string4 = string + string2.substring(1);
        File file2 = new File(string3 + File.separator + string4);
        return file2;
    }

    private boolean bHasAllA() {
        Hashtable hashtable = this.getLastBackoutSessionHashtable();
        AuditRecord[] auditRecordArray = this.getLastInstallSession();
        for (int i = 0; i < auditRecordArray.length; ++i) {
            String string = auditRecordArray[i].getPatch().getPatchID().getPatchID();
            AuditRecord auditRecord = (AuditRecord)hashtable.get(string);
            if (auditRecord != null) continue;
            return false;
        }
        return true;
    }

    public synchronized void startInstallSession() {
    }

    public synchronized void endInstallSession() {
        this.installSessionCompleted = true;
    }

    public synchronized void startBackoutSession() {
    }

    public synchronized void endBackoutSession() {
        this.backoutSessionCompleted = true;
        this.postprocessBackout();
    }

    public void setDeferredPatches(PatchList patchList) {
    }

    public AuditRecord[] getLastCommittedUndoSession() {
        Vector vector = this.getLastInstallSessionRecords();
        if (vector == null) {
            return new AuditRecord[0];
        }
        Object[] objectArray = vector.toArray();
        AuditRecord[] auditRecordArray = new AuditRecord[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            auditRecordArray[i] = (AuditRecord)objectArray[i];
        }
        return auditRecordArray;
    }

    public AuditRecord[] getLastInstallSession() {
        AuditRecord[] auditRecordArray = this.getLastCommittedUndoSession();
        int n = auditRecordArray.length;
        AuditRecord[] auditRecordArray2 = new AuditRecord[n];
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            auditRecordArray2[n2++] = auditRecordArray[i];
        }
        return auditRecordArray2;
    }

    public AuditRecord[] getCurrentUndoSession() {
        return null;
    }

    public AuditRecord[] getLastBackoutSession() {
        return this.getLastBackoutSession(false);
    }

    public AuditRecord[] getLastBackoutSession(boolean bl) {
        Vector vector = this.getLastBackoutSessionRecords(bl);
        if (vector == null) {
            return new AuditRecord[0];
        }
        Object[] objectArray = vector.toArray();
        AuditRecord[] auditRecordArray = new AuditRecord[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            auditRecordArray[i] = (AuditRecord)objectArray[i];
        }
        return auditRecordArray;
    }

    public long getLastInstallSessionTimestamp() {
        return 0L;
    }

    public AuditRecord[] getLatestDeferredPatches() {
        return null;
    }

    public AuditRecord getInstalledPatchAuditRecord(PatchID patchID) throws NoSuchPatchException {
        String string = patchID.getPatchID();
        Vector vector = this.getLastInstallSessionRecords();
        AuditRecord auditRecord = null;
        String string2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            auditRecord = (AuditRecord)vector.elementAt(i);
            string2 = auditRecord.getPatch().getPatchID().getPatchID();
            if (string.compareTo(string2) != 0) continue;
            return auditRecord;
        }
        throw new NoSuchPatchException("Cannot find patch: " + string);
    }

    private Hashtable getLastBackoutSessionHashtable() {
        AuditRecord[] auditRecordArray = this.getLastBackoutSession(true);
        Hashtable<String, AuditRecord> hashtable = new Hashtable<String, AuditRecord>();
        for (int i = 0; i < auditRecordArray.length; ++i) {
            String string = auditRecordArray[i].getPatch().getPatchID().getPatchID();
            hashtable.put(string, auditRecordArray[i]);
        }
        return hashtable;
    }

    private synchronized Vector getLastInstallSessionRecords() {
        boolean bl = false;
        File file = this.getLastInstallAuditFile();
        if (file == null || this.cachedLastInstallAuditFile == null) {
            bl = true;
        } else if (this.cachedLastInstallAuditFile.getPath().compareTo(file.getPath()) != 0 && this.installSessionCompleted) {
            bl = true;
        }
        if (bl) {
            if (this.lastInstallSessionRecords == null) {
                this.lastInstallSessionRecords = new Vector();
            } else {
                this.lastInstallSessionRecords.clear();
            }
            if (file == null) {
                return null;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file.getPath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            try {
                String string;
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                Hashtable hashtable = this.getLastBackoutSessionHashtable();
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    AuditRecord auditRecord;
                    AuditRecord auditRecord2;
                    if (string.startsWith("#") || (auditRecord2 = this.parseAuditRecord(string)) == null || (auditRecord = (AuditRecord)hashtable.get(string2 = auditRecord2.getPatch().getPatchID().getPatchID())) != null) continue;
                    this.lastInstallSessionRecords.addElement(auditRecord2);
                }
            }
            catch (IOException iOException) {
                return null;
            }
            this.cachedLastInstallAuditFile = file;
        }
        return this.lastInstallSessionRecords;
    }

    private synchronized Vector getLastBackoutSessionRecords(boolean bl) {
        boolean bl2 = false;
        File file = this.getLastBackoutAuditFile();
        if (bl) {
            bl2 = true;
        } else if (file == null || this.cachedLastBackoutAuditFile == null) {
            bl2 = true;
        } else if (this.cachedLastBackoutAuditFile.getPath().compareTo(file.getPath()) != 0 && this.backoutSessionCompleted) {
            bl2 = true;
        }
        if (bl2) {
            if (this.lastBackoutSessionRecords == null) {
                this.lastBackoutSessionRecords = new Vector();
            } else {
                this.lastBackoutSessionRecords.clear();
            }
            if (file == null) {
                return null;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file.getPath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            try {
                String string;
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    AuditRecord auditRecord;
                    if (string.startsWith("#") || (auditRecord = this.parseAuditRecord(string)) == null) continue;
                    this.lastBackoutSessionRecords.addElement(auditRecord);
                }
            }
            catch (IOException iOException) {
                return null;
            }
            this.cachedLastBackoutAuditFile = file;
        }
        return this.lastBackoutSessionRecords;
    }

    private File getCurrentBackoutAuditFile() {
        if (this.backoutSessionCompleted || this.currentBackoutAuditFile == null) {
            File file;
            String string = this.properties.getProperty("patchpro.keep.history.directory");
            if (string == null) {
                return null;
            }
            File file2 = new File(string);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if ((file = this.getLastBackoutAuditFile()) == null) {
                File file3 = this.getLastInstallAuditFile();
                if (file3 == null) {
                    return null;
                }
                this.currentBackoutAuditFile = this.getReprefixedFile("b", file3);
                this.backoutSessionCompleted = false;
            } else {
                this.currentBackoutAuditFile = file;
            }
        }
        return this.currentBackoutAuditFile;
    }

    private File getNewBackoutAuditFile() {
        File file = this.getLastInstallAuditFile();
        if (file != null) {
            file = this.getReprefixedFile("b", file);
        }
        return file;
    }

    private File getCurrentInstallAuditFile() {
        if (this.installSessionCompleted || this.currentInstallAuditFile == null) {
            String string = this.properties.getProperty("patchpro.keep.history.directory");
            if (string == null) {
                return null;
            }
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            long l = new Date().getTime();
            this.currentInstallAuditFile = new File(string + File.separator + "a." + Long.toString(l));
            this.installSessionCompleted = false;
        }
        return this.currentInstallAuditFile;
    }

    private File getLastBackoutAuditFile() {
        String string = this.properties.getProperty("patchpro.keep.history.directory");
        return this.getLatestFile("b.", string);
    }

    private File getLastInstallAuditFile() {
        String string = this.properties.getProperty("patchpro.keep.history.directory");
        return this.getLatestFile("a.", string);
    }

    private File getLatestFile(String string, String string2) {
        File file = null;
        if (string2 != null) {
            File file2 = new File(string2);
            if (!file2.exists()) {
                return null;
            }
            Object[] objectArray = file2.list();
            Arrays.sort(objectArray);
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (((String)objectArray[i]).indexOf(string) != 0) continue;
                vector.addElement(objectArray[i]);
            }
            Object[] objectArray2 = vector.toArray();
            Object[] objectArray3 = new String[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray3[i] = string2 + File.separator + (String)objectArray2[i];
            }
            Arrays.sort(objectArray3);
            if (objectArray3.length > 0) {
                file = new File((String)objectArray3[objectArray3.length - 1]);
            }
        }
        return file;
    }

    private AuditRecord parseAuditRecord(String string) {
        StringTokenizer stringTokenizer;
        AuditRecord auditRecord = null;
        if (this.testMode) {
            System.out.println("AuditManager.parseAuditRecord - " + string);
        }
        if ((stringTokenizer = new StringTokenizer(string, "|")).hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.testMode) {
                System.out.println("parseAuditRecord found record type: " + string2);
            }
            if (string2.compareTo("general") == 0) {
                try {
                    auditRecord = new AuditRecord(string);
                }
                catch (AuditRecordParsingException auditRecordParsingException) {
                    return null;
                }
            }
            if (string2.compareTo("firmware") == 0) {
                try {
                    auditRecord = new FirmwareImageAuditRecord(string);
                }
                catch (AuditRecordParsingException auditRecordParsingException) {
                    return null;
                }
            }
            if (string2.compareTo("dsp") == 0) {
                try {
                    auditRecord = new DspFirmwareImageAuditRecord(string);
                }
                catch (AuditRecordParsingException auditRecordParsingException) {
                    return null;
                }
            }
        }
        return auditRecord;
    }
}

