/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server.cli;

import com.sun.patchpro.util.LocalizedMessages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlProcessor {
    public Document doc;

    public XmlProcessor(String string) {
        this.doc = this.parseXmlFile(string, true);
    }

    public void writeXmlFile(String string) {
        try {
            DOMSource dOMSource = new DOMSource(this.doc);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-public", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
            transformer.setOutputProperty("doctype-system", "file:///usr/sadm/lib/patch/dtd/web-app_2_3.dtd");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            System.err.println(transformerException.getLocalizedMessage());
            System.exit(1);
        }
    }

    public Document parseXmlFile(String string, boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            File file = new File(string);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(file);
            return document;
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException.getLocalizedMessage());
            System.exit(1);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            System.exit(1);
        }
        return null;
    }

    public void modifyDOMnodeValue(String string, String string2) {
        NodeList nodeList = this.doc.getElementsByTagName("init-param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getElementsByTagName("param-name");
            Element element2 = (Element)nodeList2.item(0);
            String string3 = element2.getFirstChild().getNodeValue();
            if (!string3.equals(string)) continue;
            nodeList2 = element.getElementsByTagName("param-value");
            element2 = (Element)nodeList2.item(0);
            element2.getFirstChild().setNodeValue(string2);
        }
    }

    public void listParamValues() {
        NodeList nodeList = this.doc.getElementsByTagName("init-param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getElementsByTagName("param-name");
            Element element2 = (Element)nodeList2.item(0);
            NodeList nodeList3 = element.getElementsByTagName("param-value");
            Element element3 = (Element)nodeList3.item(0);
            if (element2 == null || element3 == null) continue;
            System.out.println(element2.getFirstChild().getNodeValue() + "=" + element3.getFirstChild().getNodeValue());
        }
    }

    public void listParamValues(String[] stringArray, LocalizedMessages localizedMessages) {
        if (localizedMessages == null) {
            throw new IllegalArgumentException("LocalizedMessages to process with is not defined");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        NodeList nodeList = this.doc.getElementsByTagName("init-param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getElementsByTagName("param-name");
            Element element2 = (Element)nodeList2.item(0);
            String string = element2.getFirstChild().getNodeValue();
            if (!arrayList.contains(string)) continue;
            NodeList nodeList3 = element.getElementsByTagName("param-value");
            Element element3 = (Element)nodeList3.item(0);
            if (element2 == null || element3 == null) continue;
            System.out.println(localizedMessages.getMessage(string, string) + ": " + element3.getFirstChild().getNodeValue());
        }
    }
}

