/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server.cli;

import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.server.cli.XmlProcessor;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.LocalizedMessages;

public final class PatchServerSetup {
    private static final String validArgs = "p:a:c:x:u:lh";
    private static final String[] initParamNames = new String[]{"patchsvr.source.0.url", "patchsvr.cache.location", "patchsvr.database.cache.old.age", "patchsvr.database.cache.dead.age", "patchsvr.detectors.cache.old.age", "patchsvr.detectors.cache.dead.age", "patchsvr.use.cache", "patchsvr.patch.download.authenticate", "patchsvr.security.patch.signingcert", "patchsvr.security.kslocation", "patchsvr.security.crl.source.url", "patchsvr.proxyserver.host", "patchsvr.proxyserver.port"};
    private static final String[] defaultInitParamValues = new String[]{"https://patchpro.sun.com/servlet/com.sun.patchpro.server.PatchProServerServlet", "/var/spool/patch/server", "1", "3", "1", "3", "true", "true", "patchsigning", "/etc/opt/SUNWppro/security/cacerts", "file:/opt/SUNWppro/lib/crl.jar", "", ""};
    private static final String[] displayParams = new String[]{"patchsvr.source.0.url", "patchsvr.cache.location", "patchsvr.use.cache", "patchsvr.patch.download.authenticate", "patchsvr.proxyserver.host", "patchsvr.proxyserver.port"};
    private LocalizedMessages msgcat;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private static XmlProcessor xmlp;
    PatchPro patchPro;

    public PatchServerSetup() throws PatchProException {
        PatchProAccessor patchProAccessor = new PatchProAccessor();
        xmlp = new XmlProcessor("/var/apache/tomcat/webapps/solaris/WEB-INF/web.xml");
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.patchPro = patchProAccessor.getPatchPro();
    }

    public static void main(String[] stringArray) {
        GetOpt getOpt = new GetOpt(stringArray, validArgs);
        LocalizedMessages localizedMessages = null;
        PatchServerSetup patchServerSetup = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        try {
            int n;
            PatchProProperties patchProProperties = PatchProProperties.getInstance();
            block13: while ((n = getOpt.getNextOption()) != -1) {
                bl2 = false;
                switch (n) {
                    case 112: {
                        string = getOpt.getOptionArg();
                        continue block13;
                    }
                    case 97: {
                        string2 = getOpt.getOptionArg();
                        continue block13;
                    }
                    case 99: {
                        string6 = getOpt.getOptionArg();
                        continue block13;
                    }
                    case 120: {
                        string7 = getOpt.getOptionArg();
                        continue block13;
                    }
                    case 117: {
                        string8 = getOpt.getOptionArg();
                        continue block13;
                    }
                    case 108: {
                        bl3 = true;
                        continue block13;
                    }
                    case 104: {
                        bl7 = true;
                        continue block13;
                    }
                }
                System.err.println(localizedMessages.getMessage("invalidOption", "Ignoring invalid option."));
            }
            try {
                patchServerSetup = new PatchServerSetup();
                localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
            }
            catch (PatchProException patchProException) {
                System.err.println(patchProException.getLocalizedMessage());
                if (bl) {
                    System.err.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
            if (bl7 || bl2) {
                PatchServerSetup.usage(localizedMessages);
                System.exit(0);
            }
            if (string != null) {
                PatchServerSetup.ChangeSvrUrl(string);
            }
            if (string2 != null) {
                PatchServerSetup.ChangeSvrAuthenticate(string2);
            }
            if (string3 != null) {
                PatchServerSetup.ChangeSvrSigningCert(string3);
            }
            if (string4 != null) {
                PatchServerSetup.ChangeSvrKestoreLoc(string4);
            }
            if (string5 != null) {
                PatchServerSetup.ChangeCrlLoc(string5);
            }
            if (string6 != null) {
                PatchServerSetup.ChangeCacheLoc(string6);
            }
            if (bl3) {
                PatchServerSetup.listSettings(localizedMessages);
            }
            if (string7 != null) {
                PatchServerSetup.ChangeSvrProxy(string7);
            }
            if (string8 != null) {
                PatchServerSetup.ChangeSvrUseCache(string8);
            }
            if (bl4) {
                patchServerSetup.setDefaultValues();
            }
            if (!bl3) {
                xmlp.writeXmlFile("/var/apache/tomcat/webapps/solaris/WEB-INF/web.xml");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            if (localizedMessages != null) {
                PatchServerSetup.usage(localizedMessages);
            }
            if (bl) {
                System.err.println("System.exit(1)");
                return;
            }
            System.exit(1);
        }
        if (bl) {
            return;
        }
        System.exit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("psvrsetupUsage", "usage:\tpsvrsetup [-a true|false] [-c cache-location]\n\t[-h] [-l] [-p patch-server-url] [-u true | false]\n\t[-x web-proxy-host:port]\n\n\tWhere:\n"));
        System.err.println("\t-a\t" + localizedMessages.getMessage("usageAuthentication", "Specifies whether patch authentication is required\n\t\tduring patch download"));
        System.err.println("\t-c\t" + localizedMessages.getMessage("usageCacheLocation", "Specifies the directory in which patches are cached"));
        System.err.println("\t-h\t" + localizedMessages.getMessage("usageHelp", "Displays command usage statement"));
        System.err.println("\t-l\t" + localizedMessages.getMessage("usageListProperties", "Displays the configuration properties that can be updated\n\t\tby users"));
        System.err.println("\t-p\t" + localizedMessages.getMessage("usagePatchServer", "Specifies the URL of the server that provides the patches"));
        System.err.println("\t-u\t" + localizedMessages.getMessage("usageCacheUse", "Specifies if the downloaded patches should be cached"));
        System.err.println("\t-x\t" + localizedMessages.getMessage("usageProxyServer", "Specifies the local web proxy server to use where host is\n\t\tthe host name and port is the port number"));
    }

    public static void ChangeSvrUrl(String string) {
        xmlp.modifyDOMnodeValue("patchsvr.source.0.url", string);
    }

    public static void ChangeSvrAuthenticate(String string) {
        xmlp.modifyDOMnodeValue("patchsvr.patch.download.authenticate", string);
    }

    public static void ChangeSvrSigningCert(String string) {
        xmlp.modifyDOMnodeValue("patchsvr.security.patch.signingcert", string);
    }

    public static void ChangeSvrKestoreLoc(String string) {
        xmlp.modifyDOMnodeValue("patchsvr.security.kslocation", string);
    }

    public static void ChangeCrlLoc(String string) {
        xmlp.modifyDOMnodeValue("patchsvr.security.crl.source.url", string);
    }

    public static void ChangeCacheLoc(String string) {
        xmlp.modifyDOMnodeValue("patchsvr.cache.location", string);
    }

    public static void ChangeSvrProxy(String string) {
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        if (string == null || string.equals("")) {
            bl = true;
            bl2 = true;
        } else {
            int n;
            int n2 = string.indexOf(58);
            if (n2 != -1 && n2 == (n = string.lastIndexOf(58))) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
                bl2 = true;
                try {
                    long l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getLocalizedMessage());
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            xmlp.modifyDOMnodeValue("patchsvr.proxyserver.host", string2);
            xmlp.modifyDOMnodeValue("patchsvr.proxyserver.port", string3);
        }
    }

    public static void ChangeSvrUseCache(String string) {
        xmlp.modifyDOMnodeValue("patchsvr.use.cache", string);
    }

    public static void listSettings(LocalizedMessages localizedMessages) {
        xmlp.listParamValues(displayParams, localizedMessages);
    }

    public void setDefaultValues() {
        for (int i = 0; i < initParamNames.length; ++i) {
            xmlp.modifyDOMnodeValue(initParamNames[i], defaultInitParamValues[i]);
        }
        System.out.println(this.msgcat.getMessage("defaultValueSet", "All parameters have been set to their default values"));
    }
}

