/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.patchpro.analysis.DetectorClassLoader;
import com.sun.patchpro.analysis.RealizationDetector;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.BadHttpResponseException;
import com.sun.patchpro.model.DownloadPatchEvent;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.InvalidPatchDownloadDirectoryException;
import com.sun.patchpro.model.PatchDownloadDirectoryAccessException;
import com.sun.patchpro.model.PatchDownloadIOException;
import com.sun.patchpro.model.PatchDownloadResponseException;
import com.sun.patchpro.model.PatchNotAvailableException;
import com.sun.patchpro.model.PatchNotFoundException;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchSignatureValidationException;
import com.sun.patchpro.model.ServerConnectionException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.ManifestFileNotFoundException;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.NotSignedByKnownCertificateException;
import com.sun.patchpro.security.SSLTunnelSocketFactory;
import com.sun.patchpro.security.SignatureCheckFailedException;
import com.sun.patchpro.security.SignatureValidationException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServiceProvider;
import com.sun.patchpro.server.PatchServiceUtil;
import com.sun.patchpro.server.ServerPatchServiceProviderException;
import com.sun.patchpro.server.ServerProxyAuthenticator;
import com.sun.patchpro.util.CachingDownloader;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;

public class ServerPatchServiceProvider
implements PatchServiceProvider {
    private LocalizedMessages msgcat;
    PatchInfoImpl genPatchInfo = null;
    boolean downloadAuthenticate = true;
    boolean isPatchServer = false;
    boolean updateSessionData = true;
    boolean useCache = true;
    PatchProProperties properties = PatchProProperties.getInstance();
    PatchProLog log = PatchProLog.getInstance();
    SignatureValidationUtil validationUtil;
    ServerProxyAuthenticator serverProxyAuthenticator = null;
    String keystoreLocation;
    String patchBundlePrefix = "";
    String serverURLString;
    String[] signingCertAliasArray;
    String signingCertAlias;
    String sunSolvePasswd = "";
    String sunSolveUser = "";
    String proxyUser = "";
    String proxyPasswd = "";
    String targetLocation;
    URL serverURL;
    Vector listeners = new Vector();
    boolean smpatch = false;
    static final int SEGMENTED_PATCHLIST_SIZE = 10;
    static final String AUTHENTICATION_FAILED = "ServicePatchServiceProvider.AUTHENTICATION_FAILED";
    static final String DOWNLOAD_DIR_NOT_EXIST = "Patch download directory does not exist.";
    static final String DOWNLOAD_DIR_NOT_WRITABLE = "Patch download directory is not writable.";
    static final String FAILED_TO_CREATE_DOWNLOADER = "Failed to create a downloader to download patches.";
    static final String FAILED_TO_CREATE_VALIDATION_UTIL = "Failed to create the signature valiation utility.";
    public static final String FAILED_TO_VALIDATE_SIGNATURE = "Failed to validate the digital signature(s).";
    static final String HTTP_PARTIAL_CONTENT = "Status code 206 returned.  The client's request was only partially fulfilled.";
    static final String HTTP_BAD_REQUEST = "Status code 400 returned. The server could not understand the request, probably due to a syntax error in the HTTP request.";
    static final String HTTP_UNAUTHORIZED = "Status code 401 returned. The request lacked proper authorization.";
    static final String HTTP_FORBIDDEN = "Status code 403 returned. The request was understood, but the server is not willing to fulfill it.";
    static final String HTTP_NOT_FOUND = "Status code 404 returned. The requested resource was not found or is not available.";
    static final String HTTP_INTERNAL_SERVER_ERROR = "Status code 500 returned. An unexpected error occurred inside the server that prevented it from fulfilling the request.";
    static final String HTTP_NOT_IMPLEMENTED = "Status code 501 returned. The server does not support the functionality needed to fulfill the request.";
    static final String HTTP_UNKNOWN_ERROR = "Unknown HTTP status code returned.";
    static final String PATCH_NOT_FOUND = "Patch cannot be found by server.";
    static final String PATCH_NOT_ON_DISK = "Patch could not be found locally.";
    static final String INCORRECT_URL = "Incorrect downloading URL specified.";
    static final String INVALID_DESTINATION_TYPE = "Download destination is not a String object that indicates  the download location.";
    static final String INVALID_FILE_PERMISSION = "The write permission is not set.";
    static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Invalid patch bundle file name.";
    static final String KEYSTORE_LOCATION_NOT_SPECIFIED = "patchpro.security.kslocation is not specified.";
    static final String NOT_ABLE_TO_DETERMINE_SIGNING_CERT_SN = "Cannot determine signing certificate serial number.";
    static final String PATCH_DOWNLOAD_DONE = "Patch download is done.";
    static final String SERVER_NOT_SSL_ENABLED = "This server is not SSL-enabled. ";
    static final String SERVER_SSL_ENABLED = "This server is SSL-enabled. ";
    static final String SERVER_NOT_SPECIFIED = "patchpro.patch.server.url is not specified.";
    static final String SIGNING_CERT_REVOKED = "Signing certificate has been revoked.";
    static final String UNKNOWN_CONTENT_TYPE = "Unknown content-type returned from the server.";
    static final String EMPTY_PATCH_LIST = "Empty Patch List.";
    static /* synthetic */ Class class$com$sun$patchpro$analysis$HostAnalyzer;

    public ServerPatchServiceProvider() throws ServerPatchServiceProviderException {
        this.configure(this.properties);
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.log.println(this, 7, "Loaded the Cascading Server...");
        this.downloadAuthenticate = this.properties.downloadAuthenticationRequired();
        if (this.downloadAuthenticate) {
            try {
                this.validationUtil = SignatureValidationUtil.getValidationUtility(this.properties, this.validationUtil);
                this.keystoreLocation = this.validationUtil.getKeystoreLocation();
                this.signingCertAliasArray = this.validationUtil.getCertificateAliases();
            }
            catch (NoKeystorePresentException noKeystorePresentException) {
                String string = "Failed to create the signature valiation utility. " + noKeystorePresentException.getMessage();
                this.log.printStackTrace(this, 2, noKeystorePresentException);
                this.log.println(this, 3, string);
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_VALIDATION_UTIL));
                throw new ServerPatchServiceProviderException(2);
            }
            catch (NoSigningCertException noSigningCertException) {
                String string = "Failed to create the signature valiation utility. " + noSigningCertException.getMessage();
                this.log.printStackTrace(this, 2, noSigningCertException);
                this.log.println(this, 3, string);
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_VALIDATION_UTIL));
                throw new ServerPatchServiceProviderException(2);
            }
        }
        this.serverURLString = this.properties.getProperty("patchsvr.source.0.url");
        this.log.println(this, 7, "patchsvr.source.0.url: " + this.serverURLString);
        if (this.serverURLString == null) {
            this.serverURLString = this.properties.getProperty("patchpro.patch.server.url");
            this.isPatchServer = false;
        } else {
            this.isPatchServer = true;
            String string = this.properties.getProperty("patchsvr.use.cache", "true");
            if (string.compareTo("false") == 0) {
                this.useCache = false;
            }
        }
        this.log.println(this, 7, "serverURLString: " + this.serverURLString);
        this.log.println(this, 7, "isPatchServer: " + this.isPatchServer);
        if (this.serverURLString == null) {
            this.log.println(this, 2, SERVER_NOT_SPECIFIED);
            throw new ServerPatchServiceProviderException(3);
        }
        this.serverURL = null;
        if (!this.downloadAuthenticate) {
            try {
                this.serverURL = new URL("file:" + File.separator);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
            }
        } else {
            if (this.serverURLString.indexOf("https") == 0) {
                this.log.println(this, 7, "This server is SSL-enabled.  " + this.serverURLString);
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("javax.net.ssl.trustStore", this.keystoreLocation);
            } else if (this.serverURLString.indexOf("http") == 0) {
                this.log.println(this, 7, "This server is not SSL-enabled.  " + this.serverURLString);
            }
            try {
                this.serverURL = new URL(this.serverURLString);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
                throw new ServerPatchServiceProviderException(8);
            }
        }
        if (this.proxyUser != null && this.proxyUser.compareTo("") != 0 && this.proxyPasswd != null && this.proxyPasswd.compareTo("") != 0) {
            this.serverProxyAuthenticator = new ServerProxyAuthenticator(this.proxyUser, this.proxyPasswd);
            Authenticator.setDefault(this.serverProxyAuthenticator);
        }
        this.genPatchInfo = new PatchInfoImpl();
        this.genPatchInfo.setProperties(new PatchProperties(""));
    }

    public String getPatchBundlePrefix() {
        return this.patchBundlePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadPatchListener);
        }
    }

    public void configure(PatchProProperties patchProProperties) {
        this.sunSolveUser = patchProProperties.getProperty("patchpro.sunsolve.identity", "");
        this.sunSolvePasswd = patchProProperties.getProperty("patchpro.sunsolve.passwd", "");
        this.proxyUser = patchProProperties.getProperty("patchpro.proxy.identity", "");
        this.proxyPasswd = patchProProperties.getProperty("patchpro.proxy.passwd", "");
        this.log.println(this, 7, "SunSolve user: " + this.sunSolveUser + "\tpasswd: " + this.sunSolvePasswd);
        this.log.println(this, 7, "Proxy user: " + this.proxyUser + "\tproxyPasswd: " + this.proxyPasswd);
    }

    public void downloadPatchDB(String string, Object object) throws DownloadPatchDBException, NotSupportedException {
        boolean bl = false;
        File file = null;
        String string2 = null;
        string2 = string == null || string.compareTo("") == 0 ? "patchprodb" : string;
        if (object instanceof OutputStream) {
            File file2;
            String string3;
            String string4 = null;
            if (this.isPatchServer) {
                string3 = this.properties.getProperty("patchsvr.cache.location", "/var/tmp") + File.separator + "Misc";
                file2 = new File(string3);
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                string4 = string3 + File.separator + string2 + ".zip";
            } else {
                string3 = this.properties.getProperty("patchpro.cache.file.database");
                file2 = new File(string3);
                string4 = file2.isAbsolute() ? string3 : this.properties.getProperty("patchpro.installdir.ppro") + File.separator + string3;
            }
            this.log.println(this, 7, "cacheFileStr is: " + string4);
            file = new File(string4);
            bl = true;
        } else if (object instanceof String) {
            file = new File((String)object);
        }
        long l = 0L;
        long l2 = 0L;
        if (this.useCache) {
            if (this.isPatchServer) {
                l = new Long(this.properties.getProperty("patchsvr.database.cache.old.age", "2"));
                l2 = new Long(this.properties.getProperty("patchsvr.database.cache.dead.age", "5"));
            } else {
                l = new Long(this.properties.getProperty("patchpro.cache.old.age.days.database"));
                l2 = new Long(this.properties.getProperty("patchpro.cache.dead.age.days.database"));
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("action=downloadPatchDB");
        stringBuffer.append("&name=").append(URLEncoder.encode(string2)).append("&version=2.1");
        this.log.println(this, 7, "POST String: " + stringBuffer);
        boolean bl2 = false;
        String string5 = "";
        String string6 = "";
        CachingDownloader cachingDownloader = null;
        try {
            cachingDownloader = new CachingDownloader(this.serverURL, stringBuffer.toString(), bl2, string5, string6, file, CachingDownloader.days(l), CachingDownloader.days(l2), false);
        }
        catch (IOException iOException) {
            this.log.println(this, 3, "ServerPatchServiceProvider.downloadPatchDB: Unable to create cache downloader.");
            this.log.printStackTrace(this, 3, iOException);
            throw new DownloadPatchDBException("Unable to download to " + file.getPath() + ".", iOException);
        }
        try {
            cachingDownloader.getValidCache();
        }
        catch (IOException iOException) {
            this.log.println(this, 3, "ServerPatchServiceProvider.downloadPatchDB: Unable to download to " + file.getPath() + ".");
            this.log.printStackTrace(this, 3, iOException);
            throw new DownloadPatchDBException("Unable to download to " + file.getPath() + ".", iOException);
        }
        if (bl) {
            int n = 102400;
            byte[] byArray = new byte[n];
            int n2 = 0;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    ((OutputStream)object).write(byArray, 0, n2);
                }
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void downloadRealizationDetectors(String string, Object object) throws DownloadRealizationException, NotSupportedException {
        Object object2;
        CharSequence charSequence;
        Object object3;
        Object object4;
        boolean bl = false;
        File file = null;
        String string2 = null;
        string2 = string == null || string.compareTo("") == 0 ? "pprodetectors" : string;
        if (object instanceof OutputStream) {
            Object object5 = null;
            if (this.isPatchServer) {
                object4 = this.properties.getProperty("patchsvr.cache.location", "/tmp") + File.separator + "Misc";
                object3 = new File((String)object4);
                if (!((File)object3).exists()) {
                    ((File)object3).mkdirs();
                }
                object5 = (String)object4 + File.separator + string2 + ".jar";
            } else {
                object4 = this.properties.getProperty("patchpro.cache.file.detectors");
                object3 = new File((String)object4);
                object5 = ((File)object3).isAbsolute() ? object4 : this.properties.getProperty("patchpro.installdir.ppro") + File.separator + (String)object4;
            }
            this.log.println(this, 7, "cacheFileStr is: " + (String)object5);
            file = new File((String)object5);
            bl = true;
        } else if (object instanceof String) {
            file = new File((String)object);
        }
        boolean bl2 = false;
        if (file.exists()) {
            try {
                object4 = null;
                object3 = null;
                DetectorClassLoader detectorClassLoader = null;
                RealizationDetector realizationDetector = null;
                charSequence = null;
                String string3 = null;
                object3 = (class$com$sun$patchpro$analysis$HostAnalyzer == null ? (class$com$sun$patchpro$analysis$HostAnalyzer = ServerPatchServiceProvider.class$("com.sun.patchpro.analysis.HostAnalyzer")) : class$com$sun$patchpro$analysis$HostAnalyzer).getClassLoader();
                detectorClassLoader = object3 != null ? new DetectorClassLoader(file, (ClassLoader)object3) : new DetectorClassLoader(file);
                object2 = new InputStreamReader(detectorClassLoader.getResourceAsStream("/com/sun/patchpro/detectors/detector.list"));
                object4 = new BufferedReader((Reader)object2);
                string3 = ((BufferedReader)object4).readLine().trim();
                while ((charSequence = ((BufferedReader)object4).readLine()) != null) {
                    realizationDetector = (RealizationDetector)detectorClassLoader.loadClass((String)charSequence).newInstance();
                }
                object4 = null;
                object3 = null;
                detectorClassLoader = null;
                realizationDetector = null;
                charSequence = null;
                string3 = null;
            }
            catch (Exception exception) {
                this.log.println(this, 7, "Cache file " + file.getPath() + " is corrupt. " + "The Cache file will be refreshed.");
                bl2 = true;
            }
        }
        long l = 0L;
        long l2 = 0L;
        if (this.useCache) {
            if (this.isPatchServer) {
                l = new Long(this.properties.getProperty("patchsvr.detectors.cache.old.age", "2"));
                l2 = new Long(this.properties.getProperty("patchsvr.detectors.cache.dead.age", "5"));
            } else {
                l = new Long(this.properties.getProperty("patchpro.cache.old.age.days.detectors", "2"));
                l2 = new Long(this.properties.getProperty("patchpro.cache.dead.age.days.detectors", "5"));
            }
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("action=downloadRealizationDetectors");
        ((StringBuffer)charSequence).append("&name=").append(URLEncoder.encode(string2)).append("&version=2.1");
        this.log.println(this, 7, "POST String: " + charSequence);
        boolean bl3 = false;
        object2 = "";
        String string4 = "";
        CachingDownloader cachingDownloader = null;
        try {
            cachingDownloader = new CachingDownloader(this.serverURL, ((StringBuffer)charSequence).toString(), bl3, (String)object2, string4, file, CachingDownloader.days(l), CachingDownloader.days(l2), bl2);
        }
        catch (IOException iOException) {
            this.log.println(this, 3, "ServerPatchServiceProvider.downloadRealizationDetectors: Unable to create cache downloader.");
            this.log.printStackTrace(this, 3, iOException);
            throw new DownloadRealizationException("Unable to download to " + file.getPath() + ".", iOException);
        }
        try {
            cachingDownloader.getValidCache();
        }
        catch (IOException iOException) {
            this.log.println(this, 3, "ServerPatchServiceProvider.downloadRealizationDetectors: Unable to download to " + file.getPath() + ".");
            throw new DownloadRealizationException(iOException);
        }
        if (bl) {
            int n = 102400;
            byte[] byArray = new byte[n];
            int n2 = 0;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    ((OutputStream)object).write(byArray, 0, n2);
                }
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList patchList) {
        String string = null;
        string = this.isPatchServer ? this.properties.getProperty("patchsvr.cache.location") + File.separator + "Patches" : this.properties.getProperty("patchpro.patch.download.directory");
        if (this.useCache) {
            try {
                this.downloadPatches(patchList, string);
            }
            catch (DownloadPatchException downloadPatchException) {
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        long l = 0L;
        PatchBundleInfo[] patchBundleInfoArray = new PatchBundleInfo[patchList.size()];
        Vector<PatchBundleInfo> vector = new Vector<PatchBundleInfo>(patchList.size());
        for (int i = 0; i < patchList.size(); ++i) {
            Patch patch;
            try {
                patch = patchList.getPatchAt(i);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
                continue;
            }
            String string2 = patch.getPatchID().getPatchID();
            l = this.patchExists(string, string2);
            if (l > 0L) {
                vector.addElement(new PatchBundleInfo(string2, string2 + ".jar", l));
                continue;
            }
            vector.addElement(new PatchBundleInfo(string2, string2 + ".jar", -1L));
        }
        Object[] objectArray = vector.toArray();
        PatchBundleInfo[] patchBundleInfoArray2 = new PatchBundleInfo[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            patchBundleInfoArray2[i] = (PatchBundleInfo)objectArray[i];
        }
        return patchBundleInfoArray2;
    }

    public Object getDownloadDestination() {
        return this.getPatchBundlePrefix();
    }

    public boolean isCertificateRevoked(String string) throws NotSupportedException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=isCertificateRevoked");
        stringBuffer2.append("&serialNumber=").append(URLEncoder.encode(string));
        this.log.println(this, 7, "CRL checking post string: " + stringBuffer2);
        URLConnection uRLConnection = null;
        try {
            Object object;
            uRLConnection = this.serverURL.openConnection();
            if (uRLConnection instanceof HttpsURLConnection) {
                object = System.getProperty("https.proxyHost");
                string2 = System.getProperty("https.proxyPort");
                if (object != null && string2 != null && ((String)object).length() > 0 && string2.length() > 0) {
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory((String)object, string2));
                }
            }
            uRLConnection.setDoOutput(true);
            object = new PrintWriter(uRLConnection.getOutputStream());
            ((PrintWriter)object).print(stringBuffer2);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 4, iOException);
            return false;
        }
        int n = -1;
        try {
            n = ((HttpURLConnection)uRLConnection).getResponseCode();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
        if (n != 200) {
            string2 = this.httpResponseCode2Str(n);
            this.log.println(this, 2, string2);
            return true;
        }
        int n2 = uRLConnection.getHeaderFieldInt("patchproServiceCompletionCode", 200);
        return n2 == 200;
    }

    public void downloadPatches(PatchList patchList, Object object) throws DownloadPatchException, NotSupportedException {
        this.updateSessionData = false;
        this.downloadPatches(patchList, object, null);
    }

    public void downloadPatches(PatchList patchList, Object object, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        String string;
        int n;
        if (patchList == null || patchList.size() <= 0) {
            this.dispatchDoneEvent(PatchProLog.createMessage(5, EMPTY_PATCH_LIST));
            this.log.println(this, 3, EMPTY_PATCH_LIST);
            return;
        }
        this.properties = sessionData != null ? sessionData.getProperties() : PatchProProperties.getInstance();
        boolean bl = false;
        if (this.connectingServer()) {
            this.log.println(this, 7, "Network connected.");
            for (n = 0; n < this.signingCertAliasArray.length; ++n) {
                this.signingCertAlias = this.signingCertAliasArray[n];
                string = this.getCertSerialNumber(this.keystoreLocation, this.signingCertAlias);
                if (string == null) {
                    throw new DownloadPatchException(5);
                }
                try {
                    if (!this.isCertificateRevoked(string)) continue;
                    this.log.println(this, 2, "Signing certificate has been revoked.: " + string);
                    throw new DownloadPatchException(6);
                }
                catch (NotSupportedException notSupportedException) {
                    this.log.printStackTrace(this, 2, notSupportedException);
                    throw notSupportedException;
                }
            }
            bl = true;
        } else {
            this.log.println(this, 7, "Network not connected.");
            System.out.println("... " + this.msgcat.getMessage("using_local_data", "Trying to use local data to service request.") + "\n");
        }
        n = 0;
        string = null;
        if (object instanceof OutputStream) {
            this.log.println(this, 7, "Detected output stream...");
            string = this.isPatchServer ? this.properties.getProperty("patchsvr.cache.location", "/var/tmp") + File.separator + "Patches" : this.properties.getProperty("patchpro.patch.download.directory", "/var/tmp");
            n = 1;
            this.log.println(this, 7, "What is downloadDir: " + string);
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, INVALID_DESTINATION_TYPE));
            this.log.println(this, 2, INVALID_DESTINATION_TYPE);
            if (this.updateSessionData) {
                InvalidPatchDownloadDirectoryException invalidPatchDownloadDirectoryException = new InvalidPatchDownloadDirectoryException("InvalidPatchDownloadDirectoryException", "InvalidPatchDownloadDirectoryException.MESSAGE", "InvalidPatchDownloadDirectoryException.REMEDY", 2);
                sessionData.addPatchProException(invalidPatchDownloadDirectoryException);
            }
            throw new DownloadPatchException(INVALID_DESTINATION_TYPE);
        }
        if (string.indexOf("%") != -1) {
            this.setPatchBundlePrefix(PatchServiceUtil.generateTimeStampedString(string) + File.separator);
            this.log.println(this, 7, "setPatchBundlePrefix ts");
        } else {
            this.setPatchBundlePrefix(string + File.separator);
            this.log.println(this, 7, "setPatchBundlePrefix" + string + File.separator);
        }
        if (bl) {
            this.log.println(this, 7, "Invoking performDownloadPatches.");
            this.performDownloadPatches(patchList, sessionData);
        } else {
            this.log.println(this, 7, "Invoking performValidationOnDownloadedPatches.");
            this.performValidationOnDownloadedPatches(patchList, sessionData);
        }
        if (n != 0) {
            int n2 = 102400;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            FileInputStream fileInputStream = null;
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < patchList.size(); ++i) {
                try {
                    Patch patch = patchList.getPatchAt(i);
                    string2 = patch.getPatchID().getPatchID();
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 2, "Should never receive NoSuchPatchException here.");
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    continue;
                }
                string3 = string + File.separator + string2 + ".jar";
                this.log.println(this, 7, "Requested patch file name: " + string3);
                try {
                    fileInputStream = new FileInputStream(string3);
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        ((OutputStream)object).write(byArray, 0, n3);
                    }
                    fileInputStream.close();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void setPatchBundlePrefix(String string) {
        this.patchBundlePrefix = string;
    }

    private String httpResponseCode2Str(int n) {
        String string = "";
        switch (n) {
            case 206: {
                string = HTTP_PARTIAL_CONTENT;
                break;
            }
            case 400: {
                string = HTTP_BAD_REQUEST;
                break;
            }
            case 401: {
                string = HTTP_UNAUTHORIZED;
                break;
            }
            case 403: {
                string = HTTP_FORBIDDEN;
                break;
            }
            case 404: {
                string = HTTP_NOT_FOUND;
                break;
            }
            case 500: {
                string = HTTP_INTERNAL_SERVER_ERROR;
                break;
            }
            case 501: {
                string = HTTP_NOT_IMPLEMENTED;
                break;
            }
            default: {
                string = HTTP_UNKNOWN_ERROR;
            }
        }
        return string;
    }

    private void performDownloadPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        int n;
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canWrite()) {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, DOWNLOAD_DIR_NOT_WRITABLE));
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_WRITABLE);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_WRITABLE);
        }
        int n2 = patchList.size();
        Vector<PatchListImpl> vector = new Vector<PatchListImpl>();
        PatchListImpl patchListImpl = new PatchListImpl();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            try {
                IPatch iPatch = new IPatch(patchList.getPatchAt(n));
                if (new File(file, iPatch.getPatchID().getPatchID() + ".jar").exists()) {
                    if (this.updateSessionData) {
                        sessionData.addPatchAlreadyPresent(iPatch);
                    }
                } else if (this.useCache) {
                    patchListImpl.addIPatch(iPatch);
                    patchListImpl.setSelectionStatus(n3, patchList.getSelectionStatus(n));
                    ++n3;
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 3, noSuchPatchException);
            }
            if ((n + 1) % 10 != 0 || patchListImpl.size() == 0) continue;
            vector.addElement(patchListImpl);
            patchListImpl = new PatchListImpl();
            n3 = 0;
        }
        if (n2 % 10 != 0 && patchListImpl.size() != 0) {
            vector.addElement(patchListImpl);
        }
        for (n = 0; n < vector.size(); ++n) {
            try {
                if (this.proxyUser != null && this.proxyUser.compareTo("") != 0 && this.proxyPasswd != null && this.proxyPasswd.compareTo("") != 0) {
                    this.serverProxyAuthenticator.resetRetryAttempts();
                }
                this.requestDownload((PatchList)vector.elementAt(n), sessionData);
                continue;
            }
            catch (DownloadPatchException downloadPatchException) {
                this.log.printStackTrace(this, 4, downloadPatchException);
            }
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, this.getPatchBundlePrefix());
        }
    }

    private void performValidationOnDownloadedPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        this.smpatch = this.properties.getProperty("smpatch.request", "false").equals("true");
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_EXIST);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_EXIST);
        }
        int n = patchList.size();
        boolean bl = false;
        String string = "";
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            IPatch iPatch;
            Patch patch;
            try {
                Patch patch2 = patchList.getPatchAt(i);
                string = patch2.getPatchID().getPatchID();
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 3, noSuchPatchException);
                continue;
            }
            string2 = this.getPatchBundlePrefix() + File.separator + string + ".jar";
            if (!new File(string2).exists()) {
                try {
                    patch = patchList.getPatchByPatchID(new PatchID(string));
                    iPatch = new IPatch(patch);
                    iPatch.setError(PATCH_NOT_ON_DISK);
                    if (this.updateSessionData) {
                        sessionData.addPatchUnavailable(iPatch);
                    }
                    this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the problem list. ErrString: " + PATCH_NOT_ON_DISK);
                    if (!this.updateSessionData) continue;
                    serializable = this.smpatch ? new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.SMPATCH_MESSAGE", "PatchNotAvailableException.SMPATCH_REMEDY", 3) : new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                    sessionData.addPatchProException((PatchProException)serializable);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                    this.log.printStackTrace(this, 3, noSuchPatchException);
                }
                catch (MalformedPatchException malformedPatchException) {
                    this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                    this.log.printStackTrace(this, 3, malformedPatchException);
                }
                continue;
            }
            bl = false;
            if (this.downloadAuthenticate) {
                bl = this.validatePatchBundle(string2);
                this.log.println(this, 7, "Validation of local patch " + string2 + " is done");
            }
            if (bl) {
                if (this.updateSessionData) {
                    try {
                        serializable = new PatchID(string);
                        PatchImpl patchImpl = new PatchImpl(this.genPatchInfo, (PatchID)serializable);
                        sessionData.addPatchAlreadyPresent(patchImpl);
                    }
                    catch (Exception exception) {
                        this.log.printStackTrace(this, 3, exception);
                    }
                }
                this.log.println(this, 7, "The patch " + string2 + " has been validated");
                continue;
            }
            try {
                patch = patchList.getPatchByPatchID(new PatchID(string));
                iPatch = new IPatch(patch);
                iPatch.setError(FAILED_TO_VALIDATE_SIGNATURE);
                if (this.updateSessionData) {
                    sessionData.addPatchCorruptOnDownload(iPatch);
                }
                this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                if (!this.updateSessionData) continue;
                serializable = this.smpatch ? new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.SMPATCH_MESSAGE", "PatchSignatureValidationException.SMPATCH_REMEDY", 2) : new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                sessionData.addPatchProException((PatchProException)serializable);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                this.log.printStackTrace(this, 3, noSuchPatchException);
                continue;
            }
            catch (MalformedPatchException malformedPatchException) {
                this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                this.log.printStackTrace(this, 3, malformedPatchException);
            }
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestDownload(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        Object object;
        Serializable serializable;
        int n;
        String string;
        String string2;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=patchDownload&version=2.1");
        Patch patch = null;
        int n3 = patchList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                if (!patchList.getSelectionStatus(n2)) continue;
                patch = patchList.getPatchAt(n2);
                String string3 = patch.getPatchID().getPatchID();
                this.log.println(this, 7, "Adding " + string3 + " to the POST list...");
                stringBuffer.append(string3).append(" ");
                stringBuffer2.append('&');
                stringBuffer2.append("patchId=").append(URLEncoder.encode(string3));
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
        }
        this.log.println(this, 7, "Post String: " + stringBuffer2);
        n2 = -1;
        Downloader downloader = null;
        try {
            downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), this.sunSolveUser, this.sunSolvePasswd, sessionData);
            n2 = downloader.getResponseCode();
        }
        catch (DownloadPatchException downloadPatchException) {
            if (downloadPatchException.getReasonCode() == 4) {
                n2 = 500;
            }
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw downloadPatchException;
        }
        if (n2 == 401) {
            this.dispatchFailedEvent(PatchProLog.createMessage(4, this.msgcat.getMessage(AUTHENTICATION_FAILED, "The patch server failed to authenticate the request based on the current SunSolve user/password setting. Only public (non-contract) patches will be downloaded.")));
            this.log.println(this, 4, "Current SunSolve credential setting caused 401 response.");
            n2 = -1;
            try {
                downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), "", "", sessionData);
                n2 = downloader.getResponseCode();
            }
            catch (DownloadPatchException downloadPatchException) {
                if (downloadPatchException.getReasonCode() == 4) {
                    n2 = 500;
                }
                if (this.updateSessionData) {
                    sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
                }
                throw downloadPatchException;
            }
        }
        this.log.println(this, 7, "HTTP response code: " + n2);
        if (n2 != 200 && n2 != 206) {
            string2 = this.httpResponseCode2Str(n2);
            this.log.println(this, 4, string2);
            if (this.updateSessionData) {
                BadHttpResponseException badHttpResponseException = new BadHttpResponseException("BadHttpResponseException", BadHttpResponseException.getBadHttpResponseExceptionMessage(n2), BadHttpResponseException.getBadHttpResponseExceptionRemedy(n2), 2);
                sessionData.addPatchProException(badHttpResponseException);
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw new DownloadPatchException(string2);
        }
        string2 = downloader.getHeaderField("patchFiles");
        String string4 = downloader.getHeaderField("rejects");
        String string5 = downloader.getHeaderField("requiredSize");
        this.log.println(this, 7, "Patches returned: " + string2);
        this.log.println(this, 7, "Patches rejected: " + string4);
        this.log.println(this, 7, "Patches required sizes: " + string5);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(downloader);
        if (string2 == null) {
            this.log.println(this, 4, "patchFiles is null.");
            string2 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n4 = stringTokenizer.countTokens();
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        String[] stringArray3 = new String[n4];
        int[] nArray = new int[n4];
        String string6 = null;
        StringTokenizer stringTokenizer2 = null;
        int n5 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string6, "&");
            string = stringTokenizer2.nextToken();
            stringArray[n5] = string.substring(0, string.indexOf(".jar"));
            stringArray2[n5] = this.patchBundlePrefix + string;
            stringArray3[n5] = string;
            nArray[n5] = Integer.parseInt(stringTokenizer2.nextToken());
            ++n5;
        }
        stringTokenizer2 = null;
        stringTokenizer = null;
        string = null;
        string6 = null;
        this.log.println(this, 7, "Number of patches returned: " + n4);
        for (n5 = 0; n5 < n4; ++n5) {
            this.log.println(this, 7, "PatchID: " + stringArray2[n5] + "\tSize: " + nArray[n5]);
            this.log.println(this, 7, "The patch returned by server is PatchID: " + stringArray2[n5] + "\tSize: " + nArray[n5]);
        }
        if (n4 == 0) {
            Patch patch2 = null;
            IPatch iPatch = null;
            for (int i = 0; i < n3; ++i) {
                try {
                    patch2 = patchList.getPatchAt(i);
                    iPatch = new IPatch(patch2);
                    iPatch.setError(PATCH_NOT_FOUND);
                    if (!this.updateSessionData) continue;
                    sessionData.addPatchUnavailable(iPatch);
                    continue;
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                }
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            return;
        }
        Patch patch3 = null;
        block38: for (n = 0; n < n3; ++n) {
            try {
                patch3 = patchList.getPatchAt(n);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
                continue;
            }
            String string7 = patch3.getPatchID().getPatchID();
            String string8 = string7 + ".jar";
            for (int i = 0; i < n4; ++i) {
                if (string8.equals(stringArray3[i])) {
                    if (!this.updateSessionData) continue block38;
                    try {
                        sessionData.addPatchDownloaded(string7);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 3, "Malformed patch string " + string7);
                    }
                    continue block38;
                }
                if (i + 1 != n4) continue;
                serializable = null;
                try {
                    serializable = patchList.getPatchByPatchID(new PatchID(string7));
                    IPatch iPatch = new IPatch((Patch)serializable);
                    iPatch.setError(PATCH_NOT_FOUND);
                    if (this.updateSessionData) {
                        sessionData.addPatchUnavailable(iPatch);
                        object = new PatchNotFoundException("PatchNotFoundException", "PatchNotFoundException.MESSAGE", "PatchNotFoundException.REMEDY", 2);
                        sessionData.addPatchProException((PatchProException)object);
                    }
                    this.log.println(this, 3, PATCH_NOT_FOUND);
                    continue;
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 3, "There exists no patch in the patch listto be downloaded.");
                    this.log.println(this, 3, noSuchPatchException.getMessage());
                    this.log.printStackTrace(this, 3, noSuchPatchException);
                    continue;
                }
                catch (MalformedPatchException malformedPatchException) {
                    this.log.println(this, 4, "ServerPatchServiceProvider.requestDownload(): Malformed patch ID on appliedPatch. " + malformedPatchException.getMessage());
                    this.log.printStackTrace(this, 4, malformedPatchException);
                }
            }
        }
        if (downloader.getContentType().compareTo("application/octet-stream") == 0) {
            n = 0;
            int n6 = 0;
            int n7 = downloader.getBufferLength();
            if (n7 <= 0) {
                n7 = 8192;
            }
            byte[] byArray = new byte[n7];
            serializable = new File(this.patchBundlePrefix);
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            }
            serializable = null;
            this.smpatch = this.properties.getProperty("smpatch.request", "false").equals("true");
            for (int i = 0; i < n4; ++i) {
                object = stringArray2[i] + ".tmp";
                this.log.println(this, 7, (String)object);
                serializable = new File((String)object);
                try {
                    Serializable serializable2;
                    ((File)serializable).delete();
                    ((File)serializable).createNewFile();
                    this.log.println(this, 7, "Created " + (String)object);
                    FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
                    n6 = 0;
                    n = 0;
                    int n8 = nArray[i] - n6;
                    while (n8 >= n7 && (n = bufferedInputStream.read(byArray, 0, n7)) != -1) {
                        n8 = nArray[i] - (n6 += n);
                        fileOutputStream.write(byArray, 0, n);
                    }
                    if (n8 > 0) {
                        n = bufferedInputStream.read(byArray, 0, n8);
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                    boolean bl = true;
                    if (this.downloadAuthenticate) {
                        bl = this.validatePatchBundle((String)object);
                        this.log.println(this, 7, "The downloader validation is done");
                    }
                    Patch patch4 = null;
                    if (bl) {
                        this.log.println(this, 7, "The patch bundle is validated");
                        serializable2 = new File(stringArray2[i]);
                        ((File)serializable2).delete();
                        ((File)serializable).renameTo((File)serializable2);
                    } else {
                        try {
                            patch4 = patchList.getPatchByPatchID(new PatchID(stringArray[i]));
                            serializable2 = new IPatch(patch4);
                            ((IPatch)serializable2).setError(FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                sessionData.addPatchCorruptOnDownload((IPatch)serializable2);
                            }
                            this.log.println(this, 7, "Added patch " + patch4.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                            File file = new File(stringArray2[i]);
                            file.delete();
                            file = null;
                            this.log.println(this, 3, FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                PatchSignatureValidationException patchSignatureValidationException = this.smpatch ? new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.SMPATCH_MESSAGE", "PatchSignatureValidationException.SMPATCH_REMEDY", 2) : new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                                sessionData.addPatchProException(patchSignatureValidationException);
                            }
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                            this.log.printStackTrace(this, 3, noSuchPatchException);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 3, malformedPatchException);
                        }
                    }
                    if (!downloader.isCancelEnabled()) {
                        this.log.println(this, 6, "Downloading done.");
                        continue;
                    }
                    this.log.println(this, 6, "Downloading canceled.");
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string9 = "Invalid patch bundle file name.: " + (String)object;
                    this.log.printStackTrace(this, 3, fileNotFoundException);
                    this.log.println(this, 3, string9);
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_PATCH_BUNDLE_FILE_NAME));
                    continue;
                }
                catch (SecurityException securityException) {
                    String string10 = "The write permission is not set.: " + (String)object;
                    this.log.printStackTrace(this, 3, securityException);
                    this.log.println(this, 3, string10);
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_FILE_PERMISSION));
                    securityException.printStackTrace();
                    continue;
                }
                catch (IOException iOException) {
                    this.log.printStackTrace(this, 3, iOException);
                    if (this.updateSessionData) {
                        PatchDownloadIOException patchDownloadIOException = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                        sessionData.addPatchProException(patchDownloadIOException);
                    }
                    throw new DownloadPatchException("I/O error: " + iOException.getMessage());
                }
                catch (Exception exception) {
                    this.log.printStackTrace(this, 3, exception);
                    if (this.updateSessionData) {
                        PatchDownloadIOException patchDownloadIOException = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                        sessionData.addPatchProException(patchDownloadIOException);
                    }
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, "PatchDownloadIOException.MESSAGE\nPatchDownloadIOException.REMEDY"));
                    continue;
                }
                finally {
                    ((File)serializable).delete();
                }
            }
        } else {
            this.log.println(this, 4, UNKNOWN_CONTENT_TYPE);
            this.dispatchFailedEvent(PatchProLog.createMessage(4, UNKNOWN_CONTENT_TYPE));
            if (this.updateSessionData) {
                PatchDownloadResponseException patchDownloadResponseException = new PatchDownloadResponseException("PatchDownloadResponseException", "PatchDownloadResponseException.MESSAGE", "PatchDownloadResponseException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadResponseException);
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
    }

    private void createDownloadSummaryFile(SessionData sessionData, PatchList patchList, String string) {
        boolean bl = false;
        File file = null;
        File file2 = null;
        try {
            PatchList patchList2;
            PatchList patchList3;
            PatchList patchList4;
            PatchList patchList5;
            try {
                patchList5 = sessionData.getPatchesDownloaded();
            }
            catch (NoResultException noResultException) {
                patchList5 = new PatchListImpl();
            }
            try {
                patchList4 = sessionData.getPatchesAlreadyPresent();
            }
            catch (NoResultException noResultException) {
                patchList4 = new PatchListImpl();
            }
            try {
                patchList3 = sessionData.getPatchesUnavailable();
            }
            catch (NoResultException noResultException) {
                patchList3 = new PatchListImpl();
            }
            try {
                patchList2 = sessionData.getPatchesCorruptOnDownload();
            }
            catch (NoResultException noResultException) {
                patchList2 = new PatchListImpl();
            }
            int n = patchList5.size() + patchList4.size();
            int n2 = patchList3.size() + patchList2.size();
            file2 = new File(string);
            String string2 = !file2.canWrite() ? "/var/tmp/" : string;
            file = new File(string2 + File.separator + PatchServiceUtil.generateTimeStampedString("patchpro_dnld_'%Y.%m.%d@%T:%Z'") + "." + "txt");
            this.log.println(this, 7, "Dnld summary file: " + file.getPath());
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            PatchListImpl patchListImpl = new PatchListImpl();
            if (n2 == 0) {
                printStream.println(this.msgcat.getMessage("readmeHeader", "This patch bundle was generated by PatchPro.\n\nPlease refer to the README file for each patch for installation\ninstructions.  To properly patch your system, the following patches\nshould be installed in the listed order:\n\n"));
                this.printDownloadedPatches(printStream, patchList);
            } else {
                printStream.println(this.msgcat.getMessage("readmeFailedHeader", "This collection of patches is incomplete due to problems in downloading.\nIt is advisable to retry the download later and see if the\nremaining patches can be downloaded. If they can, then the new download\nsummary file will show the patches required and the order in which to\ninstall them. The patches failing to install are listed here:\n\n"));
                try {
                    patchListImpl.merge(sessionData.getPatchesUnavailable());
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
                try {
                    patchListImpl.merge(sessionData.getPatchesCorruptOnDownload());
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
                this.printProblemPatches(printStream, patchListImpl);
            }
            fileOutputStream.close();
            printStream.close();
        }
        catch (Exception exception) {
            System.out.println("Problems creating download summary file. " + exception.getMessage());
            this.log.println(this, 7, "Unable to create the download summary file. " + exception.getMessage());
            this.log.printStackTrace(this, 4, exception);
            exception.printStackTrace();
        }
    }

    private boolean validatePatchBundle(String string) {
        boolean bl = true;
        this.log.println(this, 7, "Entered downloader validatePatchBundle()");
        if (this.validationUtil == null) {
            String string2 = FAILED_TO_CREATE_VALIDATION_UTIL;
            this.log.println(this, 3, string2);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_CREATE_VALIDATION_UTIL));
            return false;
        }
        try {
            this.validationUtil.validateJarFile(string);
        }
        catch (ManifestFileNotFoundException manifestFileNotFoundException) {
            bl = false;
            String string3 = "Failed to validate the digital signature(s). for: " + string + ": " + manifestFileNotFoundException.getMessage();
            this.log.printStackTrace(this, 3, manifestFileNotFoundException);
            this.log.println(this, 3, string3);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureCheckFailedException signatureCheckFailedException) {
            bl = false;
            String string4 = "Failed to validate the digital signature(s). for: " + string + ": " + signatureCheckFailedException.getMessage();
            this.log.printStackTrace(this, 3, signatureCheckFailedException);
            this.log.println(this, 3, string4);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (NotSignedByKnownCertificateException notSignedByKnownCertificateException) {
            bl = false;
            String string5 = "Failed to validate the digital signature(s). for: " + string + ": " + notSignedByKnownCertificateException.getMessage();
            this.log.printStackTrace(this, 3, notSignedByKnownCertificateException);
            this.log.println(this, 3, string5);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureValidationException signatureValidationException) {
            bl = false;
            String string6 = "Failed to validate the digital signature(s). for: " + string + ": " + signatureValidationException.getMessage();
            this.log.printStackTrace(this, 3, signatureValidationException);
            this.log.println(this, 3, string6);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        System.out.println("");
        if (bl) {
            System.out.println(string + " has been validated.");
        } else {
            System.out.println(string + " cannot be validated.");
            System.out.print("\n\n");
        }
        return bl;
    }

    private void printDownloadedPatches(PrintStream printStream, PatchList patchList) {
        int n = 0;
        int n2 = patchList.size();
        for (int i = 0; i < n2; ++i) {
            try {
                if (!patchList.getSelectionStatus(i)) continue;
                Patch patch = patchList.getPatchAt(i);
                String string = patch.getPatchID().getPatchID();
                this.log.println(this, 7, "Checking if " + string + " is available...");
                PatchProperties patchProperties = patch.getPatchInfo().getProperties();
                ++n;
                if (patchProperties.isNonstandard() || patchProperties.isInteractive()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("seeReadmeWarning", "!!! SEE README !!!"));
                    continue;
                }
                if (patchProperties.isRebootimmediate() || patchProperties.isReconfigimmediate()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("immediateRebootWarning", "!!! IMMEDIATE REBOOT !!!"));
                    continue;
                }
                if (patchProperties.isRebootafter() || patchProperties.isReconfigafter()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("rebootWarning", "!!! REBOOT !!!"));
                    continue;
                }
                if (patchProperties.isSingleuser()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("singleUserWarning", "!!! SINGLE USER !!!"));
                    continue;
                }
                printStream.println(n + ") " + string);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
        }
    }

    private void printProblemPatches(PrintStream printStream, PatchList patchList) {
        int n = patchList.size();
        String string = "";
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            IPatch iPatch;
            try {
                iPatch = patchList.getIPatchAt(i);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
                continue;
            }
            string = iPatch.getPatchID().getPatchID();
            string2 = iPatch.hasError() ? iPatch.getError() : "";
            this.log.println(this, 7, "Listing " + string + " w/ " + string2);
            printStream.println(string + " " + string2);
        }
    }

    private String getCertSerialNumber(String string, String string2) {
        String string3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            keyStore.load(fileInputStream, null);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            PublicKey publicKey = x509Certificate.getPublicKey();
            string3 = String.valueOf(x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        return string3;
    }

    private boolean connectingServer() {
        URLConnection uRLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object[] objectArray = new String[]{this.serverURL.toString()};
        try {
            Object object;
            uRLConnection = this.serverURL.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            if (uRLConnection instanceof HttpsURLConnection) {
                object = System.getProperty("https.proxyHost");
                String string = System.getProperty("https.proxyPort");
                if (object != null && string != null && ((String)object).length() > 0 && string.length() > 0) {
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory((String)object, string));
                }
            }
            uRLConnection.setDoOutput(true);
            object = new PrintWriter(uRLConnection.getOutputStream());
            ((PrintWriter)object).print("");
            ((PrintWriter)object).flush();
            if (((PrintWriter)object).checkError()) {
                this.log.println(this, 4, "PrinterWriter error!");
            }
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            System.out.println(this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server."));
            this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server.")));
            return false;
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            System.out.println(this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server."));
            return false;
        }
        return true;
    }

    private Downloader sendPatchDownloadPostRequest(URL uRL, String string, String string2, String string3, SessionData sessionData) throws DownloadPatchException {
        Downloader downloader;
        block5: {
            downloader = null;
            boolean bl = false;
            if (string2 != null && string2.compareTo("") != 0 && string3 != null && string3.compareTo("") != 0) {
                bl = true;
            }
            String string4 = "";
            String string5 = "";
            if (bl) {
                string4 = string2;
                string5 = string3;
            }
            this.log.println(this, 7, "Password authentication: " + bl);
            try {
                downloader = new Downloader(uRL, string, bl, string4, string5);
                downloader.connectToURL();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.println(this, 2, "It's possible that " + this.serverURLString + " does not have \"/\" at the end.");
                this.log.println(this, 2, "Returning HTTP response code is > 400. Assume 500.");
                this.log.printStackTrace(this, 2, fileNotFoundException);
                throw new DownloadPatchException(4);
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
                if (downloader != null) break block5;
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_DOWNLOADER));
                ServerConnectionException serverConnectionException = new ServerConnectionException("ServerConnectionException", "ServerConnectionException.MESSAGE", "ServerConnectionException.REMEDY", 2);
                sessionData.addPatchProException(serverConnectionException);
                throw new DownloadPatchException(FAILED_TO_CREATE_DOWNLOADER);
            }
        }
        return downloader;
    }

    private long patchExists(String string, String string2) {
        String string3 = string + File.separator + string2 + ".jar";
        File file = new File(string3);
        return file.length();
    }

    private void dispatchProgressEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchProgress(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchDoneEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchDone(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchFailedEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchFailed(new DownloadPatchEvent(this, string));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

