/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.patch.SecurePatchListImpl;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.server.PatchServerServletProperties;
import com.sun.patchpro.server.ServletLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PatchProServerServlet
extends HttpServlet
implements SingleThreadModel {
    protected static final String VERSION_2_0 = "2.0";
    protected static final String VERSION_2_1 = "2.1";
    public static final String DEFAULT_REQUESTED_DB_NAME = "patchprodb";
    public static final String DEFAULT_REQUESTED_DETECTORS_NAME = "pprodetectors";
    protected String protocolVersion = "";
    protected PatchProLog log;
    protected PatchServerServletProperties properties;
    protected PatchServerProxy patchServerProxy;
    public static final int SUCCESS = 0;
    public static final int DUPLICATE_PARAMETER = 4;
    public static final int INVALID_PARAMETER = 8;
    public static final int INVALID_REQUEST = 16;
    public static final int MISSING_PARAMETER = 32;
    public static final int MISSING_VALUE = 36;
    public static final int IO_EXCEPTION = 48;
    public static final int EXCEPTION = 64;
    public static final int MALFORMED_PATCH_EXCEPTION = 100;
    public static final int DOWNLOADPATCH_EXCEPTION = 110;
    public static final int NOT_SUPPORTED_EXCEPTION = 120;
    public static final int PATCHBUNDLE_INFO_UNAVAILABLE = 130;
    public static final int EXPIRED_CERTIFICATE = 200;
    public static final int GOOD_CERTIFICATE = 201;
    public static final int DOWNLOADPATCHDB_EXCEPTION = 300;
    public static final int DOWNLOAD_REALIZATION_EXCEPTION = 400;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        block61: {
            try {
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 0);
                httpServletResponse.setStatus(200);
                String[] stringArray = httpServletRequest.getParameterValues("version");
                if (stringArray == null || stringArray.length == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray[0].compareTo(VERSION_2_0) == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray[0].compareTo(VERSION_2_1) == 0) {
                    this.protocolVersion = VERSION_2_1;
                } else {
                    this.log.println((Object)this, 3, "Invalid request: Invalid version specified.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                this.log.println((Object)this, 6, "Protocol version: " + this.protocolVersion);
                String[] stringArray2 = httpServletRequest.getParameterValues("action");
                if (stringArray2 == null || stringArray2.length > 1) {
                    this.log.println((Object)this, 3, "Invalid request: Either the \"action\" parameter was not specified or multiple \"action\" parameters were detected.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                if (stringArray2[0].compareTo("patchDownload") == 0) {
                    String[] stringArray3;
                    String[] stringArray4;
                    String string;
                    Object object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (string.equals("action") || string.equals("patchId") || string.equals("user") || string.equals("passwd") || string.equals("text") || string.equals("maxSize") || string.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: Unknown parameter \"" + string + "\" was detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object = null;
                    string = null;
                    String string2 = "";
                    if (this.protocolVersion.compareTo(VERSION_2_0) == 0) {
                        stringArray4 = httpServletRequest.getParameterValues("user");
                        stringArray3 = httpServletRequest.getParameterValues("passwd");
                        if (stringArray4 != null) {
                            if (stringArray4.length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"user\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray4[0].equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"user\" parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            object = stringArray4[0];
                        }
                        if (stringArray3 != null) {
                            if (stringArray3.length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"passwd\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray3[0].equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"passwd\"  parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            string = stringArray3[0];
                        }
                    }
                    if (this.protocolVersion.compareTo(VERSION_2_0) != 0 && (stringArray3 = httpServletRequest.getParameterValues("maxSize")) != null && stringArray3.length > 0) {
                        this.log.println((Object)this, 7, "maxSize specified: " + stringArray3[0]);
                    }
                    if ((stringArray4 = httpServletRequest.getParameterValues("text")) != null) {
                        if (stringArray4.length > 1) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"text\" parameters were detected.");
                            httpServletResponse.sendError(400);
                            return;
                        }
                        if (stringArray4[0].equals("")) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"text\" parameter.");
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                            httpServletResponse.sendError(400);
                            return;
                        }
                        string2 = stringArray4[0];
                    }
                    if ((stringArray3 = httpServletRequest.getParameterValues("patchId")) == null || object != null && string == null || object == null && string != null) {
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: A required \"patchID\", \"user\" and/or \"passwd\" parameter was not specified");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    PatchListImpl patchListImpl = null;
                    patchListImpl = object != null ? new SecurePatchListImpl((String)object, string, string2) : new PatchListImpl(string2);
                    PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
                    patchInfoImpl.setObsolesces("");
                    patchInfoImpl.setRequires("");
                    patchInfoImpl.setOS("");
                    patchInfoImpl.setProperties(new PatchProperties(""));
                    for (int i = 0; i < stringArray3.length; ++i) {
                        try {
                            patchListImpl.addIPatch(new IPatch(new PatchImpl(patchInfoImpl, new PatchID(stringArray3[i]))));
                            patchListImpl.setSelectionStatus(i, true);
                            continue;
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Exception: " + malformedPatchException);
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 100);
                            httpServletResponse.sendError(500);
                            return;
                        }
                    }
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    httpServletResponse.setContentType("application/octet-stream");
                    PatchBundleInfo[] patchBundleInfoArray = this.patchServerProxy.getDownloadedPatchBundlesInfo(patchListImpl);
                    this.log.println((Object)this, 7, "patchList.size: " + patchListImpl.size());
                    this.log.println((Object)this, 7, "pbinfo: " + patchBundleInfoArray.length);
                    if (patchBundleInfoArray == null) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot access patch bundle information.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 130);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    int n = 200;
                    boolean bl = true;
                    boolean bl2 = true;
                    String string3 = "";
                    String string4 = "";
                    for (int i = 0; i < patchBundleInfoArray.length; ++i) {
                        if (patchBundleInfoArray[i].getPatchBundleSize() < 0L) {
                            if (!bl2) {
                                string4 = string4 + "|";
                            }
                            string4 = string4 + patchBundleInfoArray[i].getPatchBundleName() + "&" + "2";
                            bl2 = false;
                            n = 206;
                            continue;
                        }
                        if (!bl) {
                            string3 = string3 + "|";
                        }
                        string3 = string3 + patchBundleInfoArray[i].getPatchBundleName() + "&" + Long.toString(patchBundleInfoArray[i].getPatchBundleSize());
                        bl = false;
                    }
                    this.log.println((Object)this, 7, "patchFiles: " + string3);
                    this.log.println((Object)this, 7, "rejects: " + string4);
                    httpServletResponse.setHeader("patchFiles", string3);
                    if (this.protocolVersion.compareTo(VERSION_2_1) == 0 && string4.compareTo("") != 0) {
                        httpServletResponse.setHeader("rejects", string4);
                    }
                    httpServletResponse.setStatus(n);
                    try {
                        this.patchServerProxy.downloadPatches(patchListImpl, servletOutputStream);
                    }
                    catch (DownloadPatchException downloadPatchException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot download patch bundle.");
                        this.log.printStackTrace((Object)this, 3, downloadPatchException);
                        servletOutputStream.close();
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 110);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    catch (NotSupportedException notSupportedException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. \"patchDownload\" request is not supported.");
                        this.log.printStackTrace((Object)this, 3, notSupportedException);
                        servletOutputStream.close();
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 120);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    catch (Exception exception) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. ");
                        this.log.printStackTrace((Object)this, 3, exception);
                        servletOutputStream.close();
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    servletOutputStream.close();
                    this.log.println((Object)this, 7, "PatchProServerServlet.patchDownload done. Status: " + n);
                    break block61;
                }
                if (stringArray2[0].compareTo("isCertificateRevoked") == 0) {
                    String[] stringArray5;
                    this.log.println((Object)this, 7, "Received a isCertificateRevoked request.");
                    Object object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        stringArray5 = (String[])object.nextElement();
                        if (stringArray5.equals("action") || stringArray5.equals("serialNumber") || stringArray5.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Unknown parameter \"" + (String)stringArray5 + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object = null;
                    stringArray5 = httpServletRequest.getParameterValues("serialNumber");
                    if (stringArray5 == null) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: The required \"serialNumber\" parameter was not specified.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (stringArray5[0].equals("")) {
                        this.log.println((Object)this, 3, "Invalid  \"isCertificateRevoked\" request: Value was not specified for thespecified \"serialNumber\" parameter.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (stringArray5.length > 1) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Multiple \"serialNumber\" parameters are not allowed.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object = stringArray5[0];
                    if (this.patchServerProxy.isCertificateRevoked((String)object)) {
                        this.log.println((Object)this, 6, "Certificate has been revoked for " + (String)object);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 200);
                    } else {
                        this.log.println((Object)this, 6, "This certificate is good: " + (String)object);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 201);
                    }
                    return;
                }
                if (stringArray2[0].compareTo("downloadPatchDB") == 0) {
                    String string;
                    Object object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (string.equals("action") || string.equals("version") || string.equals("name")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadPatchDB\" request: Unknown parameter \"" + string + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object = httpServletRequest.getParameter("name");
                    if (object == null) {
                        object = DEFAULT_REQUESTED_DB_NAME;
                    }
                    this.log.println((Object)this, 7, "Requested Database Name: " + (String)object);
                    httpServletResponse.setContentType("application/octet-stream");
                    string = httpServletResponse.getOutputStream();
                    try {
                        this.patchServerProxy.downloadPatchDB((String)object, string);
                        break block61;
                    }
                    catch (DownloadPatchDBException downloadPatchDBException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadPatchDB\" request. Cannot download the patch database.");
                        this.log.printStackTrace((Object)this, 3, downloadPatchDBException);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 300);
                        if (downloadPatchDBException.getTargetException() instanceof FileNotFoundException) {
                            httpServletResponse.setStatus(404);
                            httpServletResponse.sendError(404);
                        } else {
                            httpServletResponse.setStatus(500);
                            httpServletResponse.sendError(500);
                        }
                        ((OutputStream)((Object)string)).flush();
                        ((OutputStream)((Object)string)).close();
                        return;
                    }
                }
                if (stringArray2[0].compareTo("downloadRealizationDetectors") == 0) {
                    String string;
                    File file = new File("/tmp/testpp.txt");
                    file.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream("/tmp/testpp.txt");
                    PrintWriter printWriter = new PrintWriter(fileOutputStream);
                    printWriter.print("Testing PatchPro");
                    printWriter.flush();
                    printWriter.close();
                    Object object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (string.equals("action") || string.equals("version") || string.equals("name")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadRealizationDetectors\" request: Unknown parameter \"" + string + "\" detected");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object = httpServletRequest.getParameter("name");
                    if (object == null) {
                        object = DEFAULT_REQUESTED_DETECTORS_NAME;
                    }
                    this.log.println((Object)this, 7, "Requested Detector Name: " + (String)object);
                    httpServletResponse.setContentType("application/octet-stream");
                    string = httpServletResponse.getOutputStream();
                    try {
                        this.patchServerProxy.downloadRealizationDetectors((String)object, string);
                    }
                    catch (DownloadRealizationException downloadRealizationException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadRealizationDetectors\" request. Cannot download realization detectors.");
                        this.log.printStackTrace((Object)this, 3, downloadRealizationException);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 400);
                        if (downloadRealizationException.getTargetException() instanceof FileNotFoundException) {
                            httpServletResponse.setStatus(404);
                            httpServletResponse.sendError(404);
                        } else {
                            httpServletResponse.setStatus(500);
                            httpServletResponse.sendError(500);
                        }
                        ((OutputStream)((Object)string)).flush();
                        ((OutputStream)((Object)string)).close();
                        return;
                    }
                    catch (Exception exception) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadRealizationDetectors\" request. Cannot download realization detectors.");
                        this.log.printStackTrace((Object)this, 3, exception);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                        httpServletResponse.sendError(500);
                        ((OutputStream)((Object)string)).flush();
                        ((OutputStream)((Object)string)).close();
                    }
                    ((OutputStream)((Object)string)).flush();
                    ((OutputStream)((Object)string)).close();
                    this.log.println((Object)this, 7, "PatchProServerServlet.downloadRealizationDetectors done.");
                    break block61;
                }
                if (stringArray2[0].compareTo("getDocumentation") == 0) {
                    this.log.println((Object)this, 7, "Received a getDocumentation request.");
                    Enumeration enumeration = httpServletRequest.getParameterNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (string.equals("action") || string.equals("version") || string.equals("patchId")) continue;
                        this.log.println((Object)this, 3, "Invalid \"getDocumentation\" request: Unknown parameter \"" + string + "\" detected");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    break block61;
                }
                this.log.println((Object)this, 3, "Unknown \"action\" request was specified.");
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                httpServletResponse.sendError(400);
                return;
            }
            catch (IOException iOException) {
                this.log.printStackTrace((Object)this, 3, iOException);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 48);
                httpServletResponse.setStatus(500);
                throw new ServletException(iOException.toString());
            }
            catch (Exception exception) {
                this.log.printStackTrace((Object)this, 3, exception);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                httpServletResponse.setStatus(500);
                throw new ServletException(exception.toString());
            }
        }
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.log = PatchProLog.getInstance();
        this.log.setLogger(new ServletLog(servletConfig.getServletContext()));
        this.properties = new PatchServerServletProperties(servletConfig);
        try {
            this.patchServerProxy = new PatchServerProxy(this.properties);
        }
        catch (PatchServerProxyException patchServerProxyException) {
            // empty catch block
        }
        if (this.properties.getProperty("patchpro.debug", "false").equals("true")) {
            this.log.println((Object)this, 7, "PatchProServerServlet: patchsvr.source.0.url is " + this.properties.getProperty("patchsvr.source.0.url"));
        }
    }

    public void destroy() {
        this.log.println((Object)this, 7, "PatchProServerServlet: destroy...");
        this.log = null;
        this.properties = null;
    }
}

