/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.NoManipulatorException;
import com.sun.patchpro.manipulators.NoSuchImageException;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.SignatureValidationUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class PatchContents
implements Serializable {
    static final long serialVersionUID = -3225839608246384625L;
    private static final String defaultInstallerPackage = "com.sun.patchpro.util.";
    private static final String defaultInstallerSuffix = "PatchInstaller";
    private static final String manipulatorPackage = "com.sun.patchpro.manipulators.";
    private static final String manipulatorSuffix = "Manipulator";
    PatchImpl patch;
    transient PatchProLog log;

    public PatchContents(PatchImpl patchImpl, String string, String string2, PatchProperties patchProperties) {
        this.patch = patchImpl;
        this.log = PatchProLog.getInstance();
        if (patchProperties == null) {
            this.log.printStackTrace(this, 4, new Exception());
        }
    }

    public Manipulable getManipulator(File file, Host host, Host host2, Enumeration enumeration, SignatureValidationUtil signatureValidationUtil) throws NoManipulatorException, NoSuchImageException {
        Manipulator manipulator = this.getRealManipulator(host, host2, enumeration, signatureValidationUtil);
        manipulator.constructCurrent(file);
        return manipulator;
    }

    public Manipulable getManipulator(Host host, Host host2, Enumeration enumeration, SignatureValidationUtil signatureValidationUtil) throws NoManipulatorException {
        return this.getRealManipulator(host, host2, enumeration, signatureValidationUtil);
    }

    protected Manipulator getRealManipulator(Host host, Host host2, Enumeration enumeration, SignatureValidationUtil signatureValidationUtil) throws NoManipulatorException {
        Manipulator manipulator;
        String string = this.patch.getPatchInfo().getType();
        String string2 = host.getType();
        String string3 = host2 == null ? new String(string2 + string) : new String(string2 + "Rmt" + host2.getType() + string);
        String string4 = new String(manipulatorPackage + string3 + manipulatorSuffix);
        try {
            try {
                manipulator = (Manipulator)Class.forName(string4).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string4 = new String("com.sun.patchpro.manipulators.Manipulator");
                manipulator = (Manipulator)Class.forName(string4).newInstance();
            }
        }
        catch (Exception exception) {
            throw new NoManipulatorException("Cannot construct " + string4);
        }
        manipulator.setPatch(this.patch);
        if (host2 == null) {
            manipulator.setHost(host);
        } else {
            manipulator.setHost(host2);
        }
        manipulator.setTargetHardware(enumeration);
        if (signatureValidationUtil != null) {
            manipulator.setValidationUtility(signatureValidationUtil);
        }
        return manipulator;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.log = PatchProLog.getInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

