/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.model.NoDeferredDataException;
import com.sun.patchpro.model.NoUndoElementsException;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.UndoNotPermittedException;
import com.sun.patchpro.util.MalformedStateException;
import com.sun.patchpro.util.NextStateDecoder;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.NoSuchStateException;
import com.sun.patchpro.util.State;
import com.sun.patchpro.util.StateAction;
import com.sun.patchpro.util.StateMachine;
import com.sun.patchpro.util.StateSynchronizer;

public class PatchProStateMachine
extends StateMachine {
    static final int BEGIN = 0;
    static final int RUNTARGETINFO = 1;
    static final int CREATEINTERPRETER = 2;
    static final int DOWNLOADDETECTORS = 3;
    static final int DOWNLOADPATCHDB = 4;
    static final int RUNBASEDATADETECTORS = 5;
    static final int RUNREALIZATIONDETECTORS = 6;
    static final int ASSEMBLEHOST = 7;
    static final int RETRIEVEUNDOSESSION = 8;
    static final int RETRIEVEDEFERREDSESSION = 9;
    static final int RUNSEQUENCER = 10;
    static final int DOWNLOADPATCHES = 11;
    static final int INSTALLPATCHES = 12;
    static final int UNDOLASTSESSION = 13;
    static final int DONE = 14;
    PatchProModel model;
    PatchProProperties properties;
    boolean forceHost = false;
    boolean forcePatchList = false;
    ReadOnlyHost forcedHost;
    StateAction begin = new StateAction(){
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "begin(): started");
            PatchProStateMachine.this.model.begin();
            this.actionState = 2;
            PatchProStateMachine.this.log.println(this, 7, "begin(): finished");
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runTargetInfo = new StateAction(){
        Host host;
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runTargetInfo(): started");
            if (!PatchProStateMachine.this.forceHost) {
                try {
                    this.host = PatchProStateMachine.this.model.runTargetInfo();
                    PatchProStateMachine.this.log.println(this, 7, "model.runTargetInfo() completed returning " + this.host + ".");
                    this.actionState = 2;
                }
                catch (Exception exception) {
                    PatchProStateMachine.this.log.println(this, 2, "runTargetInfo.run(): Error, caught " + exception.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                    this.actionState = 3;
                    state.setException(exception);
                }
                catch (Error error) {
                    PatchProStateMachine.this.log.println(this, 2, "runTargetInfo.run(): Error, caught " + error.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                    this.actionState = 3;
                    state.setError(error);
                }
                catch (Throwable throwable) {
                    PatchProStateMachine.this.log.println(this, 2, "runTargetInfo.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                    this.actionState = 3;
                }
                finally {
                    PatchProStateMachine.this.log.println(this, 7, "runTargetInfo(): finished");
                }
            } else {
                PatchProStateMachine.this.log.println(this, 7, "runTargetInfo(): host forced");
                this.actionState = 2;
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction createInterpreter = new StateAction(){
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "createInterpreter(): started");
            try {
                PatchProStateMachine.this.model.createInterpreter();
                PatchProStateMachine.this.log.println(this, 7, "model.createInterpreter() completed.");
                this.actionState = 2;
            }
            catch (Exception exception) {
                PatchProStateMachine.this.log.println(this, 2, "createInterpreter.run(): Error, caught " + exception.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                this.actionState = 3;
                state.setException(exception);
            }
            catch (Error error) {
                PatchProStateMachine.this.log.println(this, 2, "createInterpreter.run(): Error, caught " + error.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                this.actionState = 3;
                state.setError(error);
            }
            catch (Throwable throwable) {
                PatchProStateMachine.this.log.println(this, 2, "createInterpreter.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                this.actionState = 3;
            }
            finally {
                PatchProStateMachine.this.log.println(this, 7, "createInterpreter(): finished");
            }
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction downloadDetectors = new StateAction(){
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "downloadDetectors(): started");
            try {
                PatchProStateMachine.this.model.downloadDetectors();
                PatchProStateMachine.this.log.println(this, 7, "model.downloadDetectors() completed returning.");
                this.actionState = 2;
            }
            catch (Exception exception) {
                PatchProStateMachine.this.log.println(this, 2, "downloadDetectors.run(): Error, caught " + exception.getMessage() + ".");
                this.actionState = 3;
                PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                state.setException(exception);
            }
            catch (Error error) {
                PatchProStateMachine.this.log.println(this, 2, "downloadDetectors.run(): Error, caught " + error.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                this.actionState = 3;
                state.setError(error);
            }
            catch (Throwable throwable) {
                PatchProStateMachine.this.log.println(this, 2, "downloadDetectors.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                this.actionState = 3;
            }
            finally {
                PatchProStateMachine.this.log.println(this, 7, "downloadDetectors(): finished");
            }
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction downloadPatchDB = new StateAction(){
        int actionState = 0;
        ReadOnlyHost host;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "downloadPatchDB(): started");
            try {
                try {
                    this.host = PatchProStateMachine.this.model.downloadPatchDB();
                    PatchProStateMachine.this.log.println(this, 7, "model.downloadPatchDB() completed returning " + this.host + ".");
                    this.actionState = 2;
                }
                catch (Throwable throwable) {
                    PatchProStateMachine.this.log.println(this, 2, "downloadPatchDB.run(): Error, caught " + throwable.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                    this.actionState = 3;
                    try {
                        state.setException((Exception)throwable);
                    }
                    catch (ClassCastException classCastException) {
                        try {
                            state.setError((Error)throwable);
                        }
                        catch (Exception exception) {
                            PatchProStateMachine.this.log.println(this, 2, "downloadPatchDB.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                            PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                        }
                        PatchProStateMachine.this.log.printStackTrace(this, 2, classCastException);
                    }
                    Object var7_4 = null;
                    PatchProStateMachine.this.log.println(this, 7, "downloadPatchDB(): finished, returning " + this.host);
                }
                Object var7_3 = null;
                PatchProStateMachine.this.log.println(this, 7, "downloadPatchDB(): finished, returning " + this.host);
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                PatchProStateMachine.this.log.println(this, 7, "downloadPatchDB(): finished, returning " + this.host);
                throw throwable;
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runBaseDataDetectors = new StateAction(){
        PatchDB patchDB;
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runBaseDataDetectors(): started");
            if (PatchProStateMachine.this.forceHost) {
                PatchProStateMachine.this.log.println(this, 7, "runBaseDataDetectors(): host forced");
                this.actionState = 2;
            } else {
                try {
                    PatchProStateMachine.this.model.runBaseDataDetectors();
                    PatchProStateMachine.this.log.println(this, 7, "model.runBaseDataDetectors() completed.");
                    this.actionState = 2;
                }
                catch (Exception exception) {
                    PatchProStateMachine.this.log.println(this, 2, "runBaseDataDetectors.run(): Error, caught " + exception.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                    this.actionState = 3;
                    state.setException(exception);
                }
                catch (Error error) {
                    PatchProStateMachine.this.log.println(this, 2, "runBaseDataDetectors.run(): Error, caught " + error.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                    this.actionState = 3;
                    state.setError(error);
                }
                catch (Throwable throwable) {
                    PatchProStateMachine.this.log.println(this, 2, "runBaseDataDetectors.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                    this.actionState = 3;
                }
                finally {
                    PatchProStateMachine.this.log.println(this, 7, "runBaseDataDetectors(): finished");
                }
            }
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runRealizationDetectors = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runRealizationDetectors(): started");
            if (PatchProStateMachine.this.forceHost) {
                PatchProStateMachine.this.log.println(this, 7, "runRealizationDetectors(): host forced");
                this.host = PatchProStateMachine.this.forcedHost;
                this.actionState = 2;
            } else {
                try {
                    if (stateMachine.getStateResult(3) != 2 || stateMachine.getActionResult(3) == null) {
                        PatchProStateMachine.this.log.println(this, 4, "runRealizationDetectors(): Detectors are not downloaded");
                        this.actionState = 4;
                    } else if (stateMachine.getStateResult(5) != 2 || stateMachine.getActionResult(5) == null) {
                        PatchProStateMachine.this.log.println(this, 4, "runRealizationDetectors(): Host is not up-to-date");
                        this.actionState = 4;
                    } else {
                        this.host = PatchProStateMachine.this.model.runRealizationDetectors();
                        PatchProStateMachine.this.log.println(this, 7, "model.runRealizationDetectors() completed returning " + this.host + ".");
                    }
                    this.actionState = 2;
                }
                catch (Exception exception) {
                    PatchProStateMachine.this.log.println(this, 2, "runRealizationDetectors.run(): Error, caught " + exception.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                    this.actionState = 3;
                    state.setException(exception);
                }
                catch (Error error) {
                    PatchProStateMachine.this.log.println(this, 2, "runRealizationDetectors.run(): Error, caught " + error.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                    this.actionState = 3;
                    state.setError(error);
                }
                catch (Throwable throwable) {
                    PatchProStateMachine.this.log.println(this, 2, "runRealizationDetectors.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                    this.actionState = 3;
                }
                finally {
                    PatchProStateMachine.this.log.println(this, 7, "runRealizationDetectors(): finished");
                }
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction assembleHost = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            boolean bl;
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "assembleHost(): started");
            String string = PatchProStateMachine.this.properties.getProperty("patchpro.patch.install.unconditional", "false");
            boolean bl2 = bl = string.compareTo("true") == 0;
            if (PatchProStateMachine.this.forceHost) {
                PatchProStateMachine.this.log.println(this, 7, "assembleHost(): host forced");
                this.host = PatchProStateMachine.this.forcedHost;
                this.actionState = 2;
            } else if (bl || PatchProStateMachine.this.model.isUndoSession()) {
                PatchProStateMachine.this.log.println(this, 7, "assembleHost(): isUnconditional == " + bl + " & isUndoSession == " + PatchProStateMachine.this.model.isUndoSession() + ".");
                this.actionState = 2;
            } else {
                try {
                    this.host = (ReadOnlyHost)PatchProStateMachine.this.getActionResult(6);
                    PatchProStateMachine.this.log.println(this, 7, "getActionResult(RUNREALIZATIONDETECTORS)mreturns " + this.host + ".");
                    this.actionState = 2;
                }
                catch (NoSuchStateException noSuchStateException) {
                    PatchProStateMachine.this.log.println(this, 7, "assembleHost(): Missing state - RUNREALIZATIONDETECTORS");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                    this.actionState = 3;
                    state.setException(noSuchStateException);
                }
                catch (NoResultException noResultException) {
                    PatchProStateMachine.this.log.println(this, 7, "assembleHost(): No realization detectors run despite synchronizer.");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noResultException);
                    this.actionState = 3;
                    state.setException(noResultException);
                }
            }
            PatchProStateMachine.this.log.println(this, 7, "assembleHost(): finished");
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction retrieveUndoSession = new StateAction(){
        Host host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "retrieveUndoSession(): started");
            if (PatchProStateMachine.this.forceHost) {
                PatchProStateMachine.this.log.println(this, 7, "retrieveUndoSession(): host forced");
                this.actionState = 2;
            } else {
                try {
                    this.host = (Host)PatchProStateMachine.this.getActionResult(1);
                    PatchProStateMachine.this.model.populateHostForUndo(this.host);
                    PatchProStateMachine.this.log.println(this, 7, "model.populateHostForUndo(host) completed returning " + this.host + ".");
                    this.actionState = 2;
                }
                catch (UndoNotPermittedException undoNotPermittedException) {
                    PatchProStateMachine.this.log.println(this, 7, "Undo not permitted.");
                    PatchProStateMachine.this.log.printStackTrace(this, 5, undoNotPermittedException);
                    this.actionState = 4;
                    state.setException(undoNotPermittedException);
                }
                catch (NoUndoElementsException noUndoElementsException) {
                    PatchProStateMachine.this.log.println(this, 7, "No undo data.");
                    PatchProStateMachine.this.log.printStackTrace(this, 5, noUndoElementsException);
                    this.actionState = 4;
                    state.setException(noUndoElementsException);
                }
                catch (NoSuchStateException noSuchStateException) {
                    PatchProStateMachine.this.log.println(this, 7, "retrieveUndoSession(): Missing state - RUNBASEDATADETECTORS");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                    this.actionState = 3;
                    state.setException(noSuchStateException);
                }
                catch (NoResultException noResultException) {
                    PatchProStateMachine.this.log.println(this, 7, "retrieveUndoSession(): No base data collected.");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noResultException);
                    this.actionState = 3;
                    state.setException(noResultException);
                }
            }
            PatchProStateMachine.this.log.println(this, 7, "retrieveUndoSession(): finished");
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction retrieveDeferredSession = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "retrieveDeferredSession(): started");
            try {
                this.host = (Host)PatchProStateMachine.this.getActionResult(1);
                this.host = PatchProStateMachine.this.model.populateHostForDeferral(this.host);
                PatchProStateMachine.this.log.println(this, 7, "model.populateHostForDeferral(host) completed returning " + this.host + ".");
                this.actionState = 2;
            }
            catch (NoDeferredDataException noDeferredDataException) {
                PatchProStateMachine.this.log.println(this, 7, "No deferred data.");
                PatchProStateMachine.this.log.printStackTrace(this, 5, noDeferredDataException);
                this.actionState = 4;
                state.setException(noDeferredDataException);
            }
            catch (NoSuchStateException noSuchStateException) {
                PatchProStateMachine.this.log.println(this, 7, "retrieveDeferredSession(): Missing state - RUNBASEDATADETECTORS");
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                this.actionState = 3;
                state.setException(noSuchStateException);
            }
            catch (NoResultException noResultException) {
                PatchProStateMachine.this.log.println(this, 7, "retrieveDeferredSession(): No session.");
                PatchProStateMachine.this.log.printStackTrace(this, 2, noResultException);
                this.actionState = 3;
                state.setException(noResultException);
            }
            PatchProStateMachine.this.log.println(this, 7, "retrieveDeferredSession(): finished");
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runSequencer = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runSequencer(): started");
            try {
                if (stateMachine.getStateResult(4) != 2 || stateMachine.getActionResult(4) == null) {
                    this.actionState = 4;
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): no DOWNLOADPATCHDB");
                } else if (stateMachine.getStateResult(2) != 2 || stateMachine.getActionResult(2) == null) {
                    this.actionState = 4;
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): no CREATEINTERPRETER");
                } else if (!(PatchProStateMachine.this.forceHost || stateMachine.getStateResult(6) == 2 && stateMachine.getActionResult(6) != null)) {
                    this.actionState = 4;
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): no RUNREALIZATIONDETECTORS");
                } else {
                    this.host = PatchProStateMachine.this.model.runSequencer();
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): finished, returning " + this.host);
                    this.actionState = 2;
                }
            }
            catch (Exception exception) {
                PatchProStateMachine.this.log.println(this, 2, "runSequencer.run(): Error, caught " + exception.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                this.actionState = 3;
                state.setException(exception);
            }
            catch (Error error) {
                PatchProStateMachine.this.log.println(this, 2, "runSequencer.run(): Error, caught " + error.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                this.actionState = 3;
                state.setError(error);
            }
            catch (Throwable throwable) {
                PatchProStateMachine.this.log.println(this, 2, "runSequencer.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                this.actionState = 3;
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction downloadPatches = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "downloadPatches(): started");
            try {
                if (!(PatchProStateMachine.this.forcePatchList || stateMachine.getStateResult(10) == 2 && stateMachine.getActionResult(10) != null)) {
                    PatchProStateMachine.this.log.println(this, 7, "downloadPatches(): No patch list supplied  and sequencer has not been run.");
                    this.actionState = 4;
                } else {
                    this.host = PatchProStateMachine.this.model.performPatchDownload();
                    PatchProStateMachine.this.log.println(this, 7, "downloadPatches(): finished, returning " + this.host);
                    this.actionState = 2;
                }
            }
            catch (Exception exception) {
                PatchProStateMachine.this.log.println(this, 2, "downloadPatches.run(): Error, caught " + exception.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                this.actionState = 3;
                state.setException(exception);
            }
            catch (Error error) {
                PatchProStateMachine.this.log.println(this, 2, "downloadPatches.run(): Error, caught " + error.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                this.actionState = 3;
                state.setError(error);
            }
            catch (Throwable throwable) {
                PatchProStateMachine.this.log.println(this, 2, "downloadPatches.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                this.actionState = 3;
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction installPatches = new StateAction(){
        ReadOnlyHost theHost = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "installPatches(): started");
            try {
                if (!(PatchProStateMachine.this.forcePatchList || stateMachine.getStateResult(11) == 2 && stateMachine.getActionResult(11) != null)) {
                    this.actionState = 4;
                } else {
                    this.theHost = PatchProStateMachine.this.model.performPatchInstallation();
                    PatchProStateMachine.this.log.println(this, 7, "installPatches(): finished, returning " + this.theHost);
                    this.actionState = 2;
                }
            }
            catch (Exception exception) {
                PatchProStateMachine.this.log.println(this, 2, "installPatches.run(): Error, caught " + exception.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                this.actionState = 3;
                state.setException(exception);
            }
            catch (Error error) {
                PatchProStateMachine.this.log.println(this, 2, "installPatches.run(): Error, caught " + error.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                this.actionState = 3;
                state.setError(error);
            }
            catch (Throwable throwable) {
                PatchProStateMachine.this.log.println(this, 2, "installPatches.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                this.actionState = 3;
            }
            return this.theHost;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction undoLastSession = new StateAction(){
        ReadOnlyHost theHost = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "undoLastSession(): started");
            try {
                if (!(PatchProStateMachine.this.forcePatchList || stateMachine.getStateResult(8) == 2 && stateMachine.getActionResult(8) != null)) {
                    this.actionState = 4;
                } else {
                    this.theHost = PatchProStateMachine.this.model.performUndoLastSession();
                    PatchProStateMachine.this.log.println(this, 7, "undoLastSession(): finished, returning " + this.theHost);
                    this.actionState = 2;
                }
            }
            catch (Exception exception) {
                PatchProStateMachine.this.log.println(this, 2, "undoLastSession.run(): Error, caught " + exception.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, exception);
                this.actionState = 3;
                state.setException(exception);
            }
            catch (Error error) {
                PatchProStateMachine.this.log.println(this, 2, "undoLastSession.run(): Error, caught " + error.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, error);
                this.actionState = 3;
                state.setError(error);
            }
            catch (Throwable throwable) {
                PatchProStateMachine.this.log.println(this, 2, "undoLastSession.run(): Error, caught some Throwable that was neither an  Error nor an Exception, " + throwable.getMessage() + ".");
                PatchProStateMachine.this.log.printStackTrace(this, 2, throwable);
                this.actionState = 3;
            }
            return this.theHost;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction done = new StateAction(){
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "done()");
            this.actionState = 2;
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    NextStateDecoder baseIfAbbreviated = new NextStateDecoder(){

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray;
            if (PatchProStateMachine.this.model.isAbbreviatedHost()) {
                nArray = new int[]{5};
                PatchProStateMachine.this.log.println(this, 7, "baseIfAbbreviated(): returning RUNBASEDATADETECTORS");
            } else if (PatchProStateMachine.this.model.isBuildingDBOnly()) {
                nArray = new int[]{4};
                PatchProStateMachine.this.log.println(this, 7, "baseIfAbbreviated(): returning DOWNLOADPATCHDB");
            } else {
                nArray = new int[]{5, 3, 4};
                PatchProStateMachine.this.log.println(this, 7, "baseIfAbbreviated(): returning RUNBASEDATADETECTORS, DOWNLOADDETECTORS, DOWNLOADPATCHDB");
            }
            return nArray;
        }
    };
    NextStateDecoder skipIfUnconditional = new NextStateDecoder(){
        int detectorState;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray = new int[1];
            try {
                this.detectorState = stateMachine.getStateResult(5);
                if (this.detectorState == 2) {
                    boolean bl;
                    String string = PatchProStateMachine.this.properties.getProperty("patchpro.patch.install.unconditional", "false");
                    boolean bl2 = bl = string.compareTo("true") == 0;
                    if (PatchProStateMachine.this.model.isUndoSession()) {
                        nArray[0] = 7;
                        PatchProStateMachine.this.log.println(this, 7, "skipIfUnconditional(): returning ASSEMBLEHOST");
                    } else if (bl) {
                        nArray[0] = 7;
                        PatchProStateMachine.this.log.println(this, 7, "skipIfUnconditional(): returning ASSEMBLEHOST");
                    } else if (PatchProStateMachine.this.model.isAbbreviatedHost()) {
                        nArray[0] = 14;
                        PatchProStateMachine.this.log.println(this, 7, "skipIfUnconditional(): returning DONE");
                    } else {
                        nArray[0] = 6;
                        PatchProStateMachine.this.log.println(this, 7, "skipIfUnconditional(): returning RUNREALIZATIONDETECTORS");
                    }
                } else {
                    this.detectorState = stateMachine.getStateResult(5);
                    if (this.detectorState == 4) {
                        nArray[0] = 14;
                        PatchProStateMachine.this.log.println(this, 7, "skipIfUnconditional(): returning DONE");
                    } else {
                        PatchProStateMachine.this.log.println(this, 3, "skipIfUnconditional(): runBaseDataDetectors was neither complete nor inappropriate.");
                        nArray[0] = 0;
                        PatchProStateMachine.this.log.println(this, 7, "skipIfUnconditional(): returning BEGIN");
                    }
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                nArray[0] = 0;
                PatchProStateMachine.this.log.println(this, 7, "skipIfUnconditional(): returning BEGIN");
            }
            return nArray;
        }
    };
    NextStateDecoder undoDeferOrProceed = new NextStateDecoder(){
        int assemblerState;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray = new int[1];
            try {
                this.assemblerState = stateMachine.getStateResult(7);
                if (this.assemblerState == 2) {
                    boolean bl;
                    String string = PatchProStateMachine.this.properties.getProperty("patchpro.patch.install.unconditional", "false");
                    boolean bl2 = bl = string.compareTo("true") == 0;
                    if (PatchProStateMachine.this.model.isUndoSession()) {
                        nArray[0] = 8;
                        PatchProStateMachine.this.log.println(this, 7, "undoDeferOrProceed(): returning RETRIEVEUNDOSESSION");
                    } else if (bl) {
                        nArray[0] = 9;
                        PatchProStateMachine.this.log.println(this, 7, "undoDeferOrProceed(): returning RETRIEVEDEFERREDSESSION");
                    } else {
                        nArray[0] = 2;
                        PatchProStateMachine.this.log.println(this, 7, "undoDeferOrProceed(): returning CREATEINTERPRETER");
                    }
                } else {
                    this.assemblerState = stateMachine.getStateResult(7);
                    if (this.assemblerState == 3) {
                        nArray[0] = 14;
                        PatchProStateMachine.this.log.println(this, 7, "undoDeferOrProceed(): returning DONE");
                    } else {
                        PatchProStateMachine.this.log.println(this, 3, "undoDeferOrProceed(): assembleHost was neither complete nor inappropriate.");
                        nArray[0] = 14;
                        PatchProStateMachine.this.log.println(this, 7, "undoDeferOrProceed(): returning DONE");
                    }
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                nArray[0] = 14;
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
            }
            return nArray;
        }
    };
    NextStateDecoder backoutOrDone = new NextStateDecoder(){
        int retrieveState;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray = new int[1];
            try {
                this.retrieveState = stateMachine.getStateResult(8);
                if (this.retrieveState == 2) {
                    nArray[0] = 13;
                    PatchProStateMachine.this.log.println(this, 7, "backoutOrDone(): returning UNDOLASTSESSION");
                } else {
                    this.retrieveState = stateMachine.getStateResult(5);
                    if (this.retrieveState == 4) {
                        nArray[0] = 14;
                        PatchProStateMachine.this.log.println(this, 7, "backoutOrDone(): returning DONE");
                    } else {
                        PatchProStateMachine.this.log.println(this, 3, "backoutOrDone(): retrieveUndoSession was neither complete nor inappropriate.");
                        nArray[0] = 14;
                        PatchProStateMachine.this.log.println(this, 7, "backoutOrDone(): returning DONE");
                    }
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                nArray[0] = 14;
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                PatchProStateMachine.this.log.println(this, 7, "backoutOrDone(): returning DONE");
            }
            PatchProStateMachine.this.log.println(this, 7, "backoutOrDone(): returning ");
            return nArray;
        }
    };
    NextStateDecoder downloadOrStartOver = new NextStateDecoder(){
        int sequencerState;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray = new int[1];
            try {
                this.sequencerState = stateMachine.getStateResult(10);
                if (this.sequencerState == 2) {
                    nArray[0] = 11;
                    PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning DOWNLOADPATCHES");
                } else {
                    this.sequencerState = stateMachine.getStateResult(10);
                    if (this.sequencerState == 4) {
                        if (PatchProStateMachine.this.forceHost) {
                            if (stateMachine.getStateResult(4) == 2) {
                                nArray[0] = 2;
                                PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning CREATEINTERPRETER");
                            } else {
                                nArray[0] = 4;
                                PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning DOWNLOADPATCHDB");
                            }
                        } else if (stateMachine.getStateResult(7) == 2) {
                            nArray[0] = 2;
                            PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning CREATEINTERPRETER");
                        } else {
                            nArray[0] = 0;
                            PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning BEGIN");
                        }
                    } else {
                        PatchProStateMachine.this.log.println(this, 3, "downloadOrStartOver(): runSequencer was neither complete nor inappropriate.");
                        nArray[0] = 0;
                        PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning BEGIN");
                    }
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                nArray[0] = 0;
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
            }
            PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning " + nArray[0]);
            return nArray;
        }
    };
    NextStateDecoder installOrStartOver = new NextStateDecoder(){
        int downloadResult;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray;
            block8: {
                nArray = new int[1];
                try {
                    this.downloadResult = stateMachine.getStateResult(11);
                    if (this.downloadResult == 2) {
                        nArray[0] = 12;
                        PatchProStateMachine.this.log.println(this, 7, "installOrStartOver(): returning INSTALLPATCHES");
                        break block8;
                    }
                    this.downloadResult = stateMachine.getStateResult(11);
                    if (this.downloadResult == 4) {
                        if (PatchProStateMachine.this.forceHost) {
                            try {
                                if (stateMachine.getStateResult(4) != 2 || stateMachine.getActionResult(4) == null) {
                                    nArray[0] = 4;
                                    PatchProStateMachine.this.log.println(this, 7, "installOrStartOver(): returning DOWNLOADPATCHDB");
                                    break block8;
                                }
                                nArray[0] = 2;
                                PatchProStateMachine.this.log.println(this, 7, "installOrStartOver(): returning CREATEINTERPRETER");
                            }
                            catch (NoResultException noResultException) {
                                nArray[0] = 4;
                                PatchProStateMachine.this.log.println(this, 7, "installOrStartOver(): returning DOWNLOADPATCHDB");
                                PatchProStateMachine.this.log.printStackTrace(this, 2, noResultException);
                            }
                            break block8;
                        }
                        nArray[0] = 0;
                        PatchProStateMachine.this.log.println(this, 7, "installOrStartOver(): returning BEGIN");
                        break block8;
                    }
                    PatchProStateMachine.this.log.println(this, 3, "installOrStartOver(): downloadPatches was neither complete nor inappropriate.");
                    nArray[0] = 0;
                    PatchProStateMachine.this.log.println(this, 7, "installOrStartOver(): returning BEGIN");
                }
                catch (NoSuchStateException noSuchStateException) {
                    nArray[0] = 0;
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                }
            }
            return nArray;
        }
    };
    NextStateDecoder doneOrStartOver = new NextStateDecoder(){
        int installResult;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray;
            block8: {
                nArray = new int[1];
                try {
                    this.installResult = stateMachine.getStateResult(12);
                    if (this.installResult == 2) {
                        nArray[0] = 14;
                        PatchProStateMachine.this.log.println(this, 7, "doneOrStartOver(): returning DONE");
                        break block8;
                    }
                    this.installResult = stateMachine.getStateResult(12);
                    if (this.installResult == 4) {
                        if (PatchProStateMachine.this.forceHost) {
                            try {
                                if (stateMachine.getStateResult(4) != 2 || stateMachine.getActionResult(4) == null) {
                                    nArray[0] = 4;
                                    PatchProStateMachine.this.log.println(this, 7, "doneOrStartOver(): returning DOWNLOADPATCHDB");
                                    break block8;
                                }
                                nArray[0] = 2;
                                PatchProStateMachine.this.log.println(this, 7, "doneOrStartOver(): returning CREATEINTERPRETER");
                            }
                            catch (NoResultException noResultException) {
                                nArray[0] = 4;
                                PatchProStateMachine.this.log.println(this, 7, "doneOrStartOver(): returning DOWNLOADPATCHDB");
                                PatchProStateMachine.this.log.printStackTrace(this, 2, noResultException);
                            }
                            break block8;
                        }
                        nArray[0] = 0;
                        break block8;
                    }
                    PatchProStateMachine.this.log.println(this, 3, "doneOrStartOver(): installPatches was neither complete nor inappropriate.");
                    nArray[0] = 0;
                    PatchProStateMachine.this.log.println(this, 7, "doneOrStartOver(): returning BEGIN");
                }
                catch (NoSuchStateException noSuchStateException) {
                    nArray[0] = 0;
                    PatchProStateMachine.this.log.println(this, 7, "doneOrStartOver(): returning BEGIN");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                }
            }
            return nArray;
        }
    };
    StateSynchronizer hostNDetectorsReady = new StateSynchronizer(){

        public void synchronize(StateMachine stateMachine) {
            try {
                int n;
                int n2;
                PatchProStateMachine.this.log.println(this, 7, "hostNDetectorsReady: started");
                do {
                    n2 = stateMachine.getStateResult(5);
                    n = stateMachine.getStateResult(3);
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                    }
                } while (n2 != 2 || n != 2);
                PatchProStateMachine.this.log.println(this, 7, "hostNDetectorsReady: finished with " + n2 + " & " + n);
                int[] nArray = new int[]{5, 3};
                while (!stateMachine.allDone(nArray)) {
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                    }
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                PatchProStateMachine.this.log.println(this, 3, "hostNDetectorsReady: bad state number");
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
            }
        }
    };
    StateSynchronizer hostNDownloadComplete = new StateSynchronizer(){

        public void synchronize(StateMachine stateMachine) {
            block10: {
                try {
                    int[] nArray;
                    int n;
                    int n2;
                    boolean bl;
                    PatchProStateMachine.this.log.println(this, 7, "hostNDownloadComplete: started");
                    String string = PatchProStateMachine.this.properties.getProperty("patchpro.patch.install.unconditional", "false");
                    boolean bl2 = bl = string.compareTo("true") == 0;
                    if (PatchProStateMachine.this.model.isUndoSession() || bl) break block10;
                    do {
                        n2 = PatchProStateMachine.this.forceHost ? 2 : stateMachine.getStateResult(6);
                        n = stateMachine.getStateResult(4);
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException interruptedException) {
                            PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                        }
                    } while (n2 != 2 || n != 2);
                    PatchProStateMachine.this.log.println(this, 7, "hostNDownloadComplete: finished with " + n2 + " & " + n);
                    if (PatchProStateMachine.this.forceHost) {
                        nArray = new int[]{4};
                    } else {
                        nArray = new int[]{6, 4};
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException interruptedException) {
                            PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                        }
                    }
                    while (!stateMachine.allDone(nArray)) {
                    }
                }
                catch (NoSuchStateException noSuchStateException) {
                    PatchProStateMachine.this.log.println(this, 3, "hostNDownloadComplete: bad state number");
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                }
            }
        }
    };

    public PatchProStateMachine(PatchProProperties patchProProperties, PatchProModel patchProModel) {
        this.properties = patchProProperties;
        this.model = patchProModel;
    }

    public void initialize() {
        this.forceHost = false;
        this.forcePatchList = false;
        try {
            super.initialize();
        }
        catch (MalformedStateException malformedStateException) {
            this.log.printStackTrace(this, 2, malformedStateException);
            throw new Error("State table is broken.");
        }
    }

    public void forceHost(ReadOnlyHost readOnlyHost) {
        this.forceHost = true;
        this.forcedHost = readOnlyHost;
    }

    public void forcePatchList() {
        this.forcePatchList = true;
    }

    protected State[] buildStateTable() throws MalformedStateException {
        State[] stateArray = new State[]{new State((StateMachine)this, true, this.begin, new int[]{1}), new State((StateMachine)this, false, this.runTargetInfo, this.baseIfAbbreviated), new State((StateMachine)this, false, this.createInterpreter, new int[]{10}), new State((StateMachine)this, false, this.downloadDetectors, new int[]{6}), new State((StateMachine)this, false, this.downloadPatchDB, new int[]{7}), new State((StateMachine)this, false, this.runBaseDataDetectors, this.skipIfUnconditional), new State((StateMachine)this, false, this.runRealizationDetectors, this.hostNDetectorsReady, new int[]{7}), new State((StateMachine)this, false, this.assembleHost, this.hostNDownloadComplete, this.undoDeferOrProceed), new State((StateMachine)this, false, this.retrieveUndoSession, this.backoutOrDone), new State((StateMachine)this, false, this.retrieveDeferredSession, new int[]{12}), new State((StateMachine)this, true, this.runSequencer, this.downloadOrStartOver), new State((StateMachine)this, true, this.downloadPatches, this.installOrStartOver), new State((StateMachine)this, true, this.installPatches, this.doneOrStartOver), new State((StateMachine)this, true, this.undoLastSession, new int[]{14}), new State(this, false, this.done)};
        return stateArray;
    }

    public String dumpState() {
        String string = "";
        try {
            string = new String("begin = " + State.stateStateToString(this.getStateResult(0)) + "\n" + "runTargetInfo = " + State.stateStateToString(this.getStateResult(1)) + "\n" + "createInterpreter = " + State.stateStateToString(this.getStateResult(2)) + "\n" + "downloadDetectors = " + State.stateStateToString(this.getStateResult(3)) + "\n" + "downloadPatchDB = " + State.stateStateToString(this.getStateResult(4)) + "\n" + "runBaseDataDetectors = " + State.stateStateToString(this.getStateResult(5)) + "\n" + "assembleHost = " + State.stateStateToString(this.getStateResult(7)) + "\n" + "retrieveUndoSession = " + State.stateStateToString(this.getStateResult(8)) + "\n" + "retrieveDeferredSession = " + State.stateStateToString(this.getStateResult(9)) + "\n" + "runSequencer = " + State.stateStateToString(this.getStateResult(10)) + "\n" + "downloadPatches = " + State.stateStateToString(this.getStateResult(11)) + "\n" + "installPatches = " + State.stateStateToString(this.getStateResult(12)) + "\n" + "undoLastSession = " + State.stateStateToString(this.getStateResult(13)) + "\n" + "done = " + State.stateStateToString(this.getStateResult(14)) + "\n");
        }
        catch (NoSuchStateException noSuchStateException) {
            this.log.printStackTrace(this, 2, noSuchStateException);
        }
        return string;
    }
}

