/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.HostSpecificProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchProProperties {
    protected ClassLoader cl = (class$com$sun$patchpro$model$PatchProProperties == null ? (class$com$sun$patchpro$model$PatchProProperties = PatchProProperties.class$("com.sun.patchpro.model.PatchProProperties")) : class$com$sun$patchpro$model$PatchProProperties).getClassLoader();
    private static String primaryConfFileString = "/etc/opt/SUNWppro/etc/patchpro.conf";
    private static String defaultConfFileString = "etc" + System.getProperty("file.separator") + "patchpro.conf";
    private static String DEFAULTPROPERTIES = System.getProperty("file.separator") + "com" + System.getProperty("file.separator") + "sun" + System.getProperty("file.separator") + "patchpro" + System.getProperty("file.separator") + "conf" + System.getProperty("file.separator") + "PatchPro.properties";
    private static String PATCHPROJARFILE = "patchpro.jar";
    protected static Properties props;
    private static PatchProProperties ppprops;
    private static final String sccsID = "1.28";
    protected static PatchProLog log;
    protected Locale locale = null;
    protected String localeString;
    private File actualConfFile = null;
    private String passwd;
    static final String NO_INSTALL_ALLOWED = "Policy does not allow installation of patches.";
    static final String KEYSTORE_LOCATION_NOT_DEFINED = "patchpro.security.kslocation is not defined.";
    static final String KEYSTORE_DOES_NOT_EXIST = "patchpro.security.kslocation is defined but the file does not exist.";
    private boolean[] interactive = new boolean[2];
    private boolean[] singleuser = new boolean[2];
    private boolean[] rebootafter = new boolean[2];
    private boolean[] reconfigafter = new boolean[2];
    private boolean[] rebootimmediate = new boolean[2];
    private boolean[] reconfigimmediate = new boolean[2];
    private boolean[] nonstandard = new boolean[2];
    private boolean[] discontinued = new boolean[2];
    private boolean[] pointpatch = new boolean[2];
    private boolean[] obsolete = new boolean[2];
    private boolean[] standard = new boolean[2];
    private boolean[] noncontract = new boolean[2];
    private boolean[] clientroot = new boolean[2];
    private boolean[] clientusr = new boolean[2];
    static /* synthetic */ Class class$com$sun$patchpro$model$PatchProProperties;

    protected PatchProProperties(Properties properties) {
        props = properties;
        log = PatchProLog.getInstance();
    }

    protected PatchProProperties() {
        this(defaultConfFileString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PatchProProperties(String string) {
        boolean bl = false;
        if (props == null) {
            props = new Properties();
        }
        log = PatchProLog.getInstance();
        if (string.length() == 0) {
            bl = true;
        }
        try {
            if (!bl) {
                BufferedReader bufferedReader;
                Object object;
                File file = new File(string);
                if (!file.isAbsolute()) {
                    object = this.getFullPathFileStr(string);
                    if (((String)object).compareTo("") == 0) throw new IOException("\nUnable to locate ..." + string + " file.\n" + "Verify that the runtime environment has been setup " + "correctly to use PatchPro.\nProcess terminating!");
                    file = new File((String)object);
                    props.load(new FileInputStream(file));
                    props.setProperty("patchpro.default.conf.file", (String)object);
                } else {
                    if (!file.exists()) throw new IOException("\nUnable to locate " + file + ".\n" + "Verify that the runtime environment has been setup " + "correctly to use PatchPro.\nProcess terminating!");
                    this.load(new FileInputStream(file));
                }
                this.actualConfFile = file;
                if (this.getProperty("patchpro.installdir.sdb") == null) {
                    throw new IOException("\nA corrupt PatchPro configuration file was detected.\nThe \"patchpro.installdir.sdb\" property, which was created by the PatchPro setup installation script, is undefined.\n");
                }
                if (this.getProperty("patchpro.installdir.apcy") == null) {
                    throw new IOException("\nA corrupt PatchPro configuration file was detected.\nThe \"patchpro.installdir.apcy\" property, which was created by the PatchPro setup installation script, is undefined.\n");
                }
                if (this.getProperty("patchpro.installdir.ppro") == null) {
                    throw new IOException("\nA corrupt PatchPro configuration file was detected.\nThe \"patchpro.installdir.ppro\" property, which was created by the PatchPro setup installation script, is undefined.\n");
                }
                String string2 = props.getProperty("test.patchpro.passwd.file");
                object = string2 == null ? new File(props.getProperty("patchpro.installdir.ppro") + "/lib/.sunsolvepw") : new File(string2);
                if (((File)object).exists() && ((File)object).canRead()) {
                    bufferedReader = new BufferedReader(new FileReader((File)object));
                    this.passwd = bufferedReader.readLine();
                    if (this.passwd != null) {
                        this.setProperty("patchpro.sunsolve.passwd", this.passwd);
                    }
                }
                bufferedReader = null;
                object = null;
                this.passwd = null;
                object = new File(this.getProperty("patchpro.installdir.ppro") + "/lib/.proxypw");
                if (((File)object).exists() && ((File)object).canRead()) {
                    bufferedReader = new BufferedReader(new FileReader((File)object));
                    this.passwd = bufferedReader.readLine();
                    if (this.passwd != null) {
                        this.setProperty("patchpro.proxy.passwd", this.passwd);
                    }
                }
            } else {
                this.load(this.getClass().getResourceAsStream(DEFAULTPROPERTIES));
            }
        }
        catch (IOException iOException) {
            throw new Error("PatchProProperties(): Problem detected while defining PatchPro properties." + iOException.getMessage());
        }
        this.localeString = this.getProperty("patchpro.locale");
        if (this.localeString == null || this.localeString.length() == 0) {
            this.localeString = Locale.getDefault().toString();
            if (this.localeString.length() == 0) {
                this.localeString = "C";
            }
        }
        ppprops = this;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getFullPathFileStr(String string) {
        String string2;
        Character c;
        File file;
        String string3 = "";
        String string4 = System.getProperty("file.separator");
        URL uRL = null;
        String string5 = null;
        String string6 = null;
        StringTokenizer stringTokenizer = null;
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(DEFAULTPROPERTIES);
        uRL = this.cl.getResource(stringBuffer.substring(1));
        if (uRL == null) {
            log.println(this, 4, "A Uniform Resource locator (URL) for the PatchPro resource\nto locate does not exists.Attempting to locate PatchPro configuration file using CLASSPATH");
            return this.getFullPathFromClassPath(string);
        }
        stringTokenizer = new StringTokenizer(uRL.getFile(), ":!");
        if (!stringTokenizer.hasMoreTokens()) {
            log.println(this, 4, "Attempting to locate PatchPro configuration file using the effective CLASSPATH");
            return this.getFullPathFromClassPath(string);
        }
        string5 = stringTokenizer.nextToken();
        if (string5.compareTo("file") == 0) {
            if (!stringTokenizer.hasMoreTokens()) {
                log.println(this, 4, "Unexpected URL format detected.\nExpected <path> part to PatchPro resource is unavailable.\nAttempting to locate PatchPro configuration file using the effective CLASSPATH");
                return this.getFullPathFromClassPath(string);
            }
            string6 = stringTokenizer.nextToken();
        } else {
            if (string5.compareTo("http") == 0) {
                log.println(this, 3, "Unexpected URL format detected.\nProtocol type \"file\" was expected instead of " + string5 + "\nEnsure that the class path to the local " + "\"patchpro.jar\" file precedes all other possible" + " class paths that can access PatchPro resources.");
                return string3;
            }
            string6 = string5;
        }
        stringBuffer = new StringBuffer(string6);
        if (string5.compareTo(string6) != 0 && (string6.length() < PATCHPROJARFILE.length() || stringBuffer.substring(string6.length() - PATCHPROJARFILE.length()).compareTo(PATCHPROJARFILE) != 0)) {
            log.println(this, 4, "PatchPro resource found but not in the \"patchpro.jar\" file.Attempting to locate PatchPro configuration file using the effective CLASSPATH");
            return this.getFullPathFromClassPath(string);
        }
        File file2 = new File(stringBuffer.toString());
        File file3 = (file2 = file2.getParentFile()).getParentFile();
        if (file3 == null) {
            file3 = file2;
        }
        if ((file = (c = new Character((string2 = file3.toString()).charAt(string2.length() - 1))).equals(string4) ? new File(file3, string) : new File(file3, string4 + string)).exists()) {
            return file.toString();
        }
        return this.getFullPathFromClassPath(string);
    }

    protected String getFullPathFromClassPath(String string) {
        String string2 = "";
        String string3 = System.getProperty("file.separator");
        String string4 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), string4);
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            Character c;
            File file;
            File file2;
            String string6 = stringTokenizer.nextToken();
            File file3 = new File(string6);
            if (!file3.isDirectory()) {
                file3 = file3.getParentFile();
            }
            if ((file2 = file3.getParentFile()) == null || !(file = (c = new Character((string5 = file2.toString()).charAt(string5.length() - 1))).equals(string3) ? new File(file2, string) : new File(file2, string3 + string)).exists()) continue;
            return file.toString();
        }
        return string2;
    }

    public synchronized Object setProperty(String string, String string2) {
        if (string.compareTo("patchpro.patch.interactive.patchtype") == 0) {
            this.setPatchProperties(true, string2);
        } else if (string.compareTo("patchpro.patch.install.patchtype") == 0) {
            this.setPatchProperties(false, string2);
        }
        return props.setProperty(string, string2);
    }

    public Enumeration propertyNames() {
        return props.propertyNames();
    }

    public void load(InputStream inputStream) throws IOException {
        props.load(inputStream);
        String string = "patchpro.patch.interactive.patchtype";
        String string2 = this.getProperty(string, "");
        this.setPatchProperties(true, string2);
        string = "patchpro.patch.install.patchtype";
        string2 = this.getProperty(string, "");
        this.setPatchProperties(false, string2);
    }

    public void list(PrintStream printStream) {
        props.list(printStream);
    }

    public void list(PrintWriter printWriter) {
        props.list(printWriter);
    }

    public void save(OutputStream outputStream, String string) {
        props.save(outputStream, string);
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        props.store(outputStream, string);
    }

    public String getProperty(String string) {
        return props.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public synchronized Object setProperty(String string, String string2, String string3) {
        String string4 = string2.indexOf("patchpro.") == 0 ? new String("patchpro." + string + string2.substring(8)) : string2;
        return props.setProperty(string4, string3);
    }

    public synchronized PatchProProperties getHostSpecificProperties(ReadOnlyHost readOnlyHost) {
        HostSpecificProperties hostSpecificProperties = new HostSpecificProperties(this.localeString, readOnlyHost, props);
        return hostSpecificProperties;
    }

    public synchronized Locale getLocale() {
        if (this.locale == null || this.localeString.compareTo(this.getProperty("patchpro.locale")) != 0) {
            this.localeString = this.getProperty("patchpro.locale");
            StringTokenizer stringTokenizer = new StringTokenizer(this.localeString, "_", true);
            String[] stringArray = new String[3];
            String string = "";
            String string2 = "";
            int n = 0;
            for (int i = 0; i < 3; ++i) {
                stringArray[i] = "";
            }
            while (stringTokenizer.hasMoreTokens()) {
                if (n == 2 && stringTokenizer.countTokens() > 0) {
                    string = stringTokenizer.nextToken();
                    if (stringTokenizer.countTokens() > 0) {
                        string = stringTokenizer.nextToken("\t\n\r\f");
                    }
                } else {
                    string = stringTokenizer.nextToken();
                }
                if (string.equals("_")) {
                    if (string2.equals("") || string2.equals("_")) {
                        stringArray[n++] = "";
                    }
                } else {
                    stringArray[n++] = string;
                }
                string2 = string;
            }
            this.locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
        }
        return this.locale;
    }

    public void useAlternate(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.getConfigDirectory(), string);
        }
        if (file.exists()) {
            this.load(new FileInputStream(file));
        } else {
            file.createNewFile();
        }
        this.actualConfFile = file;
    }

    public void dump() {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            log.println(this, 7, string + " = " + props.getProperty(string));
        }
    }

    public String toString() {
        return props.toString() + "(" + sccsID + ")";
    }

    public File getConfigDirectory() {
        return this.actualConfFile.getParentFile();
    }

    public static PatchProProperties getInstance() {
        Object var0 = null;
        String string = new File(primaryConfFileString).canRead() ? primaryConfFileString : defaultConfFileString;
        if (props == null || ppprops == null) {
            ppprops = new PatchProProperties(string);
        }
        return ppprops;
    }

    public static PatchProProperties getInstance(String string) {
        Object var1_1 = null;
        String string2 = string;
        if (props == null || ppprops == null) {
            ppprops = new PatchProProperties(string2);
        }
        return ppprops;
    }

    public static void freeInstance() {
        ppprops = null;
        props = null;
    }

    public synchronized void update(String string, String string2) throws Exception {
        try {
            PrintStream printStream;
            BufferedReader bufferedReader;
            if (this.actualConfFile.exists()) {
                String string3;
                File file = new File(this.actualConfFile.getPath() + ".tmp");
                bufferedReader = new BufferedReader(new FileReader(this.actualConfFile));
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                printStream = new PrintStream(fileOutputStream);
                boolean bl = false;
                while ((string3 = bufferedReader.readLine()) != null) {
                    int n = string3.indexOf("=");
                    if (n > -1) {
                        String string4 = string3.substring(0, n);
                        if (string4.equals(string)) {
                            StringBuffer stringBuffer = new StringBuffer(string4);
                            stringBuffer.append("=").append(string2);
                            printStream.println(stringBuffer.toString());
                            bl = true;
                            continue;
                        }
                        printStream.println(string3);
                        continue;
                    }
                    printStream.println(string3);
                }
                if (!bl) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer.append("=").append(string2);
                    printStream.println(stringBuffer.toString());
                }
                fileOutputStream.close();
                if (!file.renameTo(this.actualConfFile)) {
                    throw new IOException("Error : Failed to update - " + this.actualConfFile.toString());
                }
            } else {
                props.store(new FileOutputStream(this.actualConfFile), "Created " + this.actualConfFile.toString());
                throw new Exception(this.actualConfFile.toString() + " is non-existent. " + "\nCreated " + this.actualConfFile.toString());
            }
            bufferedReader.close();
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Error in updating configuration file\n" + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new IOException("Error in updating configuration file\n" + iOException.getMessage());
        }
    }

    public synchronized void lock(String string) throws Exception {
        try {
            File file = new File(this.actualConfFile.getPath() + ".lock");
            if (!file.createNewFile()) {
                throw new Exception("PatchPro is in use by another process.");
            }
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string);
            fileOutputStream.close();
            printStream.close();
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public boolean installIsAllowed(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (this.mayStandard(bl) || this.maySingleuser(bl) || this.mayReconfigafter(bl) || this.mayRebootafter(bl) || this.mayReconfigimmediate(bl) || this.mayRebootimmediate(bl) || this.mayInteractive(bl)) {
                bl2 = true;
            }
        } else if (this.mayStandard(bl) || this.maySingleuser(bl) || this.mayReconfigafter(bl) || this.mayRebootafter(bl) || this.mayReconfigimmediate(bl) || this.mayRebootimmediate(bl)) {
            bl2 = true;
        }
        if (!bl2) {
            log.println(this, 7, NO_INSTALL_ALLOWED);
        }
        if (this.getProperty("patchpro.debug").compareTo("true") == 0) {
            if (bl) {
                System.out.println("Parse(patchpro.patch.interactive.patchtype) -> \"" + this.getProperty("patchpro.patch.interactive.patchtype") + "\"");
            } else {
                System.out.println("Parse(patchpro.patch.install.patchtype) -> \"" + this.getProperty("patchpro.patch.install.patchtype") + "\"");
            }
        }
        return bl2;
    }

    public boolean installAuthenticationRequired() {
        boolean bl = this.getProperty("patchpro.patch.install.authenticate", "true").equals("true");
        return bl;
    }

    public boolean downloadAuthenticationRequired() {
        boolean bl = this.getProperty("patchpro.patch.download.authenticate", "true").equals("true");
        return bl;
    }

    public boolean keystoreIsPresent() {
        boolean bl = true;
        String string = this.getProperty("patchpro.security.kslocation");
        if (string == null) {
            bl = false;
            log.println(this, 2, KEYSTORE_LOCATION_NOT_DEFINED);
        }
        if (!new File(string).exists()) {
            bl = false;
            log.println(this, 2, KEYSTORE_DOES_NOT_EXIST);
        }
        return bl;
    }

    protected void setPatchProperties(boolean bl, String string) {
        Vector<String> vector = new Vector<String>();
        int n = bl ? 0 : 1;
        this.interactive[n] = false;
        this.singleuser[n] = false;
        this.rebootafter[n] = false;
        this.reconfigafter[n] = false;
        this.rebootimmediate[n] = false;
        this.reconfigimmediate[n] = false;
        this.nonstandard[n] = false;
        this.discontinued[n] = false;
        this.pointpatch[n] = false;
        this.obsolete[n] = false;
        this.standard[n] = false;
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                vector.add(string2);
                if (string2.equals("standard")) {
                    this.standard[n] = true;
                }
                if (string2.equals("singleuser")) {
                    this.singleuser[n] = true;
                }
                if (string2.equals("reconfigafter")) {
                    this.reconfigafter[n] = true;
                }
                if (string2.equals("rebootafter")) {
                    this.rebootafter[n] = true;
                }
                if (string2.equals("reconfigimmediate")) {
                    this.reconfigimmediate[n] = true;
                }
                if (string2.equals("rebootimmediate")) {
                    this.rebootimmediate[n] = true;
                }
                if (string2.equals("interactive")) {
                    this.interactive[n] = true;
                }
                if (string2.equals("nonstandard")) {
                    this.nonstandard[n] = true;
                }
                if (string2.equals("discontinued")) {
                    this.discontinued[n] = true;
                }
                if (string2.equals("pointpatch")) {
                    this.pointpatch[n] = true;
                }
                if (string2.equals("obsolete")) {
                    this.obsolete[n] = true;
                }
                if (string2.equals("clientroot")) {
                    this.clientroot[n] = true;
                }
                if (string2.equals("clientusr")) {
                    this.clientusr[n] = true;
                }
                if (!string2.equals("noncontract")) continue;
                this.noncontract[n] = true;
            }
        }
    }

    public boolean mayStandard(boolean bl) {
        return bl ? this.standard[0] : this.standard[1];
    }

    public boolean mayRebootafter(boolean bl) {
        return bl ? this.rebootafter[0] : this.rebootafter[1];
    }

    public boolean mayReconfigafter(boolean bl) {
        return bl ? this.reconfigafter[0] : this.reconfigafter[1];
    }

    public boolean mayRebootimmediate(boolean bl) {
        return bl ? this.rebootimmediate[0] : this.rebootimmediate[1];
    }

    public boolean mayReconfigimmediate(boolean bl) {
        return bl ? this.reconfigimmediate[0] : this.reconfigimmediate[1];
    }

    public boolean mayInteractive(boolean bl) {
        return bl ? this.interactive[0] : this.interactive[1];
    }

    public boolean maySingleuser(boolean bl) {
        return bl ? this.singleuser[0] : this.singleuser[1];
    }

    public boolean mayNonstandard(boolean bl) {
        return bl ? this.nonstandard[0] : this.nonstandard[1];
    }

    public boolean mayDiscontinued(boolean bl) {
        return bl ? this.discontinued[0] : this.discontinued[1];
    }

    public boolean mayPointpatch(boolean bl) {
        return bl ? this.pointpatch[0] : this.pointpatch[1];
    }

    public boolean mayObsolete(boolean bl) {
        return bl ? this.obsolete[0] : this.obsolete[1];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

