/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.manipulators.SunOSRemover;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.LocalizedMessages;
import java.util.GregorianCalendar;

public class SunOSSunPatchRemover
extends SunOSRemover {
    protected Manipulator manipulator = null;
    protected LocalizedMessages msgcat = null;

    public SunOSSunPatchRemover(Manipulator manipulator, PatchProProperties patchProProperties) throws RemoveFailedException {
        super(manipulator, patchProProperties);
        this.manipulator = manipulator;
        this.msgcat = new LocalizedMessages(patchProProperties.getLocale());
    }

    public void remove() {
        this.initializeProgress(0.0, 2.0);
        try {
            try {
                this.removeSunOSPatch();
            }
            catch (InteractiveSessionException interactiveSessionException) {
                this.incrementProgress(1.0);
                throw new InteractiveSessionException(interactiveSessionException.getMessage());
            }
            this.incrementProgress(1.0);
        }
        catch (InteractiveSessionException interactiveSessionException) {
            this.log.printStackTrace(this, 2, interactiveSessionException);
            this.issueFail(new PatchInstallFailedException(interactiveSessionException.getMessage()));
            System.out.println("Diagnostic Messages:\n" + interactiveSessionException.getMessage());
        }
        this.incrementProgress(1.0);
    }

    public void removeSunOSPatch() throws InteractiveSessionException {
        int n = -1;
        String string = "";
        String string2 = this.activePatch.getPatchID().getPatchID();
        String string3 = this.properties.getProperty("SunOS.command.remove.patch", "/usr/sbin/patchrm");
        String string4 = string3 + " " + string2;
        if (this.debug) {
            System.out.println("Remove command string: " + string4);
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.add(12, 60);
            CommandSession commandSession = new CommandSession();
            commandSession.start(string4);
            while (gregorianCalendar.before(gregorianCalendar2)) {
                try {
                    n = commandSession.getProcessExitValue();
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    gregorianCalendar = null;
                    gregorianCalendar = new GregorianCalendar();
                }
            }
            string = commandSession.getAllSessionMessages();
            commandSession.stop();
            commandSession.cleanup();
            Object[] objectArray = new String[]{new Integer(n).toString()};
            try {
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new Exception(this.msgcat.getMessage("patchrm_01", objectArray, "patchrm exitcode=" + n + ". Usage error."));
                    }
                    case 2: {
                        throw new Exception(this.msgcat.getMessage("patchrm_02", objectArray, "patchrm exitcode=" + n + ". Attempt to backout a patch that " + "hasn't been applied."));
                    }
                    case 3: {
                        throw new Exception(this.msgcat.getMessage("patchrm_03", objectArray, "patchrm exitcode=" + n + ". Effective UID is not root."));
                    }
                    case 4: {
                        throw new Exception(this.msgcat.getMessage("patchrm_04", objectArray, "patchrm exitcode=" + n + ". No saved files to restore."));
                    }
                    case 5: {
                        throw new Exception(this.msgcat.getMessage("patchrm_05", objectArray, "patchrm exitcode=" + n + ". pkgrm failed."));
                    }
                    case 6: {
                        throw new Exception(this.msgcat.getMessage("patchrm_06", objectArray, "patchrm exitcode=" + n + ". Attempt to back out an obsoleted patch."));
                    }
                    case 7: {
                        throw new Exception(this.msgcat.getMessage("patchrm_07", objectArray, "patchrm exitcode=" + n + ". Attempt to restore CPIO archived files failed."));
                    }
                    case 8: {
                        throw new Exception(this.msgcat.getMessage("patchrm_08", objectArray, "patchrm exitcode=" + n + ". Invalid patch id format."));
                    }
                    case 9: {
                        throw new Exception(this.msgcat.getMessage("patchrm_09", objectArray, "patchrm exitcode=" + n + ". Prebackout script failed."));
                    }
                    case 10: {
                        throw new Exception(this.msgcat.getMessage("patchrm_10", objectArray, "patchrm exitcode=" + n + ". Postbackout script failed."));
                    }
                    case 11: {
                        throw new Exception(this.msgcat.getMessage("patchrm_11", objectArray, "patchrm exitcode=" + n + ". Suspended due to administrative defaults."));
                    }
                    case 12: {
                        throw new Exception(this.msgcat.getMessage("patchrm_12", objectArray, "patchrm exitcode=" + n + ". Patchrm could not locate the backout data."));
                    }
                    case 13: {
                        throw new Exception(this.msgcat.getMessage("patchrm_13", objectArray, "patchrm exitcode=" + n + ". The relative directory supplied can't be found."));
                    }
                    case 14: {
                        throw new Exception(this.msgcat.getMessage("patchrm_14", objectArray, "patchrm exitcode=" + n + ". Patchadd has been interrupted, re-invoke patchadd."));
                    }
                    case 15: {
                        throw new Exception(this.msgcat.getMessage("patchrm_15", objectArray, "patchrm exitcode=" + n + ". This patch is required by a patch " + "already installed, can't back it out."));
                    }
                    case 16: {
                        throw new Exception(this.msgcat.getMessage("patchrm_16", objectArray, "patchrm exitcode=" + n + ". Unable to create safe temporary directory."));
                    }
                    case 17: {
                        throw new Exception(this.msgcat.getMessage("patchrm_17", objectArray, "patchrm exitcode=" + n + ". Must be running Solaris 2.6 or greater."));
                    }
                    default: {
                        throw new Exception(this.msgcat.getMessage("patchrm_unknown", objectArray, "patchrm exitcode=" + n));
                    }
                }
            }
            catch (Exception exception) {
                throw new InteractiveSessionException(exception.getMessage() + "Session Diagnostic Messages:\n\n" + string);
            }
        }
    }
}

