/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.manipulators.CannotDeferException;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.NoSuchImageException;
import com.sun.patchpro.manipulators.Removable;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.manipulators.SunOSSunPatchInstaller;
import com.sun.patchpro.manipulators.SunOSSunPatchRemover;
import com.sun.patchpro.manipulators.Verifiable;
import com.sun.patchpro.manipulators.VerifyFailedException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.SignatureValidationUtil;
import java.io.File;
import java.io.IOException;

public class SunOSSunPatchManipulator
extends Manipulator {
    public SunOSSunPatchManipulator() throws NoSuchImageException, NoKeystorePresentException, NoSigningCertException {
    }

    public SunOSSunPatchManipulator(Patch patch, Host host, SignatureValidationUtil signatureValidationUtil) throws NoSuchImageException, NoKeystorePresentException, NoSigningCertException {
        super(patch, host, null, signatureValidationUtil);
    }

    public Installable getInstaller() throws InstallFailedException {
        return new SunOSSunPatchInstaller(this, this.properties);
    }

    public Verifiable getVerifier() throws VerifyFailedException {
        throw new VerifyFailedException("This Manipulator can't verify.");
    }

    public void defer() throws CannotDeferException {
        String string = null;
        File file = null;
        if (string == null) {
            string = this.properties.getProperty("patchpro.patch.sequester.directory", "/var/spool/pkg/patchproSequester");
        }
        file = new File(string);
        if (!this.smpatch) {
            System.out.println(this.msgcat.getMessage("PatchBundleInstaller.defering", "Defering") + " " + this.currentImage.getPath());
        }
        try {
            this.move(new File(file, this.currentImage.getName()));
        }
        catch (IOException iOException) {
            throw new CannotDeferException(iOException.getMessage());
        }
    }

    public Removable getRemover() throws RemoveFailedException {
        return new SunOSSunPatchRemover(this, this.properties);
    }

    public int getStrategy(boolean bl) {
        PatchProperties patchProperties = this.activePatch.getPatchInfo().getProperties();
        int n = bl ? 4 : 3;
        if (this.properties.installIsAllowed(bl)) {
            n = 1;
            if (!this.mustFail(bl, patchProperties)) {
                if (bl) {
                    if (patchProperties.isDiscontinued() && !this.properties.mayDiscontinued(bl)) {
                        n = 4;
                    } else if (patchProperties.isPointpatch() && !this.properties.mayPointpatch(bl)) {
                        n = 4;
                    } else if (patchProperties.isObsolete() && !this.properties.mayObsolete(bl)) {
                        n = 4;
                    } else if (patchProperties.isInteractive() && !this.properties.mayInteractive(bl)) {
                        n = 4;
                    } else if (patchProperties.isSingleuser() && !this.properties.maySingleuser(bl)) {
                        n = 4;
                    } else if (patchProperties.isRebootimmediate() && !this.properties.mayRebootimmediate(bl)) {
                        n = 4;
                    } else if (patchProperties.isReconfigimmediate() && !this.properties.mayReconfigimmediate(bl)) {
                        n = 4;
                    } else if (patchProperties.isRebootafter() && !this.properties.mayRebootafter(bl)) {
                        n = 4;
                    } else if (patchProperties.isReconfigafter() && !this.properties.mayReconfigafter(bl)) {
                        n = 4;
                    } else if (patchProperties.isNonstandard()) {
                        n = 4;
                    }
                } else if (!this.rebootIsPossible()) {
                    if (patchProperties.isSingleuser() && !this.properties.maySingleuser(bl)) {
                        n = 3;
                    } else if (patchProperties.isRebootafter() && !this.properties.mayRebootafter(bl)) {
                        n = 3;
                    } else if (patchProperties.isReconfigafter() && !this.properties.mayReconfigafter(bl)) {
                        n = 3;
                    } else if (patchProperties.isRebootimmediate() || patchProperties.isReconfigimmediate() || patchProperties.isNonstandard() || patchProperties.isInteractive()) {
                        n = 3;
                    }
                } else if (patchProperties.isInteractive()) {
                    n = this.properties.mayInteractive(bl) ? 2 : 3;
                } else if (patchProperties.isSingleuser()) {
                    n = this.properties.maySingleuser(bl) ? 2 : 3;
                } else if (patchProperties.isRebootafter()) {
                    n = this.properties.mayRebootafter(bl) ? 2 : 3;
                } else if (patchProperties.isReconfigafter()) {
                    n = this.properties.mayReconfigafter(bl) ? 2 : 3;
                } else if (patchProperties.isRebootimmediate()) {
                    n = this.properties.mayRebootimmediate(bl) ? 2 : 3;
                } else if (patchProperties.isReconfigimmediate()) {
                    n = this.properties.mayReconfigimmediate(bl) ? 2 : 3;
                } else if (patchProperties.isNonstandard()) {
                    n = 3;
                }
            } else {
                n = 4;
            }
        }
        if (this.debug) {
            System.out.println("getStrategy() returns " + n);
        }
        this.log.println(this, 7, "getStrategy() returns " + n);
        return n;
    }

    public int getRemoveStrategy(boolean bl) {
        PatchProperties patchProperties = this.activePatch.getPatchInfo().getProperties();
        PatchID patchID = this.activePatch.getPatchID();
        Removable removable = null;
        try {
            removable = this.getRemover();
        }
        catch (RemoveFailedException removeFailedException) {
            this.log.println(this, 1, "There is no appropriate Remover Object.");
            this.log.printStackTrace(this, 7, removeFailedException);
        }
        int n = 10;
        if (bl) {
            n = 5;
            if (!this.targetHost.hasExactPatchID(patchID)) {
                n = 6;
            } else if (removable == null) {
                n = 8;
                this.problemMessage = this.msgcat.getMessage("Removerfault.MESSAGE", "there is no procedure for removing this patch.");
            } else if (patchProperties.isRebootimmediate() && !this.properties.mayRebootimmediate(bl)) {
                n = 9;
                this.problemMessage = this.msgcat.getMessage("Forbidden.rebootimmediate.MESSAGE", "Policy forbids rebootimmediate patches to be removed in interactive mode.");
                this.remedyMessage = this.msgcat.getMessage("Forbidden.rebootimmediate.REMEDY", "Update the patch policy to permit the removal of rebootimmediate patches in interactive mode");
            } else if (patchProperties.isRebootafter() && !this.properties.mayRebootafter(bl)) {
                n = 9;
                this.problemMessage = this.msgcat.getMessage("Forbidden.rebootafter.MESSAGE", "Policy forbids rebootafter patches to be removed in interactive mode.");
                this.remedyMessage = this.msgcat.getMessage("Forbidden.rebootafter.REMEDY", "Update the patch policy to permit the removal of rebootafter patches in interactive mode.");
            } else if (patchProperties.isSingleuser() && !this.properties.maySingleuser(bl)) {
                n = 9;
                this.problemMessage = this.msgcat.getMessage("Forbidden.singleuser.MESSAGE", "Policy forbids singleuser patches to be removed in interactive mode.");
                this.remedyMessage = this.msgcat.getMessage("Forbidden.singleuser.REMEDY", "Update the patch policy to permit the removal of singleuser patches in interactive mode.");
            } else if (patchProperties.isReconfigimmediate() && !this.properties.mayReconfigimmediate(bl)) {
                n = 9;
                this.problemMessage = this.msgcat.getMessage("Forbidden.reconfigimmediate.MESSAGE", "Policy forbids reconfigimmediate patches to be removed in interactive mode.");
                this.remedyMessage = this.msgcat.getMessage("Forbidden.reconfigimmediate.REMEDY", "Update the patch policy to permit the removal of reconfigimmediate patches in interactive mode.");
            } else if (patchProperties.isReconfigafter() && !this.properties.mayReconfigafter(bl)) {
                n = 9;
                this.problemMessage = this.msgcat.getMessage("Forbidden.reconfigafter.MESSAGE", "Policy forbids reconfigafter patches to be removed in interactive mode.");
                this.remedyMessage = this.msgcat.getMessage("Forbidden.reconfigafter.REMEDY", "Update the patch installation policy to permit the removal of reconfigafter patches in interactive mode.");
            } else if (patchProperties.isInteractive() && !this.properties.mayInteractive(bl)) {
                n = 9;
                this.problemMessage = this.msgcat.getMessage("Forbidden.interactive.MESSAGE", "Policy forbids interactive patches to be removed in interactive mode.");
                this.remedyMessage = this.msgcat.getMessage("Forbidden.interactive.REMEDY", "Update the patch installation policy to permit the removal of interactive patches in interactive mode.");
            } else if (patchProperties.isNonstandard()) {
                n = 9;
                this.problemMessage = this.msgcat.getMessage("Forbidden.nonstandard.MESSAGE", "Policy forbids nonstandard patches to be removed in interactive mode.");
                this.remedyMessage = this.msgcat.getMessage("Forbidden.nonstandard.REMEDY", "Update the patch installation policy to permit the removal of nonstandard patches in interactive mode.");
            } else if (this.patchIsBlocked()) {
                n = 10;
            }
        }
        if (this.debug) {
            System.out.println("getRemoveStrategy() returns " + n);
        }
        return n;
    }

    private boolean rebootIsPossible() {
        boolean bl = false;
        boolean bl2 = this.properties.getProperty("patchpro.control.reboot.allowed").compareTo("true") == 0;
        int n = 0;
        String string = this.properties.getProperty("patchpro.control.reboot.at.time");
        if (string != null && string.compareTo("0:00-0:00") != 0) {
            n = 2;
        }
        if (bl2 && n > 0) {
            bl = true;
        }
        return bl;
    }

    private boolean mustFail(boolean bl, PatchProperties patchProperties) {
        boolean bl2 = false;
        if (!bl && (patchProperties.isDiscontinued() || patchProperties.isPointpatch() || patchProperties.isObsolete())) {
            bl2 = true;
        }
        return bl2;
    }
}

